/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.utilities;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.eclipse.osee.ote.define.parser.BaseOutfileParser;
import org.osgi.framework.Bundle;

public class OutfileParserExtensionManager {
    private static final String OUTFILE_PARSER = "OutfileParser";
    private static final String CLASS_NAME = "classname";
    private static final String SUPPORTED_EXTENSIONS = "supportedExtensions";
    private final Map<String, BaseOutfileParser> contributions = new HashMap<String, BaseOutfileParser>();
    private final HashCollectionSet<String, BaseOutfileParser> extensionsToParsers = new HashCollectionSet(HashSet::new);
    private static OutfileParserExtensionManager instance = null;

    private OutfileParserExtensionManager() {
    }

    public static OutfileParserExtensionManager getInstance() {
        if (instance == null) {
            instance = new OutfileParserExtensionManager();
        }
        return instance;
    }

    public String[] getSupportedExtensions() {
        this.checkObjectsLoaded();
        Set set = this.extensionsToParsers.keySet();
        return set.toArray(new String[set.size()]);
    }

    public BaseOutfileParser getOutfileParserFor(URL fileToImport) {
        this.checkObjectsLoaded();
        BaseOutfileParser toReturn = null;
        for (BaseOutfileParser parser : this.getOutfileParsers()) {
            if (!parser.isValidParser(fileToImport)) continue;
            toReturn = parser;
            break;
        }
        if (toReturn == null) {
            throw new OseeStateException("Unsupported outfile type [%s] no valid outfile parser found", new Object[]{fileToImport});
        }
        return toReturn;
    }

    public BaseOutfileParser getOutfileParserById(String id) {
        this.checkObjectsLoaded();
        return this.contributions.get(id);
    }

    public Collection<BaseOutfileParser> getOutfileParsers() {
        this.checkObjectsLoaded();
        return this.contributions.values();
    }

    private void checkObjectsLoaded() {
        if (this.contributions.isEmpty()) {
            List elements = ExtensionPoints.getExtensionElements((String)"org.eclipse.osee.ote.define.OutfileParser", (String)OUTFILE_PARSER);
            for (IConfigurationElement element : elements) {
                IExtension extension = (IExtension)element.getParent();
                String identifier = extension.getUniqueIdentifier();
                String bundleName = element.getContributor().getName();
                String parserClassName = element.getAttribute(CLASS_NAME);
                String supportedExtensions = element.getAttribute(SUPPORTED_EXTENSIONS);
                Set<String> supportedSet = this.getSupportedExtensions(supportedExtensions);
                BaseOutfileParser parser = (BaseOutfileParser)this.loadClass(bundleName, parserClassName);
                if (parser == null) continue;
                this.contributions.put(identifier, parser);
                for (String extensionType : supportedSet) {
                    this.extensionsToParsers.put((Object)extensionType, (Object)parser);
                }
            }
        }
    }

    private Set<String> getSupportedExtensions(String rawExtensions) {
        HashSet<String> toReturn = new HashSet<String>();
        String[] stringArray = rawExtensions.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (Strings.isValid((String)(value = value.trim()))) {
                toReturn.add(value);
            }
            ++n2;
        }
        return toReturn;
    }

    private Object loadClass(String bundleName, String className) {
        Object object = null;
        if (Strings.isValid((String)bundleName) && Strings.isValid((String)className)) {
            try {
                Bundle bundle = Platform.getBundle((String)bundleName);
                Class taskClass = bundle.loadClass(className);
                try {
                    Method getInstance = taskClass.getMethod("getInstance", new Class[0]);
                    object = getInstance.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    object = taskClass.newInstance();
                }
            }
            catch (Exception ex) {
                throw new OseeCoreException(String.format("Unable to Load: [%s - %s]", bundleName, className), (Throwable)ex);
            }
        }
        return object;
    }
}

