/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.WorkflowMetrics;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IAtsMetricsProvider;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionExceptionComposite;
import org.eclipse.osee.framework.ui.skynet.widgets.XDate;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.xbargraph.XBarGraphLine;
import org.eclipse.osee.framework.ui.skynet.widgets.xbargraph.XBarGraphTable;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AtsMetricsComposite
extends ScrolledComposite {
    private Composite metricsComposite;
    private final IAtsMetricsProvider iAtsMetricsProvider;
    private final Color BACKGROUND_COLOR = Displays.getSystemColor((int)1);
    private final Color FOREGROUND_COLOR = Displays.getSystemColor((int)9);
    private final Composite mainComp;
    private boolean refreshedOnce = true;
    private XDate estimatedReleaseXDate;

    public AtsMetricsComposite(IAtsMetricsProvider iAtsMetricsProvider, Composite parent, int style) {
        super(parent, style | 0x200 | 0x100);
        this.iAtsMetricsProvider = iAtsMetricsProvider;
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(1808));
        this.mainComp = new Composite((Composite)this, 0);
        this.mainComp.setLayout((Layout)new GridLayout());
        this.mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.adapt(this.mainComp);
        if (DbConnectionExceptionComposite.dbConnectionIsOk((Composite)this.mainComp)) {
            this.adapt((Composite)this);
            this.creatToolBar(this.mainComp);
            this.setContent((Control)this.mainComp);
            this.setExpandHorizontal(true);
            this.setExpandVertical(true);
            this.layout();
        }
    }

    private void creatToolBar(Composite composite) {
        Composite toolBarComposite = new Composite(composite, 0);
        toolBarComposite.setLayoutData((Object)new GridData(0, 0, true, false, 1, 1));
        toolBarComposite.setLayout((Layout)new GridLayout(4, false));
        this.adapt(toolBarComposite);
        Button refresh = new Button(toolBarComposite, 8);
        refresh.setText("Display/Refresh Metrics");
        refresh.setToolTipText("Recalculate and Update Metrics");
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AtsMetricsComposite.this.handleUpdateMetrics();
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
        this.adapt((Control)refresh);
        this.estimatedReleaseXDate = new XDate("Estimated Release Date - Override");
        this.estimatedReleaseXDate.createWidgets(toolBarComposite, 2);
        this.adapt((Control)this.estimatedReleaseXDate.getLabelWidget());
        if (!this.refreshedOnce) {
            Label label = new Label(toolBarComposite, 0);
            label.setText("        Last Updated: " + DateUtil.getMMDDYYHHMM());
            this.adapt((Control)label);
        }
    }

    public void handleUpdateMetrics() {
        this.refreshedOnce = false;
        if (this.metricsComposite != null) {
            this.metricsComposite.dispose();
        }
        this.metricsComposite = new Composite(this.mainComp, 0);
        this.metricsComposite.setLayoutData((Object)new GridData(1808));
        this.metricsComposite.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)true));
        this.adapt(this.metricsComposite);
        this.addSpace();
        try {
            if (this.estimatedReleaseXDate.getDate() == null && this.iAtsMetricsProvider.getMetricsVersion() != null && AtsApiService.get().getVersionService().getEstimatedReleaseDate(this.iAtsMetricsProvider.getMetricsVersion()) != null) {
                this.estimatedReleaseXDate.setDate(AtsApiService.get().getVersionService().getEstimatedReleaseDate(this.iAtsMetricsProvider.getMetricsVersion()));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        WorkflowMetrics sMet = new WorkflowMetrics(this.iAtsMetricsProvider.getMetricsWorkItems(), this.iAtsMetricsProvider.getMetricsVersion(), this.iAtsMetricsProvider.getManHoursPerDayPreference(), this.getEstimatedReleaseDate());
        this.createOverviewChart(sMet, this.metricsComposite);
        this.addSpace();
        this.createHoursRemainingByAssigneesChart(sMet, this.metricsComposite);
        this.addSpace();
        this.createCompletedByAssigneesChart(sMet, this.metricsComposite);
        this.mainComp.layout();
        this.computeScrollSize();
    }

    private Date getEstimatedReleaseDate() {
        if (this.estimatedReleaseXDate != null && this.estimatedReleaseXDate.getDate() != null) {
            return this.estimatedReleaseXDate.getDate();
        }
        if (this.iAtsMetricsProvider.getMetricsVersion() != null) {
            return AtsApiService.get().getVersionService().getEstimatedReleaseDate(this.iAtsMetricsProvider.getMetricsVersion());
        }
        for (Artifact artifact : this.iAtsMetricsProvider.getMetricsWorkItems()) {
            Date estRelDate;
            IAtsVersion verArt;
            if (!(artifact instanceof IAtsTeamWorkflow) || (verArt = AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)((IAtsTeamWorkflow)artifact))) == null || (estRelDate = AtsApiService.get().getVersionService().getEstimatedReleaseDate(verArt)) == null) continue;
            return estRelDate;
        }
        return null;
    }

    public void computeScrollSize() {
        this.computeScrollSize(this.mainComp);
    }

    private void computeScrollSize(Composite viewableArea) {
        this.setMinSize(viewableArea.computeSize(-1, -1));
    }

    private void addSpace() {
        Label label = new Label(this.metricsComposite, 0);
        label.setText(" ");
        this.adapt((Control)label);
    }

    public void createOverviewChart(WorkflowMetrics sMet, Composite parent) {
        ArrayList<XBarGraphLine> lines = new ArrayList<XBarGraphLine>();
        lines.add(XBarGraphLine.getTextLine((String)"Loaded", (String)sMet.toStringObjectBreakout()));
        lines.add(XBarGraphLine.getTextLineRedIfTrue((String)"Workflows", (String)String.format("Estimates off %d workflows with %d having 0 estimates.", sMet.getNumSMAs(), sMet.getNumNotEstimated()), (sMet.getNumNotEstimated() > 0 ? 1 : 0) != 0));
        lines.add(XBarGraphLine.getPercentLine((String)("By Workflow Percents (" + sMet.getCummulativeWorkflowPercentComplete() + "/" + sMet.getNumSMAs() + ")"), (int)((int)sMet.getPercentCompleteByWorkflowPercents())));
        lines.add(XBarGraphLine.getPercentLine((String)("By Number of Workflows (" + sMet.getCompletedWorkflows().size() + "/" + sMet.getNumSMAs() + ")"), (int)((int)sMet.getPercentCompleteByWorkflow())));
        lines.add(XBarGraphLine.getTextLine((String)"Estimated Hours: ", (String)String.format("%5.2f Hours", sMet.getEstHours())));
        lines.add(XBarGraphLine.getTextLine((String)"Remaining Hours: ", (String)String.format("%5.2f Hours = (Estimated hours %5.2f - (Estimated hours %5.2f x Percent Complete %5.2f))", sMet.getHrsRemainFromEstimates(), sMet.getEstHours(), sMet.getEstHours(), sMet.getPercentCompleteByWorkflowPercents())));
        lines.add(XBarGraphLine.getTextLine((String)"Hours Spent: ", (String)String.format("%5.2f Hours", sMet.getHrsSpent())));
        lines.add(XBarGraphLine.getTextLine((String)"Hours Per Man Day Preference: ", (String)String.format("%5.2f Hours per Day", sMet.getHoursPerManDay())));
        lines.add(XBarGraphLine.getTextLine((String)"Work Days Needed: ", (String)String.format("%5.2f Days = Remaining Hours %5.2f / Hours Per Day of %5.2f", sMet.getManDaysNeeded(), sMet.getHrsRemainFromEstimates(), sMet.getHoursPerManDay())));
        try {
            lines.add(new XBarGraphLine("Targeted Version", 0, this.iAtsMetricsProvider.getMetricsVersion() == null ? "Not Set" : this.iAtsMetricsProvider.getMetricsVersion().getName()));
            String estimatedReleaseDateStr = this.iAtsMetricsProvider.getMetricsVersion() == null || AtsApiService.get().getVersionService().getEstimatedReleaseDate(this.iAtsMetricsProvider.getMetricsVersion()) == null ? "Not Set" : AtsApiService.get().getVersionService().getEstimatedReleaseDate(this.iAtsMetricsProvider.getMetricsVersion()).toString();
            lines.add(new XBarGraphLine("Targeted Version - Estimated Release Date", 0, this.iAtsMetricsProvider.getMetricsVersion() == null ? "Not Set" : estimatedReleaseDateStr));
            lines.add(new XBarGraphLine("Metrics Estimated Release Date", 0, this.getEstimatedReleaseDate() == null ? "Not Set" : this.getEstimatedReleaseDate().toString()));
            lines.add(new XBarGraphLine("Work-Days Till Release", 0, this.getEstimatedReleaseDate() == null ? "Estimated Release Date Not Set" : sMet.getDaysTillRelStr()));
            double hoursTillRelease = sMet.getHoursTillRel();
            lines.add(new XBarGraphLine("Hours Till Release", 0, this.getEstimatedReleaseDate() == null ? "Estimated Release Date Not Set" : sMet.getHoursTillRelStr()));
            double hoursRemainingFromEstimates = sMet.getHrsRemainFromEstimates();
            int percent = 0;
            if (hoursTillRelease != 0.0) {
                percent = (int)(hoursRemainingFromEstimates / hoursTillRelease);
            }
            if (sMet.getEstRelDate() == null) {
                lines.add(new XBarGraphLine("Release Effort Remaining", 0, "Estimated Release Date Not Set"));
            } else if (hoursRemainingFromEstimates > hoursTillRelease) {
                lines.add(new XBarGraphLine("Release Effort Remaining", 3, 7, 100L, String.format("%5.2f hours exceeds remaining release hours %5.2f;  Over by %5.2f hours.", hoursRemainingFromEstimates, hoursTillRelease, hoursRemainingFromEstimates - hoursTillRelease)));
            } else {
                lines.add(new XBarGraphLine("Release Effort Remaining", 5, 7, 1, 1, percent, String.format("%5.2f remaining work hours", hoursRemainingFromEstimates), String.format("%5.2f release remaining hours", hoursRemainingFromEstimates)));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        XBarGraphTable table = new XBarGraphTable("Overview", "Item", "Value", lines);
        table.setFillHorizontally(true);
        table.createWidgets(parent, 1);
        this.adapt((XWidget)table);
    }

    public void createCompletedByAssigneesChart(WorkflowMetrics sMet, Composite parent) {
        ArrayList<XBarGraphLine> lines = new ArrayList<XBarGraphLine>();
        for (AtsUser user : sMet.getAssigneesAssignedOrCompleted()) {
            try {
                int numCompleted = sMet.getUserToCompletedSmas(user).size();
                double cummulativePercentComplete = numCompleted * 100;
                int numInWork = sMet.getUserToAssignedSmas(user).size();
                HashSet<Artifact> processedArts = new HashSet<Artifact>();
                if (sMet.getUserToAssignedSmas().getValues((Object)user) != null) {
                    for (Artifact awa : (Set)sMet.getUserToAssignedSmas().getValues((Object)user)) {
                        if (processedArts.contains(awa) || sMet.getUserToCompletedSmas().containsValue((Object)awa)) continue;
                        cummulativePercentComplete += (double)PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)((IAtsWorkItem)awa), (AtsApi)AtsApiService.get());
                        processedArts.add(awa);
                    }
                }
                int numTotal = numCompleted + numInWork;
                int percentCompleteByNumber = 0;
                if (numCompleted == numTotal) {
                    percentCompleteByNumber = 100;
                } else if (numCompleted != 0 && numTotal != 0) {
                    double percent = (double)numCompleted / (double)numTotal * 100.0;
                    percentCompleteByNumber = (int)percent;
                }
                int percentCompleteByPercents = 0;
                if (cummulativePercentComplete == 0.0) {
                    percentCompleteByPercents = 0;
                } else if (numTotal == 0) {
                    percentCompleteByPercents = 100;
                } else {
                    double percent = cummulativePercentComplete / (double)numTotal;
                    percentCompleteByPercents = (int)percent;
                }
                lines.add(XBarGraphLine.getPercentLineBlueGreen((String)(String.valueOf(user.getName()) + " by Percents (" + cummulativePercentComplete + "/" + numTotal + ")"), (int)percentCompleteByPercents));
                lines.add(XBarGraphLine.getPercentLineBlueGreen((String)(String.valueOf(user.getName()) + " by Number of Workflows (" + numCompleted + "/" + numTotal + ")"), (int)percentCompleteByNumber));
            }
            catch (Exception ex) {
                lines.add(XBarGraphLine.getTextLine((String)user.getName(), (String)("Exception: " + ex.getLocalizedMessage())));
            }
        }
        XBarGraphTable table = new XBarGraphTable("Completed by Assignee per Assigned Workflow (Team, Task and Review)", "User", "Percent Complete", lines);
        table.setFillHorizontally(true);
        table.createWidgets(parent, 1);
        this.adapt((XWidget)table);
    }

    public void createHoursRemainingByAssigneesChart(WorkflowMetrics sMet, Composite parent) {
        ArrayList<XBarGraphLine> lines = new ArrayList<XBarGraphLine>();
        Double hoursRemain = null;
        if (sMet.getEstRelDate() != null) {
            hoursRemain = sMet.getHoursTillRel();
        }
        for (AtsUser user : sMet.getAssigneesAssignedOrCompleted()) {
            try {
                double userHoursRemain = 0.0;
                for (TeamWorkFlowArtifact team : sMet.getTeamArts()) {
                    double hours;
                    HashSet users = new HashSet();
                    users.addAll(team.getStateMgr().getAssignees());
                    if (!users.contains(user) || !((hours = AtsApiService.get().getEarnedValueService().getRemainHoursTotal((IAtsWorkItem)team)) > 0.0)) continue;
                    userHoursRemain += hours / (double)users.size();
                }
                if (sMet.getEstRelDate() == null) {
                    lines.add(new XBarGraphLine(user.getName(), (int)userHoursRemain, String.format("%5.2f - (Estimated release date not set)", userHoursRemain)));
                    continue;
                }
                if (hoursRemain == null) {
                    lines.add(new XBarGraphLine(user.getName(), (int)userHoursRemain, String.format("%5.2f", userHoursRemain)));
                    continue;
                }
                if (userHoursRemain == 0.0) {
                    lines.add(new XBarGraphLine(user.getName(), 5, 7, 100L, "No Estimated Hours Remain"));
                    continue;
                }
                if (userHoursRemain > hoursRemain) {
                    lines.add(new XBarGraphLine(user.getName(), 3, 7, (long)((int)userHoursRemain > 1 ? (int)userHoursRemain : 1), String.format("%5.2f - Exceeds release remaining hours %5.2f.", userHoursRemain, hoursRemain)));
                    continue;
                }
                lines.add(new XBarGraphLine(user.getName(), 5, 7, (long)((int)userHoursRemain), String.format("%5.2f - Within remaining hours %5.2f.", userHoursRemain, hoursRemain)));
            }
            catch (OseeCoreException ex) {
                lines.add(new XBarGraphLine(user.getName(), 0, "Exception: " + ex.getLocalizedMessage()));
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        XBarGraphTable table = new XBarGraphTable("Hours Remaining by Assignee (green = within remaining hours; red = exceeds remaining hours till release)", "User", "Hours Remaining", lines);
        table.setFillHorizontally(true);
        table.createWidgets(parent, 1);
        this.adapt((XWidget)table);
    }

    public void adapt(XWidget xWidget) {
        this.adapt(xWidget.getControl());
        this.adapt((Control)xWidget.getLabelWidget());
    }

    public void adapt(Control control) {
        if (control == null) {
            return;
        }
        control.setBackground(this.BACKGROUND_COLOR);
        control.setForeground(this.FOREGROUND_COLOR);
    }

    public void adapt(Composite composite) {
        composite.setBackground(this.BACKGROUND_COLOR);
    }
}

