/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.actions.wizard.NewActionWizard;
import org.eclipse.osee.ats.ide.editor.tab.members.IMemberProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.ui.PlatformUI;

public class NewActionToGoalAction
extends Action {
    private final CollectorArtifact collectorArt;
    private final ISelectedAtsArtifacts selectedAtsArtifacts;
    private final IMemberProvider memberProvider;

    public NewActionToGoalAction(IMemberProvider memberProvider, CollectorArtifact collectorArt, ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Create New Action At This Location");
        this.memberProvider = memberProvider;
        this.collectorArt = collectorArt;
        this.selectedAtsArtifacts = selectedAtsArtifacts;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.NEW_ACTION);
    }

    public void run() {
        try {
            List<Artifact> selected = this.selectedAtsArtifacts.getSelectedAtsArtifacts();
            final Artifact dropTarget = selected.isEmpty() ? null : (Artifact)selected.iterator().next();
            LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
            if (this.memberProvider.isBacklog() || this.memberProvider.isSprint()) {
                Artifact agileTeam = null;
                agileTeam = this.memberProvider.isBacklog() ? this.collectorArt.getRelatedArtifact(AtsRelationTypes.AgileTeamToBacklog_AgileTeam) : this.collectorArt.getRelatedArtifact(AtsRelationTypes.AgileTeamToSprint_AgileTeam);
                List atsTeams = agileTeam.getRelatedArtifacts(AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam);
                for (Artifact atsTeam : atsTeams) {
                    for (Artifact ai : atsTeam.getRelatedArtifacts(AtsRelationTypes.TeamActionableItem_ActionableItem)) {
                        ais.add((IAtsActionableItem)AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)ai));
                    }
                }
            }
            NewActionWizard wizard = new NewActionWizard();
            if (!ais.isEmpty()) {
                wizard.getSelectableAis(ais);
            }
            wizard.setNewActionListener(new INewActionListener(){

                public void teamCreated(IAtsAction action, IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
                    List related = NewActionToGoalAction.this.collectorArt.getRelatedArtifacts(NewActionToGoalAction.this.memberProvider.getMemberRelationTypeSide());
                    if (!related.contains(teamWf.getStoreObject())) {
                        changes.relate((Object)NewActionToGoalAction.this.collectorArt, NewActionToGoalAction.this.memberProvider.getMemberRelationTypeSide(), (Object)teamWf.getStoreObject());
                    }
                    if (dropTarget != null) {
                        NewActionToGoalAction.this.collectorArt.setRelationOrder(NewActionToGoalAction.this.memberProvider.getMemberRelationTypeSide(), dropTarget, false, AtsApiService.get().getQueryServiceIde().getArtifact(teamWf));
                        if (NewActionToGoalAction.this.collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                            AtsApiService.get().getGoalMembersCache().decache((GoalArtifact)NewActionToGoalAction.this.collectorArt);
                        } else if (NewActionToGoalAction.this.memberProvider.isSprint()) {
                            AtsApiService.get().getSprintItemsCache().decache((SprintArtifact)NewActionToGoalAction.this.collectorArt);
                        }
                    }
                    changes.add((Object)NewActionToGoalAction.this.collectorArt);
                }
            });
            wizard.setOpenOnComplete(false);
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public String getText() {
        return this.selectedAtsArtifacts.getSelectedWorkflowArtifacts().isEmpty() ? "Create New Action at End" : "Create New Action At This Location";
    }

    public void refreshText() {
        this.setText(this.getText());
    }

    public static interface RemovedFromCollectorHandler {
        public void removedFromCollector(Collection<? extends Artifact> var1);
    }
}

