/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.action;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractAtsArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;

public class ActionArtifact
extends AbstractAtsArtifact
implements IAtsAction {
    public ActionArtifact(BranchId branch) {
        this(AtsArtifactTypes.Action);
    }

    public ActionArtifact(Long id, String guid, BranchToken branch, ArtifactTypeToken artifactType) {
        super(id, guid, branch, artifactType);
    }

    public ActionArtifact(ArtifactTypeToken artifactType) {
        super(Lib.generateId(), null, CoreBranches.COMMON, artifactType);
    }

    public Set<IAtsActionableItem> getActionableItems() {
        HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
        for (TeamWorkFlowArtifact team : this.getTeams()) {
            aias.addAll(AtsApiService.get().getActionableItemService().getActionableItems((IAtsWorkItem)team));
        }
        return aias;
    }

    public Collection<TeamWorkFlowArtifact> getTeams() {
        return this.getRelatedArtifactsUnSorted(AtsRelationTypes.ActionToWorkflow_TeamWorkflow, TeamWorkFlowArtifact.class);
    }

    public TeamWorkFlowArtifact getFirstTeam() {
        if (this.getRelatedArtifactsCount(AtsRelationTypes.ActionToWorkflow_TeamWorkflow) > 0) {
            return this.getTeams().iterator().next();
        }
        return null;
    }

    public Collection<IAtsTeamWorkflow> getTeamWorkflows() {
        return Collections.castAll(this.getTeams());
    }

    public String getAtsId() {
        String toReturn = this.getIdString();
        try {
            toReturn = this.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.AtsId, toReturn);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
        }
        return toReturn;
    }

    public void setAtsId(String atsId) {
        this.setSoleAttributeFromString((AttributeTypeId)AtsAttributeTypes.AtsId, atsId);
    }

    @Override
    public ArtifactToken getStoreObject() {
        return this;
    }

    @Override
    public AtsApi getAtsApi() {
        return AtsApiService.get();
    }

    public Collection<WorkType> getWorkTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean isWorkType(WorkType workType) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getTags() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTag(String tag) {
        throw new UnsupportedOperationException();
    }
}

