/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workdef.config.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.model.impl.AtsObject;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public abstract class AtsConfigObject
extends AtsObject
implements IAtsConfigObject {
    protected final Artifact artifact;
    private final AtsApiIde atsClient;

    public AtsConfigObject(AtsApiIde atsClient, Artifact artifact) {
        super(artifact.getName(), (long)artifact.getArtId());
        this.atsClient = atsClient;
        this.artifact = artifact;
        this.setStoreObject((ArtifactToken)artifact);
    }

    public void setFullName(String fullName) {
        this.artifact.setName(fullName);
    }

    public abstract String getTypeName();

    public String getFullName() {
        return this.getTypeName();
    }

    public void setActionable(boolean actionable) {
        this.artifact.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Actionable, (Object)actionable);
    }

    public boolean isActionable() {
        return (Boolean)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.Actionable, false);
    }

    protected <T> T getAttributeValue(AttributeTypeId attributeType, Object defaultValue) {
        Object value = null;
        try {
            value = this.artifact.getSoleAttributeValue(attributeType, defaultValue);
        }
        catch (OseeCoreException ex) {
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error getting attribute value for - attributeType[%s]", (Object[])new Object[]{attributeType});
        }
        return (T)value;
    }

    public void setActive(boolean active) {
        this.artifact.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Actionable, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, false);
    }

    public Collection<AtsUser> getLeads() {
        return this.getRelatedUsers(AtsRelationTypes.TeamLead_Lead);
    }

    public Collection<AtsUser> getSubscribed() {
        return this.getRelatedUsers(AtsRelationTypes.SubscribedUser_User);
    }

    protected Collection<AtsUser> getRelatedUsers(RelationTypeSide relation) {
        HashSet<AtsUser> results = new HashSet<AtsUser>();
        try {
            for (Artifact userArt : this.artifact.getRelatedArtifacts(relation)) {
                AtsUser lead = this.getAtsClient().getUserService().getUserByUserId((String)userArt.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId));
                results.add(lead);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error getting related Users for relationTypeSide[%s]", (Object[])new Object[]{relation});
        }
        return results;
    }

    protected AtsApiIde getAtsClient() {
        return this.atsClient;
    }

    public ArtifactToken getStoreObject() {
        return this.artifact != null ? this.artifact : super.getStoreObject();
    }

    public Long getId() {
        return this.artifact.getArtId();
    }
}

