/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.walker.ActionWalkerView;
import org.eclipse.osee.ats.ide.walker.GoalMemberWrapper;
import org.eclipse.osee.ats.ide.walker.ReviewWrapper;
import org.eclipse.osee.ats.ide.walker.SprintMemberWrapper;
import org.eclipse.osee.ats.ide.walker.TaskWrapper;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;

public class ActionWalkerContentProvider
implements IGraphEntityContentProvider {
    private final ActionWalkerView view;

    public ActionWalkerContentProvider(ActionWalkerView view) {
        this.view = view;
    }

    private boolean isTopArtifactGoal() {
        return this.view.getTopAtsArt() instanceof GoalArtifact;
    }

    public Object[] getElements(Object entity) {
        ArrayList<Object> objs = new ArrayList<Object>(5);
        try {
            if (!this.isTopArtifactGoal() && entity instanceof IAtsAction) {
                objs.add(entity);
                objs.addAll(AtsApiService.get().getWorkItemServiceIde().getTeams(entity));
            } else if (!this.isTopArtifactGoal() && entity instanceof TeamWorkFlowArtifact) {
                objs.add(entity);
                TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)((Object)entity);
                if (!this.view.isShowAll() && AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamArt).size() > 8) {
                    TaskWrapper taskWrapper = new TaskWrapper(teamArt);
                    objs.add(taskWrapper);
                    AbstractWorkflowArtifact activeAwa = this.view.getActiveAwa();
                    if (activeAwa instanceof IAtsTask) {
                        IAtsTask task = (IAtsTask)activeAwa;
                        if (AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamArt).contains(task)) {
                            this.view.setActiveGraphItem(taskWrapper);
                        }
                    }
                } else {
                    objs.addAll(AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)((Object)entity))));
                }
                if (!this.view.isShowAll() && ReviewManager.getReviews(teamArt).size() > 4) {
                    ReviewWrapper reviewWrapper = new ReviewWrapper(teamArt);
                    objs.add(reviewWrapper);
                    if (ReviewManager.getReviews(teamArt).contains((Object)this.view.getActiveAwa())) {
                        this.view.setActiveGraphItem(reviewWrapper);
                    }
                } else {
                    objs.addAll(ReviewManager.getReviews((TeamWorkFlowArtifact)((Object)entity)));
                }
            } else if (entity instanceof GoalArtifact) {
                objs.add(entity);
                GoalArtifact goal = (GoalArtifact)entity;
                if (!this.view.isShowAll() && goal.getMembers().size() > 10) {
                    objs.add(new GoalMemberWrapper(goal));
                } else {
                    objs.addAll(goal.getMembers());
                }
            } else if (entity instanceof Artifact && AtsApiService.get().getQueryServiceIde().getArtifact(entity).isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                objs.add(entity);
                IAgileSprint sprint = AtsApiService.get().getWorkItemService().getAgileSprint((ArtifactToken)AtsApiService.get().getQueryServiceIde().getArtifact(entity));
                if (!this.view.isShowAll() && AtsApiService.get().getAgileService().getItems(sprint).size() > 10) {
                    objs.add(new SprintMemberWrapper(sprint));
                } else {
                    objs.addAll(AtsApiService.get().getAgileService().getItems(sprint));
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return objs.toArray();
    }

    public Object[] getConnectedTo(Object inputElement) {
        try {
            if (!this.isTopArtifactGoal() && inputElement instanceof IAtsAction) {
                return AtsApiService.get().getWorkItemServiceIde().getTeams(inputElement).toArray();
            }
            if (inputElement instanceof TeamWorkFlowArtifact) {
                ArrayList<Object> objs = new ArrayList<Object>(5);
                if (!this.isTopArtifactGoal()) {
                    TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)((Object)inputElement);
                    if (!this.view.isShowAll() && ReviewManager.getReviews(teamArt).size() > 4) {
                        ReviewWrapper reviewWrapper = new ReviewWrapper(teamArt);
                        objs.add(reviewWrapper);
                        if (ReviewManager.getReviews(teamArt).contains((Object)this.view.getActiveAwa())) {
                            this.view.setActiveGraphItem(reviewWrapper);
                        }
                    } else {
                        objs.addAll(ReviewManager.getReviews(teamArt));
                    }
                    if (!this.view.isShowAll() && AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamArt).size() > 8) {
                        TaskWrapper taskWrapper = new TaskWrapper(teamArt);
                        objs.add(taskWrapper);
                        AbstractWorkflowArtifact activeAwa = this.view.getActiveAwa();
                        if (activeAwa instanceof IAtsTask) {
                            IAtsTask task = (IAtsTask)activeAwa;
                            if (AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamArt).contains(task)) {
                                this.view.setActiveGraphItem(taskWrapper);
                            }
                        }
                    } else {
                        objs.addAll(AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamArt));
                    }
                }
                return objs.toArray();
            }
            if (inputElement instanceof GoalArtifact) {
                ArrayList<GoalMemberWrapper> objs = new ArrayList<GoalMemberWrapper>(5);
                GoalArtifact goal = (GoalArtifact)inputElement;
                if (!this.view.isShowAll() && goal.getMembers().size() > 10) {
                    objs.add(new GoalMemberWrapper(goal));
                } else {
                    objs.addAll(goal.getMembers());
                }
                return objs.toArray();
            }
            if (inputElement instanceof Artifact && AtsApiService.get().getQueryServiceIde().getArtifact(inputElement).isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                ArrayList<SprintMemberWrapper> objs = new ArrayList<SprintMemberWrapper>(5);
                IAgileSprint sprint = AtsApiService.get().getWorkItemService().getAgileSprint((ArtifactToken)AtsApiService.get().getQueryServiceIde().getArtifact(inputElement));
                if (!this.view.isShowAll() && AtsApiService.get().getAgileService().getItems(sprint).size() > 10) {
                    objs.add(new SprintMemberWrapper(sprint));
                } else {
                    objs.addAll(AtsApiService.get().getAgileService().getItems(sprint));
                }
                return objs.toArray();
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

