/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.swt.widgets.Composite;

public class XGoalCombo
extends XComboViewer {
    public static final String WIDGET_ID = XGoalCombo.class.getSimpleName();
    private Artifact selectedGoal = null;

    public XGoalCombo() {
        super("Goal", 8);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        try {
            ArrayList sortedGoals = new ArrayList();
            Collection goalArtifacts = ArtifactQuery.getArtifactTokenListFromTypeAndAttribute((ArtifactTypeToken)AtsArtifactTypes.Goal, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, (String)StateType.Working.name(), (BranchId)AtsApiService.get().getAtsBranch());
            sortedGoals.addAll(goalArtifacts);
            Collection backlogArtifacts = ArtifactQuery.getArtifactTokenListFromTypeAndAttribute((ArtifactTypeToken)AtsArtifactTypes.AgileBacklog, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, (String)StateType.Working.name(), (BranchId)AtsApiService.get().getAtsBranch());
            sortedGoals.addAll(backlogArtifacts);
            Collections.sort(sortedGoals, new NamedComparator(SortOrder.ASCENDING));
            this.getComboViewer().setInput(sortedGoals);
            ArrayList<String> defaultSelection = new ArrayList<String>();
            defaultSelection.add("--select--");
            this.setSelected(defaultSelection);
            this.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    XGoalCombo.this.selectedGoal = AtsApiService.get().getQueryServiceIde().getArtifact(XGoalCombo.this.getSelected());
                }
            });
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public Artifact getSelectedGoal() {
        return this.selectedGoal;
    }
}

