/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.config.IAtsConfigurationsService;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgramService;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.task.related.IAtsTaskRelatedService;
import org.eclipse.osee.ats.api.util.IAtsHealthService;
import org.eclipse.osee.ats.api.util.IAtsServerEndpointProvider;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.agile.AgileService;
import org.eclipse.osee.ats.core.ai.ActionableItemServiceImpl;
import org.eclipse.osee.ats.core.util.AtsApiImpl;
import org.eclipse.osee.ats.ide.branch.AtsBranchServiceIde;
import org.eclipse.osee.ats.ide.branch.internal.AtsBranchServiceIdeImpl;
import org.eclipse.osee.ats.ide.branch.internal.AtsBranchServiceImpl;
import org.eclipse.osee.ats.ide.ev.internal.AtsEarnedValueImpl;
import org.eclipse.osee.ats.ide.health.AtsHealthServiceImpl;
import org.eclipse.osee.ats.ide.notify.AtsNotificationServiceImpl;
import org.eclipse.osee.ats.ide.query.AtsQueryServiceIde;
import org.eclipse.osee.ats.ide.search.internal.query.AtsQueryServiceImpl;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.util.AtsServerEndpointProviderImpl;
import org.eclipse.osee.ats.ide.util.IArtifactMembersCache;
import org.eclipse.osee.ats.ide.util.internal.ArtifactCollectorsCache;
import org.eclipse.osee.ats.ide.util.internal.ArtifactResolverImpl;
import org.eclipse.osee.ats.ide.util.internal.AtsStoreService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.AtsWorkItemServiceClientImpl;
import org.eclipse.osee.ats.ide.workflow.IAtsWorkItemServiceIde;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.internal.AtsAttributeResolverServiceImpl;
import org.eclipse.osee.ats.ide.workflow.internal.AtsRelationResolverServiceImpl;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.workflow.task.IAtsTaskServiceIde;
import org.eclipse.osee.ats.ide.workflow.task.internal.AtsTaskService;
import org.eclipse.osee.ats.ide.workflow.task.related.AtsTaskRelatedService;
import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.client.OseeClientProperties;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.access.UserServiceImpl;

public class AtsApiIdeImpl
extends AtsApiImpl
implements AtsApiIde {
    private ArtifactCollectorsCache<GoalArtifact> goalMembersCache;
    private ArtifactCollectorsCache<SprintArtifact> sprintItemsCache;
    private IAgileService agileService;
    private AtsQueryServiceIde queryServiceIde;
    private IAtsWorkItemServiceIde workItemServiceIde;
    private IAtsServerEndpointProvider serverEndpoints;
    private AtsBranchServiceIde branchServiceIde;

    public void setConfigurationsService(final IAtsConfigurationsService configurationsService) {
        this.configurationsService = configurationsService;
        this.configurationsService.setAtsApi((AtsApi)this);
        Job loadAtsConfig = new Job("Load ATS Configs"){

            protected IStatus run(IProgressMonitor monitor) {
                configurationsService.getConfigurationsWithPend();
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)loadAtsConfig);
    }

    public void start() {
        this.attributeResolverService = new AtsAttributeResolverServiceImpl(this);
        super.start();
        this.earnedValueService = new AtsEarnedValueImpl(this.logger, this);
        this.artifactResolver = new ArtifactResolverImpl();
        this.relationResolver = new AtsRelationResolverServiceImpl(this);
        this.branchService = new AtsBranchServiceImpl(this, (ITeamWorkflowProvidersLazy)this.teamWorkflowProvidersLazy);
        this.storeService = new AtsStoreService(this, this.getUserService(), this.jdbcService);
        this.queryService = new AtsQueryServiceImpl(this, this.jdbcService);
        this.queryServiceIde = new AtsQueryServiceIde(this);
        this.actionableItemManager = new ActionableItemServiceImpl(this.attributeResolverService, (AtsApi)this);
        this.taskService = new AtsTaskService(this);
        this.agileService = new AgileService(this.logger, (AtsApi)this);
        this.notificationService = new AtsNotificationServiceImpl(this);
    }

    public void setAttributeResolverService(IAttributeResolver attributeResolverService) {
        this.attributeResolverService = attributeResolverService;
    }

    public void clearCaches() {
        this.getConfigService().getConfigurations();
        this.getUserService().clearCaches();
        super.clearCaches();
        if (this.goalMembersCache != null) {
            this.goalMembersCache.invalidate();
        }
        if (this.sprintItemsCache != null) {
            this.sprintItemsCache.invalidate();
        }
        this.getAccessControlService().clearCaches();
        this.getAtsAccessService().clearCaches();
    }

    public IAtsVersionService getVersionService() {
        return this.versionService;
    }

    public IAtsWorkItemService getWorkItemService() {
        return this.workItemService;
    }

    public Collection<ArtifactTypeToken> getArtifactTypes() {
        ArrayList<ArtifactTypeToken> types = new ArrayList<ArtifactTypeToken>();
        types.addAll(this.tokenService().getArtifactTypes());
        return types;
    }

    public IAtsProgramService getProgramService() {
        return this.programService;
    }

    @Override
    public IArtifactMembersCache<GoalArtifact> getGoalMembersCache() {
        if (this.goalMembersCache == null) {
            this.goalMembersCache = new ArtifactCollectorsCache(AtsRelationTypes.Goal_Member);
        }
        return this.goalMembersCache;
    }

    @Override
    public IArtifactMembersCache<SprintArtifact> getSprintItemsCache() {
        if (this.sprintItemsCache == null) {
            this.sprintItemsCache = new ArtifactCollectorsCache(AtsRelationTypes.AgileSprintToItem_AtsItem);
        }
        return this.sprintItemsCache;
    }

    public void clearImplementersCache(IAtsWorkItem workItem) {
        AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)this.getQueryService().getArtifact((IAtsObject)workItem);
        if (awa != null) {
            awa.clearImplementersCache();
        }
    }

    @Override
    public OseeClient getOseeClient() {
        return (OseeClient)OsgiUtil.getService(this.getClass(), OseeClient.class);
    }

    public IAgileService getAgileService() {
        return this.agileService;
    }

    public String getApplicationServerBase() {
        return OseeClientProperties.getOseeApplicationServer();
    }

    public IAtsActionableItemService getActionableItemService() {
        return this.actionableItemManager;
    }

    public IAtsQueryService getQueryService() {
        return this.queryService;
    }

    public IAtsTaskRelatedService getTaskRelatedService() {
        if (this.taskRelatedService == null) {
            this.taskRelatedService = new AtsTaskRelatedService(this);
        }
        return this.taskRelatedService;
    }

    @Override
    public AtsQueryServiceIde getQueryServiceIde() {
        return this.queryServiceIde;
    }

    public IAtsHealthService getHealthService() {
        return new AtsHealthServiceImpl(this);
    }

    @Override
    public IAtsTaskServiceIde getTaskServiceIde() {
        return (IAtsTaskServiceIde)this.taskService;
    }

    @Override
    public IAtsWorkItemServiceIde getWorkItemServiceIde() {
        if (this.workItemServiceIde == null) {
            this.workItemServiceIde = new AtsWorkItemServiceClientImpl(this, (ITeamWorkflowProvidersLazy)this.teamWorkflowProvidersLazy);
        }
        return this.workItemServiceIde;
    }

    public IAtsServerEndpointProvider getServerEndpoints() {
        if (this.serverEndpoints == null) {
            this.serverEndpoints = new AtsServerEndpointProviderImpl(this);
        }
        return this.serverEndpoints;
    }

    public boolean isIde() {
        return true;
    }

    public UserService getUserGroupService() {
        return UserServiceImpl.instance();
    }

    @Override
    public AtsBranchServiceIde getBranchServiceIde() {
        if (this.branchServiceIde == null) {
            this.branchServiceIde = new AtsBranchServiceIdeImpl(this);
        }
        return this.branchServiceIde;
    }

    public IAccessControlService getAccessControlService() {
        return this.getOseeClient().getAccessControlService();
    }
}

