/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.query;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.swt.widgets.TreeItem;

public class AtsQueryServiceIde {
    private final AtsApi atsApi;
    private final IAtsQueryService queryService;

    public AtsQueryServiceIde(AtsApi atsApi) {
        this.atsApi = atsApi;
        this.queryService = atsApi.getQueryService();
    }

    private List<Artifact> toArtifacts(Collection<ArtifactToken> artifacts) {
        LinkedList<Artifact> results = new LinkedList<Artifact>();
        for (ArtifactToken artTok : artifacts) {
            Artifact art = this.toArtifact((ArtifactId)artTok);
            if (!art.isValid()) continue;
            results.add(art);
        }
        return results;
    }

    private Artifact toArtifact(ArtifactId artId) {
        Artifact result = null;
        if (artId != null) {
            ArtifactToken dbArt;
            if (artId instanceof Artifact) {
                result = (Artifact)artId;
            } else if (artId.isValid() && (dbArt = this.atsApi.getQueryService().getArtifact(artId)) instanceof Artifact) {
                result = (Artifact)dbArt;
            }
        }
        return result;
    }

    public Artifact toArtifact(IAtsObject atsObject) {
        return this.toArtifact((ArtifactId)atsObject.getStoreObject());
    }

    public Artifact getRealArtifact(TreeItem item) {
        Artifact result = null;
        if (item.getData() instanceof ArtifactId) {
            result = this.toArtifact((ArtifactId)item.getData());
        }
        return result;
    }

    public Collection<Artifact> getArtifacts(List<ArtifactId> ids, BranchId branch) {
        return this.toArtifacts(this.queryService.getArtifacts(ids, branch));
    }

    public Collection<Artifact> getArtifactsFromQuery(String query, Object ... data) {
        return this.toArtifacts(this.queryService.getArtifactsFromQuery(query, data));
    }

    public Collection<Artifact> getArtifacts(BranchId branch, boolean includeInherited, ArtifactTypeToken ... artifactType) {
        return this.toArtifacts(this.queryService.getArtifacts(branch, includeInherited, artifactType));
    }

    public Artifact getArtifactToken(ArtifactId artifactId) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifactToken(artifactId));
    }

    public List<Artifact> getArtifactTokensFromQuery(String query, Object ... data) {
        return this.toArtifacts(this.queryService.getArtifactTokensFromQuery(query, data));
    }

    public Collection<Artifact> getRelatedToTokens(BranchId branch, ArtifactId artifact, RelationTypeSide relationType, ArtifactTypeId artifactType) {
        return this.toArtifacts(this.queryService.getRelatedToTokens(branch, artifact, relationType, artifactType));
    }

    public List<Artifact> getArtifactsByIds(String ids) {
        return this.toArtifacts(this.queryService.getArtifactsByIds(ids));
    }

    public Artifact getArtifactById(String id) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifactById(id));
    }

    public Artifact getArtifactByAtsId(String id) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifactByAtsId(id));
    }

    public Artifact getArtifactByIdOrAtsId(String id) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifactByIdOrAtsId(id));
    }

    public Artifact getArtifactByLegacyPcrId(String id) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifactByLegacyPcrId(id));
    }

    public Collection<Artifact> getArtifactsByLegacyPcrId(String id) {
        return this.toArtifacts(this.queryService.getArtifactsByLegacyPcrId(id));
    }

    public List<Artifact> getArtifacts(ArtifactTypeToken artifactType) {
        return this.toArtifacts(this.queryService.getArtifacts(artifactType));
    }

    public Artifact getConfigArtifact(IAtsConfigObject atsConfigObject) {
        return this.toArtifact((ArtifactId)this.queryService.getConfigArtifact(atsConfigObject));
    }

    public Artifact getArtifact(ArtifactId artifact, BranchId branch) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifact(artifact, branch));
    }

    public Collection<Artifact> getArtifacts(Collection<Long> ids) {
        return this.toArtifacts(this.queryService.getArtifacts(ids));
    }

    public Artifact getArtifactByName(ArtifactTypeToken artifactType, String name) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifactByName(artifactType, name));
    }

    public Artifact getArtifact(ArtifactId artifact, BranchId branch, DeletionFlag deletionFlag) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifact(artifact, branch, deletionFlag));
    }

    public Artifact getHistoricalArtifactOrNull(ArtifactId artifact, TransactionToken transaction, DeletionFlag deletionFlag) {
        return this.toArtifact((ArtifactId)this.queryService.getHistoricalArtifactOrNull(artifact, transaction, deletionFlag));
    }

    public Artifact getArtifactByGuid(String guid) {
        return this.toArtifact((ArtifactId)this.queryService.getArtifactByGuid(guid));
    }

    public Collection<Artifact> getArtifactsByIdsOrAtsIds(String searchStr) {
        return this.toArtifacts(this.queryService.getArtifactsByIdsOrAtsIds(searchStr));
    }

    public Artifact getArtifact(ArtifactId artifactId) {
        if (artifactId instanceof Artifact) {
            return (Artifact)artifactId;
        }
        return this.getArtifact(artifactId, (BranchId)this.atsApi.getAtsBranch());
    }

    public Artifact getArtifact(Object obj) {
        Artifact result = null;
        if (obj instanceof Artifact) {
            result = (Artifact)obj;
            if (obj instanceof IAtsObject) {
                result.setArtifactType(((IAtsObject)obj).getArtifactType());
            }
        } else if (obj instanceof IAtsObject) {
            result = this.getArtifact((ArtifactId)((IAtsObject)obj).getStoreObject(), (BranchId)this.atsApi.getAtsBranch());
        } else if (obj instanceof ArtifactId) {
            result = this.getArtifact((ArtifactId)obj, (BranchId)this.atsApi.getAtsBranch());
        } else if (obj instanceof Id) {
            result = this.getArtifact(((Id)obj).getId());
        } else if (obj instanceof Long) {
            result = this.getArtifact(ArtifactId.valueOf((Long)((Long)obj)));
        }
        return result;
    }

    public Artifact getArtifact(TreeItem item) {
        return this.getArtifact(item.getData());
    }

    public TeamWorkFlowArtifact getTeamWfArt(IAtsTeamWorkflow teamWf) {
        TeamWorkFlowArtifact result = null;
        if (teamWf instanceof TeamWorkFlowArtifact) {
            result = (TeamWorkFlowArtifact)teamWf;
        }
        return result;
    }

    public Artifact getParentAction(ArtifactId artifact) {
        Artifact actionArt = null;
        if (artifact instanceof IAtsAction) {
            actionArt = (Artifact)((IAtsAction)artifact);
        } else if (artifact instanceof AbstractWorkflowArtifact) {
            actionArt = (Artifact)((AbstractWorkflowArtifact)artifact).getParentAction().getStoreObject();
        }
        return actionArt;
    }
}

