/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.operation.MoveTeamWorkflowsOperation;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.swt.Displays;

public class MoveTeamWorkflowsBlam
extends AbstractBlam {
    private static final String SOURCE_TEAM_WORKFLOWS = "Source Team Workflow(s) (drop here)";
    private static final String DEST_TEAM_WORKFLOW = "Destination Team Workflow (drop here)";
    private static final String TITLE = "Destination Action Title (leave empty to keep same title)";

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TeamWorkFlowArtifact destTeamArt = (TeamWorkFlowArtifact)variableMap.getArtifact(MoveTeamWorkflowsBlam.DEST_TEAM_WORKFLOW);
                    List sourceTeamArts = org.eclipse.osee.framework.jdk.core.util.Collections.castAll(TeamWorkFlowArtifact.class, (Collection)variableMap.getArtifacts(MoveTeamWorkflowsBlam.SOURCE_TEAM_WORKFLOWS));
                    if (sourceTeamArts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in Source Team Workflow(s).");
                        return;
                    }
                    if (destTeamArt == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in Destination Team Workflow.");
                        return;
                    }
                    MoveTeamWorkflowsOperation operation = new MoveTeamWorkflowsOperation(MoveTeamWorkflowsBlam.this.getName(), destTeamArt, sourceTeamArts, variableMap.getString(MoveTeamWorkflowsBlam.TITLE));
                    Operations.executeAsJob((IOperation)operation, (boolean)true);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Source Team Workflow(s) (drop here)\" /><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Destination Team Workflow (drop here)\" /><XWidget xwidgetType=\"XText\" displayName=\"Destination Action Title (leave empty to keep same title)\" horizontalLabel=\"true\" /></xWidgets>";
    }

    public String getDescriptionUsage() {
        return "Takes source Team Workflow(s) and moves them to destination Team Workflow's Action; Emtpy source Action artifacts will be deleted.";
    }

    public String getName() {
        return "Move Team Workflows";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("ATS");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

