/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SubscribeUtility;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AICheckTreeDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class SubscribeByActionableItem
extends XNavigateItemAction {
    public SubscribeByActionableItem(XNavigateItem parent) {
        super(parent, "Subscribe by Actionable Item", (KeyedImage)FrameworkImage.EMAIL);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        AICheckTreeDialog diag = new AICheckTreeDialog(this.getName(), "Select Actionable Items\n\nEmail will be sent for every Action created against these AIs.", Active.Active);
        try {
            ArrayList<IAtsActionableItem> objs = new ArrayList<IAtsActionableItem>();
            for (ArtifactToken artifact : AtsApiService.get().getRelationResolver().getRelated((IAtsObject)AtsApiService.get().getUserService().getCurrentUser(), AtsRelationTypes.SubscribedUser_Artifact)) {
                if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) continue;
                objs.add((IAtsActionableItem)AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)artifact));
            }
            diag.setInitialAias(objs);
            if (diag.open() != 0) {
                return;
            }
            Collection<IAtsActionableItem> selected = diag.getChecked();
            List arts = Collections.castAll((Collection)AtsApiService.get().getQueryService().getArtifactsFromObjects(selected));
            User user = UserManager.getUserByArtId((ArtifactId)AtsApiService.get().getUserService().getCurrentUser());
            SubscribeUtility.setSubcriptionsAndPersist((Artifact)user, AtsRelationTypes.SubscribedUser_Artifact, arts, AtsArtifactTypes.ActionableItem, ((Object)((Object)this)).getClass().getSimpleName());
            AWorkbench.popup((String)this.getName(), (String)"Subscriptions updated.");
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

