/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItemProvider;
import org.eclipse.osee.ats.ide.world.WorldEditorUISearchItemProvider;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Image;

public class SearchNavigateItem
extends XNavigateItem {
    private final WorldSearchItem wsi;

    public SearchNavigateItem(XNavigateItem parent, WorldSearchItem wsi) {
        super(parent, wsi.getName(), (OseeImage)AtsImage.GLOBE);
        this.wsi = wsi;
    }

    public SearchNavigateItem(XNavigateItem parent, WorldSearchItem wsi, AtsImage atsImage) {
        super(parent, wsi.getName(), (OseeImage)atsImage);
        this.wsi = wsi;
    }

    public WorldSearchItem getWorldSearchItem() {
        return this.wsi;
    }

    public Image getImage() {
        Image image = this.wsi.getImage();
        if (image != null) {
            return image;
        }
        return ImageManager.getImage((OseeImage)AtsImage.GLOBE);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        List<XNavigateComposite.TableLoadOption> tableLoadOpts = Arrays.asList(tableLoadOptions);
        boolean dontCopyWsi = tableLoadOpts.contains(XNavigateComposite.TableLoadOption.DontCopySearchItem);
        WorldSearchItem worldSearchItem = this.getWorldSearchItem();
        if (worldSearchItem.getLoadView() == WorldSearchItem.LoadView.WorldEditor) {
            if (worldSearchItem instanceof WorldUISearchItem) {
                WorldEditor.open(new WorldEditorUISearchItemProvider((WorldUISearchItem)(dontCopyWsi ? worldSearchItem : worldSearchItem.copy()), null, tableLoadOptions));
            } else if (worldSearchItem instanceof WorldEditorParameterSearchItem) {
                WorldEditor.open(new WorldEditorParameterSearchItemProvider((WorldEditorParameterSearchItem)(dontCopyWsi ? worldSearchItem : worldSearchItem.copy()), null, tableLoadOptions));
            } else {
                AWorkbench.popup((String)"ERROR", (String)"Unhandled WorldEditor navigate item");
            }
        } else {
            AWorkbench.popup((String)"ERROR", (String)"Unhandled navigate item");
        }
    }
}

