/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.editor.tab.workflow.util.WfePrint;
import org.eclipse.osee.ats.ide.export.AtsExportBlam;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class AtsExportAction
extends Action {
    private static final String AS_PDF_NOT_IMPLEMENTED_YET = "AS_PDF Not Implemented Yet";
    public static final String ATS_EXPORT_HTML_FILE = "ATS_Export.html";
    private final ISelectedAtsArtifacts selected;
    private boolean popup = true;

    public AtsExportAction() {
        this(null);
    }

    public AtsExportAction(ISelectedAtsArtifacts selected) {
        this.selected = selected;
        this.setText("Export Selected ATS Artifacts");
        this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.EXPORT_DATA));
    }

    public Result export(Collection<? extends Artifact> artifacts, Collection<ExportOption> exportOption, String fileLocation) {
        Result result = Result.TrueResult;
        boolean singleFile = exportOption.contains((Object)ExportOption.MERGE_INTO_SINGLE_FILE);
        boolean asHtmlToFile = exportOption.contains((Object)ExportOption.AS_HTML_TO_FILE);
        boolean asHtmlToResultEditor = exportOption.contains((Object)ExportOption.AS_HTML_TO_RESULT_EDITOR);
        boolean multipleFile = exportOption.contains((Object)ExportOption.SAVE_INTO_SEPARATE_FILES);
        boolean includeTaskList = exportOption.contains((Object)ExportOption.INCLUDE_TASKLIST);
        if (asHtmlToFile || asHtmlToResultEditor) {
            StringBuffer singleSb = new StringBuffer();
            for (Artifact artifact : artifacts) {
                if (!(artifact instanceof AbstractWorkflowArtifact)) continue;
                AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)artifact;
                WfePrint smaPrint = new WfePrint(awa);
                smaPrint.setIncludeTaskList(includeTaskList);
                String html = XResultDataUI.getReport((XResultData)smaPrint.getResultData(), (String)"").getManipulatedHtml();
                if (multipleFile) {
                    try {
                        if (asHtmlToFile) {
                            File file = new File(this.getFileLocation(fileLocation, String.valueOf(awa.getAtsId()) + ".html"));
                            Lib.writeStringToFile((String)html, (File)file);
                        }
                        if (asHtmlToResultEditor) {
                            ResultsEditor.open((String)"Output", (String)("Export " + awa.getAtsId()), (String)html);
                        }
                    }
                    catch (IOException ex) {
                        throw new OseeCoreException("Error writing to html file", (Throwable)ex);
                    }
                }
                if (!singleFile) continue;
                singleSb.append(String.valueOf(html) + AHTML.newline((int)3));
            }
            if (singleFile) {
                try {
                    if (asHtmlToFile) {
                        File file = new File(this.getFileLocation(fileLocation, ATS_EXPORT_HTML_FILE));
                        Lib.writeStringToFile((String)singleSb.toString(), (File)file);
                    }
                    if (asHtmlToResultEditor) {
                        ResultsEditor.open((String)"Output", (String)"Export ATS Artifacts", (String)singleSb.toString());
                    }
                }
                catch (IOException iOException) {
                    throw new OseeCoreException("Error writing to html file", (Throwable)iOException);
                }
            }
            if (this.popup) {
                AWorkbench.popup((String)"Export Completed", (String)"Export Completed");
            }
        }
        if (exportOption.contains((Object)ExportOption.AS_PDF)) {
            if (this.popup) {
                AWorkbench.popup((String)"ERROR", (String)AS_PDF_NOT_IMPLEMENTED_YET);
            } else {
                result = new Result(false, AS_PDF_NOT_IMPLEMENTED_YET);
            }
        }
        return result;
    }

    private String getFileLocation(String fileLocation, String filename) {
        if (fileLocation == null) {
            fileLocation = System.getProperty("user.home");
        }
        return String.valueOf(fileLocation) + System.getProperty("file.separator") + filename;
    }

    public void run() {
        if (this.selected == null) {
            AtsExportBlam.openAtsExportBlam(new ArrayList<AbstractWorkflowArtifact>());
        } else {
            AtsExportBlam.openAtsExportBlam(Collections.castAll(AbstractWorkflowArtifact.class, this.selected.getSelectedWorkflowArtifacts()));
        }
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public static enum ExportOption {
        AS_HTML_TO_RESULT_EDITOR,
        AS_HTML_TO_FILE,
        AS_PDF,
        MERGE_INTO_SINGLE_FILE,
        SAVE_INTO_SEPARATE_FILES,
        INCLUDE_TASKLIST;

    }
}

