/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.history.column;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class AuthorColumn
extends XViewerValueColumn {
    private static AuthorColumn instance = new AuthorColumn();
    private final Map<ArtifactId, String> artIdToName = new HashMap<ArtifactId, String>(40);

    public static AuthorColumn getInstance() {
        return instance;
    }

    public AuthorColumn() {
        super("ats.history.Author", "Author", 100, XViewerAlign.Left, true, SortDataType.String, false, "");
    }

    public AuthorColumn copy() {
        AuthorColumn newXCol = new AuthorColumn();
        this.copy((XViewerColumn)this, (XViewerColumn)newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        String name = "";
        if (element instanceof Change) {
            try {
                TransactionRecord endTx = TransactionManager.getTransaction((TransactionId)((Change)element).getTxDelta().getEndTx());
                UserId author = endTx.getAuthor();
                name = this.artIdToName.get(author);
                if (name == null) {
                    Artifact art = ArtifactQuery.getArtifactFromId((ArtifactId)author, (BranchId)AtsApiService.get().getAtsBranch(), (DeletionFlag)DeletionFlag.EXCLUDE_DELETED);
                    if (art != null) {
                        name = art.getName();
                        this.artIdToName.put((ArtifactId)author, name);
                    } else {
                        name = "unknown for " + author;
                    }
                }
                return name;
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                name = "exception " + ex.getLocalizedMessage();
            }
        }
        return name;
    }
}

