/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.core.util.AtsRelationChange;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class CreateNewVersionItem
extends XNavigateItemAction {
    private final IAtsTeamDefinition teamDefHoldingVersions;

    public CreateNewVersionItem(XNavigateItem parent, IAtsTeamDefinition teamDefHoldingVersions) {
        super(parent, "Create New " + (teamDefHoldingVersions != null ? teamDefHoldingVersions + " " : "") + "Version(s) (Admin)", (KeyedImage)FrameworkImage.VERSION);
        this.teamDefHoldingVersions = teamDefHoldingVersions;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        IAtsTeamDefinition teamDefHoldingVersions = null;
        try {
            teamDefHoldingVersions = this.getReleaseableTeamDefinition();
        }
        catch (Exception exception) {}
        if (teamDefHoldingVersions == null) {
            return;
        }
        EntryDialog ed = new EntryDialog(Displays.getActiveShell(), "Create New Version", null, "Enter Version name(s) one per line", 3, new String[]{"OK", "Cancel"}, 0);
        ed.setFillVertically(true);
        if (ed.open() == 0) {
            HashSet<String> newVersionNames = new HashSet<String>();
            String[] stringArray = ed.getEntry().split(System.getProperty("line.separator"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                newVersionNames.add(str);
                ++n2;
            }
            XResultData resultData = new XResultData(false);
            IAtsChangeSet changes = AtsApiService.get().createChangeSet("Create New Version(s)");
            Collection<IAtsVersion> newVersions = CreateNewVersionItem.createVersions(resultData, changes, teamDefHoldingVersions, newVersionNames);
            if (resultData.isErrors()) {
                resultData.log(String.format("\nErrors found while creating version(s) for [%s].\nPlease resolve and try again.", teamDefHoldingVersions));
                XResultDataUI.report((XResultData)resultData, (String)"Create New Version Error");
                return;
            }
            changes.execute();
            if (newVersions.size() == 1) {
                RendererManager.open((Artifact)AtsApiService.get().getQueryServiceIde().getArtifact(newVersions.iterator().next()), (PresentationType)PresentationType.DEFAULT_OPEN);
            } else {
                Collection artToks = AtsApiService.get().getQueryService().getArtifactsFromObjects(newVersions);
                List arts = org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)artToks);
                MassArtifactEditor.editArtifacts((String)String.format("New Versions for [%s]", teamDefHoldingVersions), (Collection)arts, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[]{XNavigateComposite.TableLoadOption.None});
            }
        }
    }

    public static Collection<IAtsVersion> createVersions(XResultData resultData, IAtsChangeSet changes, IAtsTeamDefinition teamDefHoldingVersions, Collection<String> newVersionNames) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        for (String newVer : newVersionNames) {
            if (!Strings.isValid((String)newVer)) {
                resultData.error("Version name can't be blank");
            }
            for (IAtsVersion verArt : AtsApiService.get().getVersionService().getVersions(teamDefHoldingVersions)) {
                if (!verArt.getName().equals(newVer)) continue;
                resultData.error(String.format("Version [%s] already exists", newVer));
            }
        }
        if (!resultData.isErrors()) {
            try {
                for (String newVer : newVersionNames) {
                    Version version = AtsApiService.get().getVersionService().createVersion(newVer, changes);
                    versions.add((IAtsVersion)version);
                    changes.add((Object)version);
                    changes.add((Object)new AtsRelationChange((Object)teamDefHoldingVersions, AtsRelationTypes.TeamDefinitionToVersion_Version, Collections.singleton(version), AtsRelationChange.RelationOperation.Add));
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return versions;
    }

    public IAtsTeamDefinition getReleaseableTeamDefinition() {
        if (this.teamDefHoldingVersions != null) {
            return this.teamDefHoldingVersions;
        }
        TeamDefinitionDialog dialog = new TeamDefinitionDialog();
        dialog.setInput(AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Active));
        int result = dialog.open();
        if (result == 0) {
            return (IAtsTeamDefinition)dialog.getSelectedFirst();
        }
        return null;
    }
}

