/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.program;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.ats.ide.config.program.IAtsProgramManager;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.logging.OseeLog;
import org.osgi.framework.Bundle;

public abstract class ProgramManagers {
    public static IAtsProgramManager getAtsProgramManager(TeamWorkFlowArtifact teamArt) {
        for (IAtsProgramManager program : ProgramManagers.getAtsProgramManagers()) {
            if (!program.isApplicable(teamArt)) continue;
            return program;
        }
        return null;
    }

    public static Set<IAtsProgramManager> getAtsProgramManagers() {
        IExtension[] extensions;
        HashSet<IAtsProgramManager> programItems = new HashSet<IAtsProgramManager>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.osee.ats.ide.AtsProgramManager");
        if (point == null) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't access AtsProgram extension point");
            return null;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String classname = null;
            String bundleName = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("AtsProgramManager")) {
                    classname = el.getAttribute("classname");
                    bundleName = el.getContributor().getName();
                    if (classname != null && bundleName != null) {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        try {
                            Class taskClass = bundle.loadClass(classname);
                            Object obj = taskClass.newInstance();
                            programItems.add((IAtsProgramManager)obj);
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error loading AtsProgramManager extension", (Throwable)ex);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return programItems;
    }
}

