/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.RemainingHoursColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class WorkDaysNeededColumn
extends XViewerAtsColumn
implements IXViewerValueColumn,
IAltLeftClickProvider {
    public static WorkDaysNeededColumn instance = new WorkDaysNeededColumn();

    public static WorkDaysNeededColumn getInstance() {
        return instance;
    }

    private WorkDaysNeededColumn() {
        super("ats.column.workDaysNeeded", "Hours Per Work Day", 40, XViewerAlign.Center, false, SortDataType.Float, false, null);
    }

    public WorkDaysNeededColumn copy() {
        WorkDaysNeededColumn newXCol = new WorkDaysNeededColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        if (element instanceof AbstractWorkflowArtifact) {
            try {
                Result result = WorkDaysNeededColumn.isWorldViewManDaysNeededValid(element);
                if (result.isFalse()) {
                    return result.getText();
                }
                return AtsUtil.doubleToI18nString((double)WorkDaysNeededColumn.getWorldViewManDaysNeeded(element));
            }
            catch (OseeCoreException ex) {
                LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        return "";
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            AbstractWorkflowArtifact aba = null;
            if (treeItem.getData() instanceof AbstractWorkflowArtifact) {
                aba = (AbstractWorkflowArtifact)((Object)treeItem.getData());
            } else if (Artifacts.isOfType((Object)treeItem.getData(), (ArtifactTypeToken)AtsArtifactTypes.Action) && AtsApiService.get().getWorkItemService().getTeams(treeItem.getData()).size() == 1) {
                aba = (AbstractWorkflowArtifact)AtsApiService.get().getWorkItemService().getFirstTeam(treeItem.getData()).getStoreObject();
            }
            if (aba != null) {
                AWorkbench.popup((String)"Calculated Field", (String)("Work Days Needed field is calculated.\nRemaining Hours / Hours per Week (" + aba.getManHrsPerDayPreference() + ")"));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static Result isWorldViewManDaysNeededValid(Object object) {
        if (object instanceof AbstractWorkflowArtifact) {
            AbstractWorkflowArtifact aba = (AbstractWorkflowArtifact)((Object)object);
            Result result = RemainingHoursColumn.isRemainingHoursValid((Object)aba);
            if (result.isFalse()) {
                return result;
            }
            if (aba.getManHrsPerDayPreference() == 0.0) {
                return new Result("Man Day Hours Preference is not set.");
            }
            return Result.TrueResult;
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                if (WorkDaysNeededColumn.isWorldViewManDaysNeededValid(team).isFalse()) continue;
                return Result.FalseResult;
            }
        }
        return Result.FalseResult;
    }

    public static double getWorldViewManDaysNeeded(Object object) {
        if (object instanceof AbstractWorkflowArtifact) {
            double hrsRemain = RemainingHoursColumn.getRemainingHours(object);
            double manDaysNeeded = 0.0;
            if (hrsRemain != 0.0) {
                manDaysNeeded = hrsRemain / ((AbstractWorkflowArtifact)((Object)object)).getManHrsPerDayPreference();
            }
            return manDaysNeeded;
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            double hours = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                hours += WorkDaysNeededColumn.getWorldViewManDaysNeeded(team);
            }
            return hours;
        }
        return 0.0;
    }
}

