/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.column.IAtsXViewerPreComputedColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class BranchStatusColumn
extends XViewerAtsColumn
implements IAtsXViewerPreComputedColumn {
    public static BranchStatusColumn instance = new BranchStatusColumn();

    public static BranchStatusColumn getInstance() {
        return instance;
    }

    private BranchStatusColumn() {
        super("ats.column.branchStatus", "Branch Status", 40, XViewerAlign.Center, false, SortDataType.String, false, null);
    }

    public BranchStatusColumn copy() {
        BranchStatusColumn newXCol = new BranchStatusColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        for (Object element : objects) {
            Long key = this.getKey(element);
            try {
                if (Artifacts.isOfType(element, (ArtifactTypeToken)AtsArtifactTypes.TeamWorkflow)) {
                    String status = this.getBranchStatus((IAtsTeamWorkflow)element);
                    preComputedValueMap.put(key, status);
                    continue;
                }
                if (!(element instanceof AbstractWorkflowArtifact) && element instanceof IAtsWorkItem) {
                    this.populateCachedValues(Arrays.asList(((IAtsWorkItem)element).getStoreObject()), preComputedValueMap);
                    continue;
                }
                preComputedValueMap.put(key, "");
            }
            catch (OseeCoreException ex) {
                String cellExceptionString = LogUtil.getCellExceptionString((Exception)((Object)ex));
                preComputedValueMap.put(key, cellExceptionString);
            }
        }
    }

    public String getBranchStatus(IAtsTeamWorkflow teamWf) {
        block5: {
            try {
                if (!AtsApiService.get().getBranchService().isWorkingBranchInWork(teamWf)) break block5;
                return "Working";
            }
            catch (Exception ex) {
                return "Exception: " + ex.getLocalizedMessage();
            }
        }
        if (AtsApiService.get().getBranchService().isCommittedBranchExists(teamWf)) {
            if (!AtsApiService.get().getBranchService().isAllObjectsToCommitToConfigured(teamWf) || !AtsApiService.get().getBranchService().isBranchesAllCommitted(teamWf)) {
                return "Needs Commit";
            }
            return "Committed";
        }
        return "";
    }
}

