/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.ArtifactLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.ArtifactTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.widgets.Shell;

public class SortAgileBacklog
extends XNavigateItemAction {
    private AtsApiIde atsApi;
    private final boolean debug = false;

    public SortAgileBacklog(XNavigateItem parent) {
        super(parent, "Sort Agile Backlog", AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_BACKLOG));
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        this.atsApi = AtsApiService.get();
        LinkedList<Artifact> activeTeams = new LinkedList<Artifact>();
        for (Artifact agTeam : ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)AtsArtifactTypes.AgileTeam, (BranchId)AtsApiService.get().getAtsBranch())) {
            if (!((Boolean)agTeam.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true)).booleanValue()) continue;
            activeTeams.add(agTeam);
        }
        FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog(this.getName(), "Select Agile Team", activeTeams, (ITreeContentProvider)new ArtifactTreeContentProvider(), (ILabelProvider)new ArtifactLabelProvider());
        if (dialog.open() == 0) {
            Artifact agileTeamArt = dialog.getSelectedFirst();
            Artifact backlog = agileTeamArt.getRelatedArtifactOrNull(AtsRelationTypes.AgileTeamToBacklog_Backlog);
            if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Sort Agile Team", (String)String.format("Sort Agile Team Backlog\n\n%s\n\nAre you sure?", backlog.toStringWithId()))) {
                List<IAgileItem> aItems = this.sort(backlog);
                ArrayList<Artifact> arts = new ArrayList<Artifact>();
                for (IAgileItem aItem : aItems) {
                    arts.add((Artifact)this.atsApi.getQueryService().getArtifact(aItem.getArtifactId()));
                }
                backlog.setRelationOrder(AtsRelationTypes.Goal_Member, arts);
                backlog.persist("Set Backlog Order");
            }
        }
    }

    private List<IAgileItem> sort(Artifact backlog) {
        IAgileBacklog bLog = this.atsApi.getAgileService().getAgileBacklog((ArtifactId)backlog);
        Collection items = this.atsApi.getAgileService().getItems(bLog);
        ArrayList<IAgileItem> sItems = new ArrayList<IAgileItem>();
        sItems.addAll(items);
        String unOrdered = this.print("Un-Ordered Backlog", sItems);
        Collections.sort(sItems, new NoSprintCompCancelledComparator().thenComparing(new NoSprintCompCancelledComparator().thenComparing(new SprintComparator()).thenComparing(new CompCancelledComparator())));
        String ordered = this.print("Ordered Backlog", sItems);
        return sItems;
    }

    private String print(String title, List<IAgileItem> sItems) {
        return "";
    }

    private class CompCancelledComparator
    implements Comparator<IAgileItem> {
        private CompCancelledComparator() {
        }

        @Override
        public int compare(IAgileItem a1, IAgileItem a2) {
            IAgileSprint sprint1 = SortAgileBacklog.this.atsApi.getAgileService().getSprint(a1);
            IAgileSprint sprint2 = SortAgileBacklog.this.atsApi.getAgileService().getSprint(a2);
            if (sprint1 == null && sprint2 == null) {
                return 0;
            }
            if (a1.getStateMgr().getCurrentStateType().isCancelled()) {
                return -1;
            }
            if (a2.getStateMgr().getCurrentStateType().isCancelled()) {
                return 1;
            }
            if (a1.getStateMgr().getCurrentStateType().isCompleted()) {
                return -1;
            }
            if (a2.getStateMgr().getCurrentStateType().isCompleted()) {
                return 1;
            }
            return -1 * a1.getStateMgr().getCurrentStateName().compareTo(a2.getStateMgr().getCurrentStateName());
        }
    }

    private class NoSprintCompCancelledComparator
    implements Comparator<IAgileItem> {
        private NoSprintCompCancelledComparator() {
        }

        @Override
        public int compare(IAgileItem a1, IAgileItem a2) {
            IAgileSprint sprint1 = SortAgileBacklog.this.atsApi.getAgileService().getSprint(a1);
            IAgileSprint sprint2 = SortAgileBacklog.this.atsApi.getAgileService().getSprint(a2);
            if (sprint1 == null && a1.getStateMgr().getCurrentStateType().isCompletedOrCancelled() && sprint2 == null && a2.getStateMgr().getStateType().isCompletedOrCancelled()) {
                return 0;
            }
            if (sprint1 == null && a1.getStateMgr().getCurrentStateType().isCompletedOrCancelled()) {
                return -1;
            }
            if (sprint2 == null && a2.getStateMgr().getStateType().isCompletedOrCancelled()) {
                return 1;
            }
            return 0;
        }
    }

    private class SprintComparator
    implements Comparator<IAgileItem> {
        private SprintComparator() {
        }

        @Override
        public int compare(IAgileItem a1, IAgileItem a2) {
            IAgileSprint sprint1 = SortAgileBacklog.this.atsApi.getAgileService().getSprint(a1);
            IAgileSprint sprint2 = SortAgileBacklog.this.atsApi.getAgileService().getSprint(a2);
            if (sprint1 == null && sprint2 == null) {
                return 0;
            }
            if (sprint1 == null) {
                return 1;
            }
            if (sprint2 == null) {
                return -1;
            }
            return sprint1.getName().compareTo(sprint2.getName());
        }
    }
}

