/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile.navigate;

import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.cm.OseeCmEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;

public class CreateNewAgileTeam
extends XNavigateItemAction {
    public CreateNewAgileTeam(XNavigateItem parent) {
        super(parent, "Create new Agile Team", AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_TEAM));
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        EntryDialog ed = new EntryDialog(this.getName(), "Enter new Agile Team name");
        if (ed.open() == 0 && Strings.isValid((String)ed.getEntry())) {
            try {
                AgileEndpointApi agileEp = AtsApiService.get().getServerEndpoints().getAgileEndpoint();
                JaxNewAgileTeam newTeam = new JaxNewAgileTeam();
                newTeam.setName(ed.getEntry());
                Response response = agileEp.createTeam(newTeam);
                Object entity = null;
                if (response != null) {
                    entity = response.readEntity(JaxAgileTeam.class);
                }
                if (entity != null) {
                    JaxAgileTeam team = (JaxAgileTeam)entity;
                    Artifact teamArt = ArtifactQuery.getArtifactFromId((long)team.getId(), (BranchId)AtsApiService.get().getAtsBranch());
                    teamArt.getParent().reloadAttributesAndRelations();
                    AtsEditors.openArtifact(teamArt, OseeCmEditor.CmPcrEditor);
                } else {
                    AWorkbench.popup((String)"Error Creating Team", (String)(response != null ? response.toString() : ""));
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }
}

