/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.internal.http;

import io.restassured.internal.http.ContentEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class GZIPEncoding
extends ContentEncoding {
    public String getContentEncoding() {
        return ContentEncoding.Type.GZIP.toString();
    }

    public HttpEntity wrapResponseEntity(HttpEntity raw) {
        return new GZIPDecompressingEntity(raw);
    }

    protected static class GZIPDecompressingEntity
    extends HttpEntityWrapper {
        public GZIPDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

