/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceMessageFilterEndpoint;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;

public class InterfaceMessageFilterEndpointImpl
implements InterfaceMessageFilterEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId ConnectionId;
    private final InterfaceMessageApi messageApi;
    private final InterfaceSubMessageApi subMessageApi;

    public InterfaceMessageFilterEndpointImpl(BranchId branch, ArtifactId connectionId, UserId account, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi) {
        this.account = account;
        this.branch = branch;
        this.messageApi = interfaceMessageApi;
        this.subMessageApi = interfaceSubMessageApi;
        this.ConnectionId = connectionId;
    }

    @Override
    public Collection<InterfaceMessageToken> getMessages() {
        try {
            List messageList = (List)this.messageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceConnectionContent_Connection, this.ConnectionId, InterfaceMessageToken.class);
            for (InterfaceMessageToken message : messageList) {
                LinkedList<InterfaceSubMessageToken> submessages = new LinkedList<InterfaceSubMessageToken>();
                for (InterfaceSubMessageToken submessage : this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, ArtifactId.valueOf((Long)message.getId()), InterfaceSubMessageToken.class)) {
                    submessage.setInterfaceMessageRate(message.getInterfaceMessageRate());
                    submessages.add(submessage);
                }
                message.setSubMessages(submessages);
            }
            return messageList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public Collection<InterfaceMessageToken> getMessages(String filter) {
        try {
            List messageList = (List)this.messageApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceConnectionContent_Connection, this.ConnectionId, filter, InterfaceMessageToken.class);
            for (InterfaceMessageToken message : messageList) {
                message.setSubMessages((List)this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, ArtifactId.valueOf((Long)message.getId()), InterfaceSubMessageToken.class));
            }
            List subMessages = (List)this.subMessageApi.getAccessor().getAllByFilter(this.branch, filter, InterfaceSubMessageToken.class);
            for (InterfaceSubMessageToken subMessage : subMessages) {
                List alternateMessageList = (List)this.messageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage, ArtifactId.valueOf((Long)subMessage.getId()), InterfaceMessageToken.class);
                for (InterfaceMessageToken alternateMessage : alternateMessageList) {
                    alternateMessage.setSubMessages((List)this.subMessageApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, ArtifactId.valueOf((Long)alternateMessage.getId()), filter, InterfaceSubMessageToken.class));
                    if (messageList.contains((Object)alternateMessage)) continue;
                    messageList.add(alternateMessage);
                }
            }
            return messageList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

