/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

public class NoneJwsSignatureProvider
implements JwsSignatureProvider {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    @Override
    public SignatureAlgorithm getAlgorithm() {
        return SignatureAlgorithm.NONE;
    }

    @Override
    public JwsSignature createJwsSignature(JwsHeaders headers) {
        return new NoneJwsSignature();
    }

    @Override
    public byte[] sign(JwsHeaders headers, byte[] content) {
        return EMPTY_BYTE_ARRAY;
    }

    private static class NoneJwsSignature
    implements JwsSignature {
        private NoneJwsSignature() {
        }

        @Override
        public void update(byte[] src, int off, int len) {
        }

        @Override
        public byte[] sign() {
            return EMPTY_BYTE_ARRAY;
        }
    }
}

