/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.activity.api.ActivityEntryId;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ActivityTypeId;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeJoin;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.jaxrs.IdParamConverter;

@Provider
public final class OrcsParamConverterProvider
implements ParamConverterProvider {
    private final ParamConverter<ArtifactTypeToken> artifactTypeConverter;
    private final ParamConverter<AttributeTypeGeneric<?>> attributeTypeConverter;
    private final ParamConverter<RelationTypeToken> relationTypeConverter;
    private final ParamConverter<ArtifactId> artifactIdConverter;
    private final ParamConverter<UserId> userIdConverter;
    private final ParamConverter<BranchId> branchIdConverter;
    private final ParamConverter<TransactionId> transactionIdConverter;
    private final ParamConverter<AttributeId> attributeIdConverter;
    private final ParamConverter<ActivityTypeId> activityTypeIdConverter;
    private final ParamConverter<ApplicabilityId> applicabilityIdConverter;
    private final ParamConverter<ActivityEntryId> activityEntryIdConverter;
    private final ParamConverter<BranchState> branchStateConverter;
    private final ParamConverter<BranchType> branchTypeConverter;
    private final ParamConverter<ArtifactTypeJoin> artifactTypeJoinConverter;
    private final ParamConverter<AttributeTypeJoin> attributeTypeJoinConverter;
    private final ParamConverter<RelationTypeJoin> relationTypeJoinConverter;
    private final ParamConverter<Id> idConverter = new IdParamConverter<Id>(null);

    public OrcsParamConverterProvider(OrcsTokenService tokenService) {
        if (tokenService == null) {
            this.artifactTypeConverter = null;
            this.attributeTypeConverter = null;
            this.relationTypeConverter = null;
            this.artifactTypeJoinConverter = null;
            this.attributeTypeJoinConverter = null;
            this.relationTypeJoinConverter = null;
        } else {
            this.artifactTypeConverter = new IdParamConverter<ArtifactTypeToken>(arg_0 -> ((OrcsTokenService)tokenService).getArtifactType(arg_0));
            this.attributeTypeConverter = new IdParamConverter<AttributeTypeGeneric>(arg_0 -> ((OrcsTokenService)tokenService).getAttributeType(arg_0));
            this.relationTypeConverter = new IdParamConverter<RelationTypeToken>(arg_0 -> ((OrcsTokenService)tokenService).getRelationType(arg_0));
            this.artifactTypeJoinConverter = new IdParamConverter<ArtifactTypeJoin>(arg_0 -> ((OrcsTokenService)tokenService).getArtifactTypeJoin(arg_0));
            this.attributeTypeJoinConverter = new IdParamConverter<AttributeTypeJoin>(arg_0 -> ((OrcsTokenService)tokenService).getAttributeTypeJoin(arg_0));
            this.relationTypeJoinConverter = new IdParamConverter<RelationTypeJoin>(arg_0 -> ((OrcsTokenService)tokenService).getRelationTypeJoin(arg_0));
        }
        this.userIdConverter = new IdParamConverter<UserId>(UserId::valueOf);
        this.branchIdConverter = new IdParamConverter<BranchId>(BranchId::valueOf);
        this.artifactIdConverter = new IdParamConverter<ArtifactId>(ArtifactId::valueOf);
        this.transactionIdConverter = new IdParamConverter<TransactionId>(TransactionId::valueOf);
        this.activityTypeIdConverter = new IdParamConverter<ActivityTypeId>(ActivityTypeId::valueOf);
        this.branchStateConverter = new IdParamConverter<BranchState>(BranchState::valueOf);
        this.branchTypeConverter = new IdParamConverter<BranchType>(BranchType::valueOf);
        this.attributeIdConverter = new IdParamConverter<AttributeId>(AttributeId::valueOf);
        this.applicabilityIdConverter = new IdParamConverter<ApplicabilityId>(ApplicabilityId::valueOf);
        this.activityEntryIdConverter = new IdParamConverter<ActivityEntryId>(ActivityEntryId::valueOf);
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (ArtifactTypeToken.class.equals(rawType)) {
            return this.artifactTypeConverter;
        }
        if (AttributeTypeToken.class.isAssignableFrom(rawType)) {
            return this.attributeTypeConverter;
        }
        if (RelationTypeToken.class.equals(rawType)) {
            return this.relationTypeConverter;
        }
        if (ArtifactTypeJoin.class.isAssignableFrom(rawType)) {
            return this.artifactTypeJoinConverter;
        }
        if (AttributeTypeJoin.class.isAssignableFrom(rawType)) {
            return this.attributeTypeJoinConverter;
        }
        if (RelationTypeJoin.class.isAssignableFrom(rawType)) {
            return this.relationTypeJoinConverter;
        }
        if (ActivityTypeId.class.isAssignableFrom(rawType)) {
            return this.activityTypeIdConverter;
        }
        if (UserId.class.isAssignableFrom(rawType)) {
            return this.userIdConverter;
        }
        if (BranchId.class.isAssignableFrom(rawType)) {
            return this.branchIdConverter;
        }
        if (ArtifactId.class.isAssignableFrom(rawType)) {
            return this.artifactIdConverter;
        }
        if (TransactionId.class.isAssignableFrom(rawType)) {
            return this.transactionIdConverter;
        }
        if (AttributeId.class.isAssignableFrom(rawType)) {
            return this.attributeIdConverter;
        }
        if (BranchState.class.isAssignableFrom(rawType)) {
            return this.branchStateConverter;
        }
        if (BranchType.class.isAssignableFrom(rawType)) {
            return this.branchTypeConverter;
        }
        if (ApplicabilityId.class.isAssignableFrom(rawType)) {
            return this.applicabilityIdConverter;
        }
        if (ActivityEntryId.class.isAssignableFrom(rawType)) {
            return this.activityEntryIdConverter;
        }
        if (Id.class.isAssignableFrom(rawType)) {
            return this.idConverter;
        }
        return null;
    }
}

