/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.define.api.importing.IArtifactExtractor;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workflow.AtsAttachment;
import org.eclipse.osee.ats.api.workflow.AtsAttachments;
import org.eclipse.osee.ats.core.config.OrganizePrograms;
import org.eclipse.osee.define.rest.importing.operations.RoughToRealArtifactOperation;
import org.eclipse.osee.define.rest.importing.operations.SourceToRoughArtifactOperation;
import org.eclipse.osee.define.rest.importing.parsers.NativeDocumentExtractor;
import org.eclipse.osee.define.rest.importing.parsers.WholeWordDocumentExtractor;
import org.eclipse.osee.define.rest.importing.resolvers.ArtifactResolverFactory;
import org.eclipse.osee.define.rest.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class AtsDbConfigBase {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;
    private final OrcsBranch branchOps;

    public AtsDbConfigBase(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.branchOps = orcsApi.getBranchOps();
    }

    String getMultipleArtEntriesonCommon(AtsApi atsApi) {
        return "SELECT DISTINCT art1.art_id FROM osee_artifact art1, osee_artifact art2, \nosee_txs txs WHERE art1.ART_ID = art2.ART_ID AND \nart1.art_type_id = art2.art_type_id AND art1.GAMMA_ID <> art2.GAMMA_ID AND \nart2.GAMMA_ID = txs.GAMMA_ID and txs.BRANCH_ID = 570 ORDER BY art1.art_id";
    }

    public XResultData run() {
        OseeInfo.setValue((JdbcClient)this.atsApi.getJdbcService().getClient(), (String)"osee.work.def.as.name", (String)"true");
        XResultData results = this.createAtsFolders();
        if (results.isErrors()) {
            return results;
        }
        TeamDefinition topTeam = this.atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)AtsArtifactToken.TopTeamDefinition);
        ActionableItem topAi = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)AtsArtifactToken.TopActionableItem);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Top Team Work Definition");
        this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsTeamDefinition)topTeam, (NamedIdBase)AtsWorkDefinitionTokens.WorkDef_Team_Default, changes);
        changes.setSoleAttributeValue((IAtsObject)topAi, (AttributeTypeToken)AtsAttributeTypes.Actionable, (Object)false);
        changes.execute();
        changes.reset("Create ATS CM Artifact");
        ArtifactToken art = changes.createArtifact(AtsArtifactToken.AtsTopFolder, AtsArtifactToken.AtsCmBranch);
        changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Used to denote Baseline branch as ATS CM branch");
        changes.execute();
        List artIds = this.atsApi.getQueryService().getArtifactIdsFromQuery(this.getMultipleArtEntriesonCommon(this.atsApi), new Object[0]);
        Conditions.assertTrue((boolean)artIds.isEmpty(), (String)"Duplicate artifact ids found [%s]", (Object[])new Object[]{artIds});
        this.atsApi.clearCaches();
        AtsDbConfigBase.createUserGroups(this.atsApi);
        AtsDbConfigBase.getOrCreateAtsConfig(this.atsApi);
        this.createUserCreationDisabledConfig();
        this.createAndconfigureProcessesBranchAndDemoPeerChecklist();
        this.configureWalkthroughChecklist();
        this.createPeerReviewUserGroup();
        return results;
    }

    private void createPeerReviewUserGroup() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create Peer Review User Group", (BranchId)CoreBranches.COMMON);
        ArtifactToken userGroupArt = this.atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.UserGroups, (BranchId)CoreBranches.COMMON);
        ArtifactToken artifact = changes.createArtifact(userGroupArt, (ArtifactToken)AtsUserGroups.peerReviewCreationNotify);
        changes.addAttribute((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.Email, (Object)"testemail@boeing.com");
        changes.execute();
    }

    private void createAndconfigureProcessesBranchAndDemoPeerChecklist() {
        AtsAttachments checklists = new AtsAttachments();
        checklists.addAttachment(new AtsAttachment("Document_Checklist", "osee", (BranchId)DemoBranches.Processes));
        checklists.addAttachment(new AtsAttachment("Process_Checklist", "osee", (BranchId)DemoBranches.Processes));
        String jsonToStore = this.atsApi.jaxRsApi().toJson((Object)checklists);
        this.atsApi.setConfigValue("PeerReviewChecklist", jsonToStore);
        Branch branch = this.branchOps.createBaselineBranch(DemoBranches.Processes, (ArtifactId)DemoUsers.Joe_Smith, CoreBranches.SYSTEM_ROOT, ArtifactId.SENTINEL);
        this.branchOps.setBranchPermission((ArtifactId)CoreUserGroups.Everyone, (BranchId)branch, PermissionEnum.READ);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create PR Attachment Folder", (BranchId)branch);
        ArtifactToken branchRoot = this.atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, (BranchId)branch);
        changes.createArtifact(branchRoot, AtsArtifactToken.PeerAttachmentFolder);
        changes.execute();
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction((BranchId)DemoBranches.Processes, (UserId)SystemUser.OseeSystem, "Import Peer Checklist");
        File file = OseeInf.getResourceAsFile((String)"demoPeerChecklists/Document_Checklist.xlsx", AtsDbConfigBase.class);
        this.importChecklist(file, transaction, AtsArtifactToken.PeerAttachmentFolder);
        File file2 = OseeInf.getResourceAsFile((String)"demoPeerChecklists/Process_Checklist.xlsx", AtsDbConfigBase.class);
        this.importChecklist(file2, transaction, AtsArtifactToken.PeerAttachmentFolder);
        transaction.commit();
    }

    private void configureWalkthroughChecklist() {
        AtsAttachments checklists = new AtsAttachments();
        checklists.addAttachment(new AtsAttachment("W_Document_Checklist", "osee", (BranchId)DemoBranches.Processes));
        checklists.addAttachment(new AtsAttachment("W_Process_Checklist", "osee", (BranchId)DemoBranches.Processes));
        String jsonToStore = this.atsApi.jaxRsApi().toJson((Object)checklists);
        this.atsApi.setConfigValue("XAttachmentExampleWidget", jsonToStore);
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create WT Attachment Folder", (BranchId)DemoBranches.Processes);
        ArtifactToken branchRoot = this.atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, (BranchId)DemoBranches.Processes);
        changes.createArtifact(branchRoot, AtsArtifactToken.WalkthroughAttachmentFolder);
        changes.execute();
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction((BranchId)DemoBranches.Processes, (UserId)SystemUser.OseeSystem, "Import Walkthrough Checklist");
        File file = OseeInf.getResourceAsFile((String)"demoWalkthroughChecklists/W_Document_Checklist.xlsx", AtsDbConfigBase.class);
        this.importChecklist(file, transaction, AtsArtifactToken.WalkthroughAttachmentFolder);
        File file2 = OseeInf.getResourceAsFile((String)"demoWalkthroughChecklists/W_Process_Checklist.xlsx", AtsDbConfigBase.class);
        this.importChecklist(file2, transaction, AtsArtifactToken.WalkthroughAttachmentFolder);
        transaction.commit();
    }

    private void importChecklist(File file, TransactionBuilder transaction, ArtifactToken token) {
        IArtifactExtractor extractor = this.getArtifactExtractor(CoreArtifactTypes.GeneralDocument);
        XResultData resultData = new XResultData();
        RoughArtifactCollector collector = new RoughArtifactCollector(new RoughArtifact(this.orcsApi, resultData, CoreArtifactTypes.GeneralDocument, "Code_Checklist"));
        IArtifactImportResolver resolver = ArtifactResolverFactory.createResolver((TransactionBuilder)transaction, (ArtifactResolverFactory.ArtifactCreationStrategy)ArtifactResolverFactory.ArtifactCreationStrategy.CREATE_ON_NEW_ART_GUID, (ArtifactTypeToken)CoreArtifactTypes.GeneralDocument, Arrays.asList(CoreAttributeTypes.Name), (boolean)true, (boolean)false);
        ArtifactReadable attachmentFolder = this.orcsApi.getQueryFactory().fromBranch((BranchId)DemoBranches.Processes).andId((ArtifactId)token).asArtifact();
        SourceToRoughArtifactOperation sourceToRoughArtifactOperation = new SourceToRoughArtifactOperation(this.orcsApi, resultData, extractor, file, collector);
        sourceToRoughArtifactOperation.importFiles();
        RoughToRealArtifactOperation roughToRealArtifactOperation = new RoughToRealArtifactOperation(this.orcsApi, resultData, transaction, attachmentFolder, collector, resolver, false, extractor);
        roughToRealArtifactOperation.doWork();
    }

    private IArtifactExtractor getArtifactExtractor(ArtifactTypeToken artifactType) {
        Object extractor = null;
        extractor = artifactType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.GeneralDocument) ? new NativeDocumentExtractor() : new WholeWordDocumentExtractor();
        return extractor;
    }

    public static void createUserGroups(AtsApi atsApi) {
        if (atsApi.getQueryService().getArtifact((ArtifactId)AtsUserGroups.AtsAdmin) == null) {
            IAtsChangeSet changes = atsApi.createChangeSet("Create Admin groups");
            ArtifactToken userGroup = atsApi.getQueryService().getArtifact((ArtifactId)CoreArtifactTokens.UserGroups);
            changes.createArtifact(userGroup, (ArtifactToken)AtsUserGroups.AtsAdmin);
            changes.createArtifact(userGroup, (ArtifactToken)AtsUserGroups.AtsTempAdmin);
            changes.execute();
        }
    }

    public static ArtifactId getOrCreateAtsConfig(AtsApi atsApi) {
        ArtifactToken atsConfigArt = atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsConfig);
        if (atsConfigArt == null) {
            IAtsChangeSet changes = atsApi.createChangeSet("Create AtsConfig");
            changes.createArtifact(AtsArtifactToken.AtsTopFolder, AtsArtifactToken.AtsConfig);
            changes.execute();
        }
        return atsConfigArt;
    }

    private void createUserCreationDisabledConfig() {
        this.atsApi.setConfigValue("UserCreationDisabled2", String.valueOf(AtsArtifactTypes.Action.toStringWithId()) + ";" + AtsArtifactTypes.TeamWorkflow.toStringWithId());
    }

    public XResultData createAtsFolders() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create ATS Folders");
        ArtifactToken headingArt = this.atsApi.getQueryService().getOrCreateArtifact(CoreArtifactTokens.OseeConfiguration, AtsArtifactToken.AtsTopFolder, changes);
        for (ArtifactToken token : Arrays.asList(AtsArtifactToken.TopActionableItem, AtsArtifactToken.TopTeamDefinition, AtsArtifactToken.WorkDefinitionsFolder)) {
            this.atsApi.getQueryService().getOrCreateArtifact(headingArt, token, changes);
        }
        changes.execute();
        XResultData results = new OrganizePrograms(this.atsApi).run();
        return results;
    }
}

