/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.define.api.OseeLinkBuilder;
import org.eclipse.osee.define.rest.internal.wordupdate.IElementExtractor;
import org.eclipse.osee.define.rest.internal.wordupdate.WordExtractorData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WordImageArtifactElementExtractor
implements IElementExtractor {
    private static final String SECTION_TAG = "wx:sect";
    private static final String SUB_SECTION_TAG = "wx:sub-section";
    private static final String BODY_TAG = "w:body";
    private static final String PICT = "w:pict";
    private static final String SRC = "src";
    private static final String BIN_DATA = "w:binData";
    private static final String IMAGE = "v:imagedata";
    private static String START_IMG_ID;
    private static String END_IMG_ID;
    private static int START_IMAGE_CHECKSUM;
    private static int END_IMAGE_CHECKSUM;
    private static final String TITLE = "o:title";
    private final Map<String, Element> pictureMap;
    private Element oleDataElement;
    private final Document document;
    private int numberOfStartTags;
    private int numberOfEndTags;
    private String guid;

    public WordImageArtifactElementExtractor(Document document) {
        this.document = document;
        this.numberOfEndTags = 0;
        this.numberOfStartTags = 0;
        this.pictureMap = new HashMap<String, Element>();
        START_IMAGE_CHECKSUM = -1;
        END_IMAGE_CHECKSUM = -1;
    }

    @Override
    public Element getOleDataElement() {
        return this.oleDataElement;
    }

    public List<WordExtractorData> extractElements() throws DOMException {
        OseeLinkBuilder linkBuilder = new OseeLinkBuilder();
        return this.extractElements(linkBuilder);
    }

    private void resetClassFields() {
        this.pictureMap.clear();
        this.numberOfStartTags = 0;
        this.numberOfEndTags = 0;
        this.oleDataElement = null;
        this.guid = null;
    }

    public List<WordExtractorData> extractElements(OseeLinkBuilder linkBuilder) throws DOMException {
        LinkedList<WordExtractorData> artifactElements = new LinkedList<WordExtractorData>();
        Element rootElement = this.document.getDocumentElement();
        this.resetClassFields();
        NodeList nodeList = rootElement.getElementsByTagName("*");
        ParseState parseState = ParseState.LOOKING_FOR_START;
        this.handleImages(rootElement);
        this.oleDataElement = (Element)this.getElement(rootElement, "w:docOleData");
        WordExtractorData extractorData = null;
        int nodeSize = nodeList.getLength();
        int i = 0;
        while (i < nodeSize) {
            Element element = (Element)nodeList.item(i);
            if (this.properLevelChild(element)) {
                if (parseState == ParseState.LOOKING_FOR_END && extractorData != null) {
                    if (this.isArtifactEditTag(element, false)) {
                        parseState = this.handleEndElement(linkBuilder, extractorData, element);
                    } else {
                        extractorData.addChild(element.cloneNode(true));
                    }
                } else if (this.isArtifactEditTag(element, true)) {
                    parseState = ParseState.LOOKING_FOR_END;
                    extractorData = new WordExtractorData();
                    this.handleStartElement(linkBuilder, artifactElements, element, extractorData);
                }
            }
            ++i;
        }
        this.validateEditTags();
        this.clearImageIds();
        return artifactElements;
    }

    private ParseState handleEndElement(OseeLinkBuilder linkBuilder, WordExtractorData extractorData, Element element) {
        ++this.numberOfEndTags;
        this.guid = null;
        ParseState parseState = ParseState.LOOKING_FOR_START;
        Node clonedElement = this.cloneWithoutArtifactEditImage(element, Side.left, linkBuilder);
        if (this.elementHasGrandChildren(clonedElement)) {
            extractorData.addChild(clonedElement);
        }
        return parseState;
    }

    private void handleStartElement(OseeLinkBuilder linkBuilder, List<WordExtractorData> artifactElements, Element element, WordExtractorData extractorData) {
        ++this.numberOfStartTags;
        Element newArtifactElement = this.document.createElement("WordAttribute.WORD_TEMPLATE_CONTENT");
        this.populateNewArtifactElement(newArtifactElement);
        extractorData.setGuid(this.guid);
        extractorData.addParent(newArtifactElement);
        artifactElements.add(extractorData);
        Node clonedElement = this.cloneWithoutArtifactEditImage(element, Side.right, linkBuilder);
        if (this.elementHasGrandChildren(clonedElement)) {
            extractorData.addChild(clonedElement);
        }
    }

    private void clearImageIds() {
        START_IMG_ID = null;
        END_IMG_ID = null;
        START_IMAGE_CHECKSUM = -1;
        END_IMAGE_CHECKSUM = -1;
    }

    private boolean elementHasGrandChildren(Node element) {
        return element.getChildNodes().getLength() > 0 && element.getChildNodes().item(0).getChildNodes().getLength() > 0;
    }

    private Node cloneWithoutArtifactEditImage(Element element, Side keepSide, OseeLinkBuilder linkBuilder) {
        LinkedList<Node> removals = new LinkedList<Node>();
        Element clonedElement = (Element)element.cloneNode(true);
        boolean beforeEditTag = true;
        boolean afterEditTag = false;
        NodeList descendants = clonedElement.getElementsByTagName("*");
        int nodeSize = descendants.getLength();
        int i = 0;
        while (i < nodeSize) {
            Node descendant = descendants.item(i);
            if (this.isEditStartImage(descendant)) {
                removals.add(descendant);
                beforeEditTag = false;
            } else if (this.isEditEndImage(descendant)) {
                removals.add(descendant);
                afterEditTag = true;
            } else if (beforeEditTag && keepSide == Side.right || afterEditTag && keepSide == Side.left) {
                removals.add(descendant);
            }
            ++i;
        }
        for (Node remove : removals) {
            Node parentNode = remove.getParentNode();
            if (parentNode == null) continue;
            parentNode.removeChild(remove);
        }
        return clonedElement;
    }

    private boolean isEditEndImage(Node descendant) {
        return this.isEditImage(descendant, false);
    }

    private boolean isEditStartImage(Node descendant) {
        return this.isEditImage(descendant, true);
    }

    private boolean isEditImage(Node element, boolean lookingForStartImage) {
        boolean hasEditImage = false;
        String name = element.getNodeName();
        if (name.equals(PICT)) {
            hasEditImage = this.isImageBinData((Element)element, lookingForStartImage);
        }
        return hasEditImage;
    }

    private boolean isImageBinData(Element pictElement, boolean lookingForStart) {
        boolean foundBinData = false;
        String imageId = lookingForStart ? START_IMG_ID : END_IMG_ID;
        foundBinData = imageId == null ? this.compareBinData(pictElement, lookingForStart) : this.compareImageId(imageId, this.getImageId(pictElement));
        if (foundBinData) {
            this.setGuid(pictElement);
        }
        return foundBinData;
    }

    private boolean compareImageId(String storedImageId, String currentElementId) {
        return storedImageId.equals(currentElementId);
    }

    private boolean compareBinData(Element pictElement, boolean lookingForStart) {
        boolean foundBindata = false;
        int imageCheckSum = this.getImageChecksum(lookingForStart);
        Node currentBinData = this.getElement(pictElement, BIN_DATA);
        if (currentBinData != null) {
            Node bindDataValue = currentBinData.getFirstChild();
            boolean bl = foundBindata = WordImageArtifactElementExtractor.getCheckSum(bindDataValue.getNodeValue()) == imageCheckSum;
            if (foundBindata) {
                if (lookingForStart) {
                    START_IMG_ID = this.getImageId(pictElement);
                } else {
                    END_IMG_ID = this.getImageId(pictElement);
                }
            }
        }
        return foundBindata;
    }

    private int getImageChecksum(boolean lookingForStart) {
        int imageCheckSum;
        if (lookingForStart) {
            String binData = OseeLinkBuilder.START_BIN_DATA;
            if (START_IMAGE_CHECKSUM == -1) {
                START_IMAGE_CHECKSUM = WordImageArtifactElementExtractor.getCheckSum(binData);
            }
            imageCheckSum = START_IMAGE_CHECKSUM;
        } else {
            String binData = "/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAUAEcDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD1jUPE2oR+NF8NabpdtcTf2f8Ab2mubxoVC+YY9uFjck5wf886s2t6fYIE1XUNPsrpIFnmie6UCNSQu7LbSV3naGIGTjoeK5HxB4emufiUmsXXhn+29KGji1CYt32zecWztldei55H9761V17wjfal4hvL210VI7U+EpbCzjYxAwXLFgsYAbCkIxXI+XBIzivYWGwk1BOSj7t3qt+2r0+5fMzvJXO11/XrTQNMubmaSFrmO2muILV5gj3HlIXYLnk8DkgHGc1Pouo/2xoOnan5Xk/bLaO48vdu2b1DYzgZxnrivMdQ8E681ra7dJhvDJ4QXSHiedB5FyhVwWzweR8pXPzKMlR8w9H8MWc+neE9GsbqPy7m2sYIZUyDtdY1BGRweQelY4rD4elh04TUpX79PS44tt6mUnifVb3xVrWiaZpFlL/ZXkeZNc37Rb/NTeMKsT9MEdfSp/GHi+08J6Je3mIbq8tokm+w/aAkjRtKse/oSFy3XGMjFc3J4cdPH/iXU9T8Hf21Z332X7HJttZNuyLa/EsilcnHbnb9KyvG/gnXtSuvGH2HSYb4av8AYJrSUzovktCNjgbuQ+CfQbWb5s/KeylhcFOvTUpJRtBvXdvk5k3zabyb0VrNIlykkzstT8c2OhTa62rrDBaaZ5IieO6SWW5eRC2zyh8yNxxu6jLcAEjpoJ4rmCOeCVJYZVDxyRsGV1IyCCOCCO9eZeJfBeuas/xCW2tkA1ZbBrFnlUCYwgF165U5GBuwMkc45r02CRpYI5HheF3UM0UhBZCR907SRkdOCR7muHF0sPClCVJ+87X1/uQe3q5J+a6bFRbvqSUUUV55YUUUUAFZV54Y8P6jdPdX2h6Zc3MmN809pG7tgYGSRk8AD8KKKuFScHeDt6Ba5owQRW0EcEESRQxKEjjjUKqKBgAAcAAdqkooqG76sAooooAKKKKAP//Z";
            if (END_IMAGE_CHECKSUM == -1) {
                END_IMAGE_CHECKSUM = WordImageArtifactElementExtractor.getCheckSum(binData);
            }
            imageCheckSum = END_IMAGE_CHECKSUM;
        }
        return imageCheckSum;
    }

    private String getImageId(Element pictElement) {
        Node srcAttribute;
        String imgId = null;
        Node imageData = this.getElement(pictElement, IMAGE);
        if (imageData != null && (srcAttribute = imageData.getAttributes().getNamedItem(SRC)) != null) {
            imgId = srcAttribute.getNodeValue();
        }
        return imgId;
    }

    private void setGuid(Element pictElement) {
        Node srcAttribute;
        Node imageData = this.getElement(pictElement, IMAGE);
        if (imageData != null && (srcAttribute = imageData.getAttributes().getNamedItem(TITLE)) != null) {
            this.guid = srcAttribute.getNodeValue();
        }
    }

    private Node getElement(Element element, String name) {
        Node discoveredNode = null;
        NodeList descendants = element.getElementsByTagName(name);
        if (descendants.getLength() > 0) {
            discoveredNode = descendants.item(0);
        }
        return discoveredNode;
    }

    private static int getCheckSum(String data) {
        int checksum = -1;
        int index = 0;
        while (index < data.length()) {
            char character = data.charAt(index);
            if (character != '\n' && character != '\t' && character != '\r' && character != ' ') {
                checksum += character;
            }
            ++index;
        }
        return checksum;
    }

    private void validateEditTags() {
        if (this.numberOfStartTags == 0 || this.numberOfEndTags != this.numberOfStartTags) {
            throw new OseeCoreException("This document is missing start/end edit tags, therefore the document will not be saved. You can re-edit the artifact and the edit tags should reappear.", new Object[0]);
        }
    }

    private void populateNewArtifactElement(Element newArtifactElement) throws DOMException {
        newArtifactElement.setAttribute("guid", this.guid);
    }

    private boolean isArtifactEditTag(Element element, boolean lookingForStart) {
        boolean isArtifactEditTag = false;
        NodeList descendants = element.getElementsByTagName(PICT);
        int nodeSize = descendants.getLength();
        int i = 0;
        while (i < nodeSize) {
            Node descendant = descendants.item(i);
            isArtifactEditTag = this.isEditImage(descendant, lookingForStart);
            if (isArtifactEditTag) break;
            ++i;
        }
        return isArtifactEditTag;
    }

    private boolean properLevelChild(Element element) {
        return this.properLevelChildWord2003(element) || this.properLevelChildWord2007(element);
    }

    private void handleImages(Element element) {
        NodeList descendants = element.getElementsByTagName(PICT);
        int nodeSize = descendants.getLength();
        int i = 0;
        while (i < nodeSize) {
            Node descendant = descendants.item(i);
            NodeList imageDataElement = ((Element)descendant).getElementsByTagName(IMAGE);
            if (imageDataElement.getLength() > 0) {
                String imgKey = ((Element)imageDataElement.item(0)).getAttribute(SRC);
                Element storedPictureElement = this.pictureMap.get(imgKey);
                NodeList binDataElement = ((Element)descendant).getElementsByTagName(BIN_DATA);
                if (storedPictureElement != null) {
                    if (binDataElement.getLength() == 0) {
                        descendant.appendChild(storedPictureElement.cloneNode(true));
                    }
                } else {
                    this.pictureMap.put(imgKey, (Element)binDataElement.item(0));
                }
            }
            ++i;
        }
    }

    private String getAncestorName(Element element, int level) {
        String name = "";
        Node parent = element;
        int i = 0;
        while (i < level) {
            if (parent != null) {
                parent = parent.getParentNode();
            }
            ++i;
        }
        if (parent != null) {
            name = parent.getNodeName();
        }
        return name;
    }

    private boolean properLevelChildWord2003(Element element) {
        boolean subsectionChild;
        String grandParentName = this.getAncestorName(element, 2);
        String parentName = this.getAncestorName(element, 1);
        String myName = element.getNodeName();
        boolean nonSubsectionBodyChild = parentName.equals(BODY_TAG) && !myName.equals(SUB_SECTION_TAG) && !myName.equals(SECTION_TAG);
        boolean sectionChild = grandParentName.equals(BODY_TAG) && parentName.equals(SECTION_TAG) && !myName.equals(SUB_SECTION_TAG);
        boolean bl = subsectionChild = parentName.equals(SUB_SECTION_TAG) && !myName.equals(SUB_SECTION_TAG);
        return nonSubsectionBodyChild || sectionChild || subsectionChild;
    }

    private boolean properLevelChildWord2007(Element element) {
        boolean subsectionChild;
        String parentName = this.getAncestorName(element, 1);
        String myName = element.getNodeName();
        boolean nonSubsectionBodyChild = parentName.equals(BODY_TAG) && !myName.equals(SUB_SECTION_TAG) && !myName.equals(SECTION_TAG);
        boolean bl = subsectionChild = parentName.equals(SUB_SECTION_TAG) && !myName.equals(SUB_SECTION_TAG);
        return nonSubsectionBodyChild || subsectionChild;
    }

    private static enum ParseState {
        LOOKING_FOR_START,
        LOOKING_FOR_END;

    }

    private static enum Side {
        left,
        right;

    }
}

