/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.define.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.parsers.WordOutlineExtractorDelegate;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class DoorsWordOutlineExtractor
extends WordOutlineExtractorDelegate {
    private static final Pattern reqnamePattern = Pattern.compile("(\\{[^}]+\\})(.*?</w:p>)");
    private static final Pattern outlinePattern = Pattern.compile("(\\{[^}]+\\})");
    private static final Pattern doorsIdPattern = Pattern.compile("\\{[^-]+\\-([^}]+)\\}");
    private int lastReqNumber = 1;

    @Override
    protected void addChildRoughArtifact(OrcsApi orcsApi, XResultData results, String content, RoughArtifactCollector collector) {
        StringBuilder newName = new StringBuilder();
        StringBuilder newContent = new StringBuilder();
        if (this.needsNewArt(content, newName, newContent)) {
            Matcher match;
            this.setContent();
            String number = String.format("%s.0.%d", this.lastHeaderNumber.toString(), this.lastReqNumber++);
            String name = newName.toString();
            if (name.contains("<w")) {
                name = name.replaceAll("<[^>]+>", "");
            }
            this.roughArtifact = new RoughArtifact(orcsApi, results, this.getRoughArtifactType(name));
            this.roughArtifact.setName(name);
            if (collector != null) {
                collector.addRoughArtifact(this.roughArtifact);
            }
            if (Strings.isValid((String)number)) {
                this.roughArtifact.setSectionNumber(number);
                this.roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, number);
            }
            if ((match = doorsIdPattern.matcher(name)).find()) {
                String toSet = match.group(1);
                this.roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.StaticId, toSet);
            }
            this.roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.PublishInline, "True");
            this.wordFormattedContent.append(newContent.toString());
            this.setArtifactType(this.roughArtifact, number);
            this.previousNamedArtifact = this.roughArtifact;
        } else {
            this.wordFormattedContent.append(content);
        }
    }

    private RoughArtifactKind getRoughArtifactType(String newName) {
        RoughArtifactKind toReturn = RoughArtifactKind.PRIMARY;
        if (newName.contains("Doc Dsc")) {
            toReturn = RoughArtifactKind.TERTIARY;
        } else if (newName.contains("Dsg Dsc")) {
            toReturn = RoughArtifactKind.QUATERNARY;
        }
        return toReturn;
    }

    private void setArtifactType(RoughArtifact art, String number) {
        RoughArtifactKind setType = art.getRoughArtifactKind();
        if (setType.equals((Object)RoughArtifactKind.PRIMARY) && number.startsWith("3.")) {
            art.setType(CoreArtifactTypes.SystemRequirementMsWord);
        }
    }

    @Override
    public void processHeadingText(RoughArtifact roughArtifact, String headingText) {
        roughArtifact.setRoughArtifactKind(RoughArtifactKind.SECONDARY);
        Matcher match = outlinePattern.matcher(headingText);
        if (match.find()) {
            roughArtifact.setName(headingText.substring(0, match.start(1)).trim());
            Matcher matchId = doorsIdPattern.matcher(headingText);
            if (matchId.find()) {
                roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.StaticId, matchId.group(1));
            }
            return;
        }
        roughArtifact.setName(headingText.trim());
    }

    @Override
    protected boolean checkSectionNumber(String sectionNumber) {
        return sectionNumber.contains(".0.");
    }

    @Override
    public void resetReqNumber() {
        this.lastReqNumber = 1;
    }

    @Override
    public String getName() {
        return "Doors Word Outline";
    }

    private boolean needsNewArt(String content, StringBuilder newName, StringBuilder newContent) {
        if (content.contains("####")) {
            return false;
        }
        Matcher match = reqnamePattern.matcher(content);
        if (match.find()) {
            String begin = content.substring(0, match.start(1));
            newName.append(content.substring(match.start(1), match.start(2)));
            String endString = content.substring(match.start(2), match.end(2));
            newContent.append(String.valueOf(begin) + endString);
            return true;
        }
        return false;
    }
}

