/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.event;

import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.event.EventType;
import org.osgi.service.event.Event;

public class AbstractTopicEvent {
    private EventType eventType;
    private TransactionToken transaction = TransactionToken.SENTINEL;
    private String topic;

    protected AbstractTopicEvent(EventType eventType, TransactionToken transaction, String topic) {
        this.eventType = eventType;
        this.transaction = transaction;
        this.topic = topic;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String toString() {
        return "EventTopic [eventType=" + (Object)((Object)this.eventType) + ", topic=" + this.topic + "]";
    }

    public boolean matches(Event event) {
        return this.getTopic().equals(event.getTopic());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTopicEvent other = (AbstractTopicEvent)obj;
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    public TransactionToken getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionToken transaction) {
        this.transaction = transaction;
    }
}

