/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.sync.jira;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.jira.JiraByEpicData;
import org.eclipse.osee.ats.core.column.AssigneeColumn;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.JiraTask;
import org.eclipse.osee.ats.rest.internal.workitem.sync.jira.SyncJiraOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class JiraReportEpicDiffsOperation {
    private final AtsApi atsApi;
    private final XResultData results;
    private final JiraByEpicData data;
    private final List<ColumnName> colNames = new ArrayList<ColumnName>();
    private ColumnName[] colsOrdered;
    private final List<String> atsIds = new ArrayList<String>();

    public JiraReportEpicDiffsOperation(JiraByEpicData data, AtsApi atsApi) {
        this.data = data;
        this.atsApi = atsApi;
        if (data.getResults() == null) {
            data.setResults(new XResultData());
        }
        this.results = data.getResults();
    }

    public XResultData run() {
        ElapsedTime allTime = new ElapsedTime(this.getClass().getSimpleName(), true);
        this.results.log("Sync JIRA by Epic\n");
        HashMap<String, JiraTask> jTaskMap = new HashMap<String, JiraTask>();
        boolean firstLine = true;
        String[] stringArray = this.data.getTabDelimReport().split("\r\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String line = stringArray[n2];
            if (firstLine) {
                String[] stringArray2 = line.split("\t");
                int n4 = stringArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    String key = stringArray2[n5];
                    ColumnName[] columnNameArray = ColumnName.values();
                    int n6 = columnNameArray.length;
                    n3 = 0;
                    while (n3 < n6) {
                        ColumnName colName = columnNameArray[n3];
                        if (key.equals(colName.name().replaceAll("_", " "))) {
                            this.colNames.add(colName);
                        }
                        ++n3;
                    }
                    ++n5;
                }
                this.colsOrdered = this.colNames.toArray(new ColumnName[this.colNames.size()]);
                firstLine = false;
            } else {
                HashMap<ColumnName, String> colToValue = new HashMap<ColumnName, String>();
                String[] values = line.split("\t");
                int x = 0;
                String[] stringArray3 = values;
                n3 = values.length;
                int n7 = 0;
                while (n7 < n3) {
                    String value = stringArray3[n7];
                    ColumnName col = this.colsOrdered[x++];
                    colToValue.put(col, value);
                    ++n7;
                }
                JiraTask jTask = this.getJiraTask(colToValue, this.data.getResults());
                if (jTask == null) {
                    return this.results;
                }
                if (!jTask.getAtsIds().isEmpty()) {
                    jTaskMap.put(jTask.getAtsIds().iterator().next(), jTask);
                    this.atsIds.add(jTask.getAtsIds().iterator().next());
                }
            }
            ++n2;
        }
        Map workItemMap = this.atsApi.getQueryService().getWorkItemsByAtsId(this.atsIds);
        this.processWorkflows(workItemMap, jTaskMap, this.results);
        allTime.end(ElapsedTime.Units.MIN);
        return this.results;
    }

    private boolean processWorkflows(Map<String, IAtsWorkItem> workItemMap, Map<String, JiraTask> jTaskMap, XResultData rd) {
        for (Map.Entry<String, JiraTask> entry : jTaskMap.entrySet()) {
            boolean stateNoMatch;
            String oPoints;
            String jPoints;
            JiraTask jTask = entry.getValue();
            String atsId = null;
            if (!jTask.getAtsIds().isEmpty()) {
                atsId = jTask.getAtsIds().iterator().next();
            }
            String summary = jTask.getSummary();
            String amsId = jTask.getAmsId();
            if (Strings.isInValid((String)atsId)) {
                rd.errorf("JIRA entry has no TW/ATS ID in %s\n\n", new Object[]{this.getAmsStringWithId(summary, amsId)});
                continue;
            }
            IAtsWorkItem workItem = workItemMap.get(atsId);
            if (workItem == null) {
                rd.errorf("Can not get workitem for id %s\n\n", new Object[]{atsId});
                continue;
            }
            String assignees = AssigneeColumn.getAssigneeStrr((IAtsObject)workItem);
            if (!workItem.getName().equals(summary)) {
                rd.errorf("Titles do not match for %s\n[%s] (JIRA)\n[%s] (OSEE) - [%s]\n\n", new Object[]{atsId, summary, workItem.getName(), assignees});
            }
            if (!(jPoints = jTask.getPoints()).equals(oPoints = this.atsApi.getAgileService().getAgileTeamPointsStr(workItem))) {
                rd.errorf("Points do not match for %s - JIRA: [%s] - OSEE: [%s] - [%s]\n%s\n\n", new Object[]{atsId, jPoints, oPoints, assignees, workItem.toStringWithId()});
            }
            String jState = jTask.getStatus();
            String oState = null;
            boolean bl = stateNoMatch = workItem.isCompletedOrCancelled() && !jState.equals("Closed");
            if (!stateNoMatch) {
                oState = workItem.getStateMgr().getCurrentStateNameFast();
                boolean bl2 = stateNoMatch = oState.equals(TeamState.Analyze.getName()) && !jState.equals("To Do");
            }
            if (!stateNoMatch) {
                boolean bl3 = stateNoMatch = oState.equals(TeamState.Implement.getName()) && !jState.equals("In Progress");
            }
            if (!stateNoMatch) {
                boolean bl4 = stateNoMatch = oState.equals(TeamState.Review.getName()) && !jState.equals("In Review");
            }
            if (!stateNoMatch) continue;
            rd.errorf("States do not match for %s - JIRA: [%s] - OSEE: [%s] - [%s]\n%s\n\n", new Object[]{atsId, jState, oState, assignees, workItem.toStringWithId()});
        }
        return true;
    }

    private JiraTask getJiraTask(Map<ColumnName, String> colToValue, XResultData rd) {
        JiraTask jTask = new JiraTask();
        String atsId = null;
        String summary = colToValue.get((Object)ColumnName.Summary);
        jTask.setSummary(summary);
        String amsId = colToValue.get((Object)ColumnName.Key);
        jTask.setAmsId(amsId);
        if (Strings.isInValid((String)amsId) || Strings.isInValid((String)summary)) {
            rd.errorf("Must export Key and Summary", new Object[0]);
            return null;
        }
        if (Strings.isValid((String)colToValue.get((Object)ColumnName.Description))) {
            atsId = SyncJiraOperation.getAtsId(colToValue.get((Object)ColumnName.Description));
        }
        if (Strings.isInValid(atsId) && Strings.isValid((String)colToValue.get((Object)ColumnName.Summary))) {
            atsId = SyncJiraOperation.getAtsId(colToValue.get((Object)ColumnName.Summary));
        }
        if (Strings.isValid(atsId)) {
            jTask.getAtsIds().add(atsId);
        } else {
            rd.errorf("JIRA entry has no TW/ATS ID in %s\n\n", new Object[]{this.getAmsStringWithId(summary, amsId)});
        }
        String jPoints = colToValue.get((Object)ColumnName.Story_Points);
        jTask.setPoints(jPoints);
        String jState = colToValue.get((Object)ColumnName.Status);
        jTask.setStatus(jState);
        return jTask;
    }

    private Object getAmsStringWithId(String summary, String amsId) {
        return String.format("[%s]-[%s]", amsId, summary);
    }

    private static enum ColumnName {
        Key,
        Summary,
        Description,
        Epic_Link,
        Status,
        Story_Points;

    }
}

