/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.PlatformTypesEndpoint;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class PlatformTypesEndpointImpl
implements PlatformTypesEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfacePlatformTypeApi platformApi;

    public PlatformTypesEndpointImpl(BranchId branch, UserId account, InterfacePlatformTypeApi api) {
        this.account = account;
        this.branch = branch;
        this.platformApi = api;
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes() {
        try {
            return this.platformApi.getAccessor().getAll(this.branch, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public XResultData updatePlatformType(PlatformTypeToken platformTypeToken) {
        return this.platformApi.getInserter().replaceArtifact(platformTypeToken, this.account, this.branch);
    }

    @Override
    public XResultData createPlatformType(PlatformTypeToken platformTypeToken) {
        return this.platformApi.getInserter().addArtifact(platformTypeToken, this.account, this.branch);
    }

    @Override
    public PlatformTypeToken getPlatformType(ArtifactId typeId) {
        try {
            return this.platformApi.getAccessor().get(this.branch, typeId, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public XResultData removePlatformType(ArtifactId typeId) {
        return this.platformApi.getInserter().removeArtifact(typeId, this.account, this.branch);
    }

    @Override
    public XResultData patchPlatformType(PlatformTypeToken platformTypeToken) {
        return this.platformApi.getInserter().patchArtifact(platformTypeToken, this.account, this.branch);
    }
}

