/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.api.OseeLinkBuilder;
import org.eclipse.osee.define.rest.internal.wordupdate.OseeLinkParser;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class WordMlLinkHandler {
    private static final Pattern OSEE_LINK_PATTERN = Pattern.compile("OSEE_LINK\\((.*?)\\)", 32);
    private static final Pattern WORDML_LINK = Pattern.compile("<w:hlink\\s+w:dest=\"(.*?)\"[^>]*?(/>|>.*?</w:hlink\\s*>)", 32);
    private static final Pattern HYPERLINK_PATTERN = Pattern.compile("<w:r[^>]*><w:instrText>\\s*HYPERLINK\\s+\"(.+?)\"\\s*</w:instrText></w:r>(.*?</w:t>.+?</w:fldChar></w:r>)?", 32);
    private static final Pattern IS_GUID = Pattern.compile("\\D");
    public static final String WORDML_KEY = "wordml";
    public static final String UNKNOWNGUIDS_KEY = "unknownguids";
    private static final OseeLinkBuilder linkBuilder = new OseeLinkBuilder();

    private static LinkType checkLinkType(LinkType value) {
        return value != null ? value : LinkType.OSEE_SERVER_LINK;
    }

    public static String unlink(QueryFactory queryFactory, LinkType sourceLinkType, ArtifactReadable source, String content) {
        LinkType linkType = WordMlLinkHandler.checkLinkType(sourceLinkType);
        String modified = content;
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.parseOseeWordMLLinks(content);
        if (!matchMap.isEmpty()) {
            modified = WordMlLinkHandler.modifiedContent(queryFactory, linkType, source, content, matchMap, true, TransactionId.SENTINEL, null, null, null);
        }
        return modified;
    }

    public static String link(QueryFactory queryFactory, LinkType destLinkType, ArtifactReadable source, String content, TransactionId txId, Set<String> unknownGuids, PresentationType presentationType, String permanentUrl) {
        LinkType linkType = WordMlLinkHandler.checkLinkType(destLinkType);
        String modified = content;
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.parseOseeWordMLLinks(content);
        Matcher oseeMatcher = OSEE_LINK_PATTERN.matcher(content);
        while (oseeMatcher.find()) {
            String guid = oseeMatcher.group(1);
            if (!Strings.isValid((String)guid)) continue;
            matchMap.put((Object)guid, (Object)new MatchRange(oseeMatcher.start(), oseeMatcher.end()));
        }
        if (!matchMap.isEmpty()) {
            modified = WordMlLinkHandler.modifiedContent(queryFactory, linkType, source, content, matchMap, false, txId, unknownGuids, presentationType, permanentUrl);
        }
        if (linkType != LinkType.OSEE_SERVER_LINK) {
            modified = String.valueOf(linkBuilder.getWordMlBookmark(source)) + modified;
        }
        return modified;
    }

    public static String renderPlainTextWithoutLinks(QueryFactory queryFactory, BranchId branch, String content) {
        String modified = content;
        HashCollection<String, MatchRange> matchMap = WordMlLinkHandler.parseOseeWordMLLinks(content);
        Matcher oseeMatcher = OSEE_LINK_PATTERN.matcher(content);
        while (oseeMatcher.find()) {
            String guid = oseeMatcher.group(1);
            if (!Strings.isValid((String)guid)) continue;
            matchMap.put((Object)guid, (Object)new MatchRange(oseeMatcher.start(), oseeMatcher.end()));
        }
        if (!matchMap.isEmpty()) {
            String replaceWith;
            Matcher matcher;
            List<String> unknownGuids;
            ChangeSet changeSet = new ChangeSet((CharSequence)content);
            List<ArtifactReadable> artifactsFromSearch = null;
            ArrayList<String> guidsFromLinks = new ArrayList<String>(matchMap.keySet());
            artifactsFromSearch = WordMlLinkHandler.findArtifacts(queryFactory, branch, guidsFromLinks, TransactionId.SENTINEL);
            boolean isMergeBranch = ((BranchQuery)((BranchQuery)queryFactory.branchQuery().andId(branch)).andIsOfType(new BranchType[]{BranchType.MERGE})).exists();
            if (guidsFromLinks.size() != artifactsFromSearch.size() && isMergeBranch) {
                Branch branchReadable = (Branch)((BranchQuery)queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne();
                List<String> unknownGuids2 = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch);
                ArrayList<ArtifactReadable> union = new ArrayList<ArtifactReadable>();
                union.addAll(WordMlLinkHandler.findArtifacts(queryFactory, branchReadable.getParentBranch(), unknownGuids2, TransactionId.SENTINEL));
                union.addAll(artifactsFromSearch);
                artifactsFromSearch = union;
            }
            if (guidsFromLinks.size() != artifactsFromSearch.size() && !(unknownGuids = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch)).isEmpty()) {
                for (String guid : unknownGuids) {
                    for (MatchRange match : (List)matchMap.getValues((Object)guid)) {
                        String link = linkBuilder.getUnknownArtifactLink(guid, branch);
                        changeSet.replace(match.start(), match.end(), link);
                    }
                }
            }
            if ((matcher = IS_GUID.matcher((CharSequence)matchMap.keySet().iterator().next())).find()) {
                for (ArtifactReadable artifact : artifactsFromSearch) {
                    for (MatchRange match : (List)matchMap.getValues((Object)artifact.getGuid())) {
                        replaceWith = null;
                        replaceWith = artifact.getName();
                        changeSet.replace(match.start(), match.end(), replaceWith);
                    }
                }
            } else {
                for (ArtifactReadable artifact : artifactsFromSearch) {
                    for (MatchRange match : (List)matchMap.getValues((Object)artifact.getIdString())) {
                        replaceWith = null;
                        replaceWith = artifact.getName();
                        changeSet.replace(match.start(), match.end(), replaceWith);
                    }
                }
            }
            return changeSet.applyChangesToSelf().toString();
        }
        return modified;
    }

    public static HashCollection<String, MatchRange> parseOseeWordMLLinks(String content) {
        HashCollection matchMap = new HashCollection();
        OseeLinkParser linkParser = new OseeLinkParser();
        Matcher wordMlMatcher = WORDML_LINK.matcher(content);
        while (wordMlMatcher.find()) {
            String link = wordMlMatcher.group(1);
            if (!Strings.isValid((String)link)) continue;
            linkParser.parse(link);
            String guid = linkParser.getGuid();
            if (!Strings.isValid((String)guid)) continue;
            matchMap.put((Object)guid, (Object)new MatchRange(wordMlMatcher.start(), wordMlMatcher.end()));
        }
        Matcher hyperlinkMatcher = HYPERLINK_PATTERN.matcher(content);
        while (hyperlinkMatcher.find()) {
            String link = hyperlinkMatcher.group(1);
            if (!Strings.isValid((String)link)) continue;
            linkParser.parse(link);
            String guid = linkParser.getGuid();
            if (!Strings.isValid((String)guid)) continue;
            matchMap.put((Object)guid, (Object)new MatchRange(hyperlinkMatcher.start(), hyperlinkMatcher.end()));
        }
        return matchMap;
    }

    private static List<ArtifactReadable> findArtifacts(QueryFactory queryFactory, BranchId branch, List<String> guidsFromLinks, TransactionId txId) {
        QueryBuilder query;
        Matcher matcher = IS_GUID.matcher(guidsFromLinks.get(0));
        if (matcher.find()) {
            query = queryFactory.fromBranch(branch).andGuids(guidsFromLinks).includeDeletedArtifacts().includeDeletedAttributes();
        } else {
            LinkedList<ArtifactId> artIdsFromLinks = new LinkedList<ArtifactId>();
            for (String link : guidsFromLinks) {
                artIdsFromLinks.add(ArtifactId.valueOf((String)link));
            }
            query = queryFactory.fromBranch(branch).andIds(artIdsFromLinks).includeDeletedArtifacts().includeDeletedAttributes();
        }
        if (txId.isValid()) {
            query.fromTransaction(txId);
        }
        return query.getResults().getList();
    }

    private static List<String> getGuidsNotFound(List<String> guidsFromLinks, List<ArtifactReadable> artifactsFound) {
        HashSet<String> artGuids = new HashSet<String>();
        for (ArtifactReadable artifact : artifactsFound) {
            artGuids.add(artifact.getGuid());
        }
        return Collections.setComplement(guidsFromLinks, artGuids);
    }

    private static String modifiedContent(QueryFactory queryFactory, LinkType destLinkType, ArtifactReadable source, String original, HashCollection<String, MatchRange> matchMap, boolean isUnlinking, TransactionId txId, Set<String> unknown, PresentationType presentationType, String permanentUrl) {
        String replaceWith;
        Matcher matcher;
        BranchToken branch = source.getBranch();
        ChangeSet changeSet = new ChangeSet((CharSequence)original);
        List<ArtifactReadable> artifactsFromSearch = null;
        ArrayList<String> guidsFromLinks = new ArrayList<String>(matchMap.keySet());
        artifactsFromSearch = WordMlLinkHandler.findArtifacts(queryFactory, (BranchId)branch, guidsFromLinks, txId);
        boolean isMergeBranch = ((BranchQuery)((BranchQuery)queryFactory.branchQuery().andId((BranchId)branch)).andIsOfType(new BranchType[]{BranchType.MERGE})).exists();
        if (guidsFromLinks.size() != artifactsFromSearch.size() && isMergeBranch) {
            Branch branchReadable = (Branch)((BranchQuery)queryFactory.branchQuery().andId((BranchId)branch)).getResults().getExactlyOne();
            List<String> unknownGuids = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch);
            ArrayList<ArtifactReadable> union = new ArrayList<ArtifactReadable>();
            union.addAll(WordMlLinkHandler.findArtifacts(queryFactory, branchReadable.getParentBranch(), unknownGuids, txId));
            union.addAll(artifactsFromSearch);
            artifactsFromSearch = union;
        }
        if (guidsFromLinks.size() != artifactsFromSearch.size()) {
            List<String> unknownGuids = WordMlLinkHandler.getGuidsNotFound(guidsFromLinks, artifactsFromSearch);
            if (isUnlinking) {
                for (String guid : unknownGuids) {
                    Collection matches = matchMap.getValues((Object)guid);
                    for (MatchRange match : matches) {
                        String replaceWith2 = linkBuilder.getOseeLinkMarker(guid);
                        changeSet.replace(match.start(), match.end(), replaceWith2);
                    }
                }
            } else if (!unknownGuids.isEmpty()) {
                unknown.addAll(unknownGuids);
                for (String guid : unknownGuids) {
                    for (MatchRange match : (List)matchMap.getValues((Object)guid)) {
                        String link = linkBuilder.getUnknownArtifactLink(guid, (BranchId)branch);
                        changeSet.replace(match.start(), match.end(), link);
                    }
                }
            }
        }
        if ((matcher = IS_GUID.matcher((CharSequence)matchMap.keySet().iterator().next())).find()) {
            for (ArtifactReadable artifact : artifactsFromSearch) {
                for (MatchRange match : (List)matchMap.getValues((Object)artifact.getGuid())) {
                    replaceWith = null;
                    replaceWith = isUnlinking ? linkBuilder.getOseeLinkMarker(artifact.getGuid()) : linkBuilder.getWordMlLink(destLinkType, artifact, txId, presentationType, permanentUrl);
                    changeSet.replace(match.start(), match.end(), replaceWith);
                }
            }
        } else {
            for (ArtifactReadable artifact : artifactsFromSearch) {
                for (MatchRange match : (List)matchMap.getValues((Object)artifact.getIdString())) {
                    replaceWith = null;
                    replaceWith = isUnlinking ? linkBuilder.getOseeLinkMarker(artifact.getIdString()) : linkBuilder.getWordMlLink(destLinkType, artifact, txId, presentationType, permanentUrl);
                    changeSet.replace(match.start(), match.end(), replaceWith);
                }
            }
        }
        return changeSet.applyChangesToSelf().toString();
    }

    public static final class MatchRange {
        private final int start;
        private final int end;

        public MatchRange(int start, int end) {
            this.end = end;
            this.start = start;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public String toString() {
            return "{" + this.start + ", " + this.end + "}";
        }
    }
}

