/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.operations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.define.api.importing.DoorsImportFieldTokens;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class DoorsTier12RoughToRealOperation {
    private final OrcsApi orcsApi;
    private final RoughArtifactCollector rawData;
    private final ArtifactReadable destinationArtifact;
    private final BranchId branch;
    private final Map<String, ArtifactToken> knownArtsByOFD = new HashMap<String, ArtifactToken>();
    private final XResultData results;
    private static final String systemReqPrefix = "OFD";

    public DoorsTier12RoughToRealOperation(OrcsApi orcsApi, XResultData results, BranchId branch, ArtifactReadable destinationArtifact, RoughArtifactCollector rawData) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.rawData = rawData;
        this.destinationArtifact = destinationArtifact;
        this.results = results;
    }

    public XResultData doWork() {
        this.setupAllKnownArtifacts();
        String operationComment = String.format("Modify Safety Hazard for %s", this.destinationArtifact.getName());
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (UserId)SystemUser.OseeSystem, operationComment);
        for (RoughArtifact roughArtifact : this.rawData.getRoughArtifacts()) {
            String name = roughArtifact.getName();
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            this.resolve(transaction, roughArtifact, this.branch, (ArtifactId)this.destinationArtifact, (ArtifactId)this.destinationArtifact);
            this.results.logf("%s resolved", new Object[]{roughArtifact.getName()});
        }
        transaction.commit();
        return this.results;
    }

    public void resolve(TransactionBuilder transaction, RoughArtifact roughArtifact, BranchId branch, ArtifactId realParentId, ArtifactId rootId) {
        ArtifactReadable targetArtifact = this.findApplicableArtifact(roughArtifact, branch);
        if (targetArtifact != null && targetArtifact.isValid()) {
            try {
                transaction.createAttribute((ArtifactId)targetArtifact, (AttributeTypeToken)CoreAttributeTypes.Hazard, (Object)roughArtifact.getRoughAttribute(DoorsImportFieldTokens.blockAttrSafetyHazard.getImportTypeName()));
            }
            catch (Exception ex) {
                this.results.errorf("Exception: %s", new Object[]{ex.toString()});
            }
        } else {
            this.results.logf("Doors ID resolver cant find target artifact. roughArtifactifact: [%s]. DoorsId: [%s]", new Object[]{roughArtifact.getName(), roughArtifact.getAttributes().getSoleAttributeValue(DoorsImportFieldTokens.blockAttrSafetyHazard.getImportTypeName())});
        }
    }

    private ArtifactReadable findApplicableArtifact(RoughArtifact roughArtifact, BranchId branch) {
        ArtifactReadable current = null;
        String doorsId = roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName());
        if (doorsId.startsWith(systemReqPrefix)) {
            ArtifactToken currentToken = this.knownArtsByOFD.get(doorsId);
            try {
                current = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)currentToken).asArtifact();
            }
            catch (Exception exception) {
                this.results.errorf("Couldn't find artifact for %s with doorsId %s", new Object[]{roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName()), doorsId});
                return null;
            }
        }
        try {
            current = this.orcsApi.getQueryFactory().fromBranch(branch).andAttributeIs((AttributeTypeId)CoreAttributeTypes.DoorsId, doorsId).asArtifact();
        }
        catch (Exception exception) {
            this.results.errorf("Couldn't find artifact for %s with doorsId %s", new Object[]{roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName()), doorsId});
            return null;
        }
        if (!current.isTypeEqual((ArtifactTypeId)CoreArtifactTypes.SubsystemRequirementMsWord)) {
            this.results.errorf("Invalid import type %s for Doors Id:%s", new Object[]{current.getArtifactType().getName(), doorsId});
            current = null;
        }
        return current;
    }

    private void setupAllKnownArtifacts() {
        List knownIds = this.orcsApi.getQueryFactory().fromBranch(this.branch).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)this.destinationArtifact).asArtifactTokens((AttributeTypeToken)CoreAttributeTypes.DoorsId);
        knownIds.forEach(item -> {
            ArtifactToken artifactToken = this.knownArtsByOFD.put(item.getName(), (ArtifactToken)item);
        });
    }
}

