/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.LocationRangesCompressor;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public class ExportSet {
    private final DispoApi dispoApi;
    Map<CoverageLevel, WrapInt> levelToTotalCount = new HashMap<CoverageLevel, WrapInt>();
    Map<CoverageLevel, WrapInt> levelToCoveredTotalCount = new HashMap<CoverageLevel, WrapInt>();
    Map<String, Integer> defaultCases = new HashMap<String, Integer>();
    private final String LEVEL_A_LOCATION_PATTERN = "\\s*\\d+\\s*\\.\\s*\\d+.*?\\.\\s*(T|F)\\s*";
    private final String LEVEL_B_LOCATION_PATTERN = "(.*?RESULT.*|\\s*\\d+\\s*\\.\\s*(T|F).*)";
    private final int FALSE_PRESENT = 1;
    private final int TRUE_PRESENT = 2;
    private final int BOTH_PRESENT = 3;
    private final int FALSE_COVERED = 4;
    private final int TRUE_COVERED = 8;
    private final int BOTH_COVERED = 12;

    private void recordUnexpectedEvents(Set<String> resolutionTypes) {
        ArrayList<String> tempResolutionTypes = new ArrayList<String>(resolutionTypes);
        String wrongResolutions = "";
        for (String resolution : tempResolutionTypes) {
            if (!wrongResolutions.isEmpty()) {
                wrongResolutions = String.valueOf(wrongResolutions) + "/";
            }
            wrongResolutions = String.valueOf(wrongResolutions) + resolution;
        }
        if (this.defaultCases.containsKey(wrongResolutions)) {
            int count = this.defaultCases.get(wrongResolutions) + 1;
            this.defaultCases.replace(wrongResolutions, count);
        } else {
            this.defaultCases.put(wrongResolutions, 1);
        }
    }

    public ExportSet(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    public void runDispoReport(BranchId branch, DispoSet setPrimary, String option, OutputStream outputStream) {
        List<DispoItem> items = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)writer);
            Object[] headers = this.getHeadersDetailed();
            int columns = headers.length;
            sheetWriter.startSheet(setPrimary.getName(), headers.length);
            sheetWriter.writeRow(headers);
            for (DispoItem item : items) {
                DispoConnector connector = new DispoConnector();
                List<String> allUncoveredDiscprepancies = connector.getAllUncoveredDiscprepancies(item);
                List<Integer> allUncoveredDiscrepanciesAsInts = this.getDiscrepanciesAsInts(allUncoveredDiscprepancies);
                Object[] row = new String[columns];
                int index = 0;
                Map discrepanciesList = item.getDiscrepanciesList();
                row[index++] = String.valueOf(item.getName());
                row[index++] = String.valueOf(item.getCategory());
                row[index++] = String.valueOf(item.getStatus());
                row[index++] = String.valueOf(item.getTotalPoints());
                row[index++] = String.valueOf(item.getDiscrepanciesList().size());
                row[index++] = String.valueOf(DispoUtil.discrepanciesToString(discrepanciesList));
                row[index++] = String.valueOf(allUncoveredDiscprepancies.size());
                String uncoveredDiscrepancies = allUncoveredDiscrepanciesAsInts.isEmpty() ? DispoUtil.listToString(allUncoveredDiscprepancies) : LocationRangesCompressor.compress(allUncoveredDiscrepanciesAsInts);
                row[index++] = String.valueOf(uncoveredDiscrepancies);
                row[index++] = String.valueOf(item.getAssignee());
                row[index++] = String.valueOf(item.getTeam());
                row[index++] = String.valueOf(item.getItemNotes());
                row[index++] = String.valueOf(item.getNeedsRerun());
                row[index++] = String.valueOf(item.getAborted());
                row[index++] = String.valueOf(item.getMachine());
                row[index++] = String.valueOf(item.getElapsedTime());
                row[index++] = String.valueOf(item.getCreationDate());
                row[index++] = String.valueOf(item.getLastUpdate());
                row[index++] = String.valueOf(item.getVersion());
                row[index++] = String.valueOf(this.prettifyAnnotations(item.getAnnotationsList()));
                sheetWriter.writeRow(row);
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    public void runCoverageReport(BranchId branch, DispoSet setPrimary, String option, OutputStream outputStream) {
        HashMap<String, String> resolutionsValueToText = new HashMap<String, String>();
        HashSet<CoverageLevel> levelsInSet = new HashSet<CoverageLevel>();
        ArrayList<CoverageLevel> levelsInList = new ArrayList<CoverageLevel>();
        HashMap<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> leveltoUnitToCovered = new HashMap<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>>();
        CoverageLevel[] coverageLevelArray = CoverageLevel.values();
        int n = coverageLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoverageLevel level = coverageLevelArray[n2];
            leveltoUnitToCovered.put(level, new HashMap());
            this.levelToTotalCount.put(level, new WrapInt(0));
            this.levelToCoveredTotalCount.put(level, new WrapInt(0));
            ++n2;
        }
        List<DispoItem> items = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        HashMap<CoverageLevel, Map<String, WrapInt>> levelToResolutionTypesToCount = new HashMap<CoverageLevel, Map<String, WrapInt>>();
        DispoConfig config = this.dispoApi.getDispoConfig(branch);
        config.getValidResolutions();
        CoverageLevel[] coverageLevelArray2 = CoverageLevel.values();
        int n3 = coverageLevelArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            CoverageLevel level = coverageLevelArray2[n4];
            HashMap<String, WrapInt> innerMap = new HashMap<String, WrapInt>();
            for (Object resolutionType : config.getValidResolutions()) {
                innerMap.put(resolutionType.getText(), new WrapInt(0));
                resolutionsValueToText.put(resolutionType.getValue(), resolutionType.getText());
            }
            innerMap.put("MIXED", new WrapInt(0));
            innerMap.put("Defensive_Programming/Test_Script", new WrapInt(0));
            innerMap.put("Exception_Handling/Test_Script", new WrapInt(0));
            innerMap.put("Analysis/Test_Script", new WrapInt(0));
            innerMap.put("Deactivated_EXT_ATE_PRESENT/Test_Script", new WrapInt(0));
            innerMap.put("Deactivated_IN_AIR_OR_ENG_ON/Test_Script", new WrapInt(0));
            innerMap.put("Deactivated_J4_Connector/Test_Script", new WrapInt(0));
            innerMap.put("Deactivated_Compile_Time/Test_Script", new WrapInt(0));
            levelToResolutionTypesToCount.put(level, innerMap);
            ++n4;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)writer);
            Object[] headers = this.getHeadersCoverage();
            int columns = headers.length;
            sheetWriter.startSheet(setPrimary.getName(), headers.length);
            sheetWriter.writeRow(headers);
            for (DispoItem item : items) {
                HashMap<String, MCDCCoverageData> mcdcToCoverageData = new HashMap<String, MCDCCoverageData>();
                List annotations = item.getAnnotationsList();
                for (DispoAnnotationData annotation : annotations) {
                    this.writeRowAnnotation(sheetWriter, columns, item, annotation, setPrimary.getName(), levelToResolutionTypesToCount, leveltoUnitToCovered, mcdcToCoverageData, levelsInSet);
                }
            }
            levelsInList.addAll(levelsInSet);
            Collections.sort(levelsInList);
            sheetWriter.endSheet();
            sheetWriter.startSheet("Cover Sheet", headers.length);
            ArrayList<String> coverSheetHeadersList = new ArrayList<String>();
            coverSheetHeadersList.add(" ");
            if (levelsInList.contains((Object)CoverageLevel.A)) {
                coverSheetHeadersList.add("MCDC");
            }
            if (levelsInList.contains((Object)CoverageLevel.B)) {
                coverSheetHeadersList.add("Branch");
            }
            if (levelsInList.contains((Object)CoverageLevel.C)) {
                coverSheetHeadersList.add("Statement");
            }
            Object[] coverSheetHeaders = coverSheetHeadersList.toArray();
            sheetWriter.writeRow(coverSheetHeaders);
            Object[] row = new String[CoverageLevel.values().length + 1];
            row[0] = "All Coverage Methods";
            int index = 1;
            for (CoverageLevel lvl : levelsInList) {
                row[index++] = this.getPercent(this.levelToCoveredTotalCount.get((Object)lvl).getValue(), this.levelToTotalCount.get((Object)lvl).getValue(), false);
            }
            sheetWriter.writeRow(row);
            Set<String> resolutionTypes = levelsInList.contains((Object)CoverageLevel.A) ? ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.A)).keySet() : (levelsInList.contains((Object)CoverageLevel.B) ? ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.B)).keySet() : ((Map)levelToResolutionTypesToCount.get((Object)CoverageLevel.C)).keySet());
            List<String> orderedResolutionTypes = this.organizeResolutions(resolutionTypes);
            for (String resolution : orderedResolutionTypes) {
                int index1 = 0;
                row[index1++] = resolutionsValueToText.containsKey(resolution) ? resolutionsValueToText.get(resolution) : resolution;
                for (Object lvl : levelsInList) {
                    row[index1++] = ((Map)levelToResolutionTypesToCount.get(lvl)).get(resolution) == null ? "ERROR" : this.getPercent(((WrapInt)((Map)levelToResolutionTypesToCount.get(lvl)).get(resolution)).getValue(), this.levelToTotalCount.get(lvl).getValue(), false);
                }
                sheetWriter.writeRow(row);
            }
            if (!this.defaultCases.isEmpty()) {
                HashMap<CoverageLevel, Integer> levelToMixed = new HashMap<CoverageLevel, Integer>();
                int index1 = 0;
                row[index1++] = "MIXED - Expanded Below";
                Iterator it = levelsInList.iterator();
                while (it.hasNext()) {
                    CoverageLevel coverageLevel = (CoverageLevel)((Object)it.next());
                    if (((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get("MIXED") == null) {
                        row[index1++] = "ERROR";
                        continue;
                    }
                    row[index1++] = String.valueOf(this.getPercent(((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get("MIXED")).getValue(), this.levelToTotalCount.get((Object)coverageLevel).getValue(), false)) + " - Expanded Below";
                    levelToMixed.put(coverageLevel, ((WrapInt)((Map)levelToResolutionTypesToCount.get((Object)coverageLevel)).get("MIXED")).getValue());
                }
                sheetWriter.writeRow(row);
                for (Map.Entry entry : this.defaultCases.entrySet()) {
                    int index2 = 0;
                    row[index2++] = entry.getKey();
                    Iterator it2 = levelsInList.iterator();
                    while (it.hasNext()) {
                        CoverageLevel lvl = (CoverageLevel)((Object)it2.next());
                        row[index2++] = this.getPercent((Integer)entry.getValue(), (Integer)levelToMixed.get((Object)lvl), false);
                    }
                    sheetWriter.writeRow(row);
                }
            }
            sheetWriter.endSheet();
            Object[] summarySheetHeaders = this.getHeadersSummarySheet();
            columns = summarySheetHeaders.length;
            sheetWriter.startSheet("Summary Sheet", columns);
            sheetWriter.writeRow(summarySheetHeaders);
            Object[] row2 = new String[columns];
            Set units = ((Map)leveltoUnitToCovered.get((Object)CoverageLevel.A)).keySet();
            if (units.isEmpty()) {
                units = ((Map)leveltoUnitToCovered.get((Object)CoverageLevel.C)).keySet();
            }
            index = 0;
            for (String string : units) {
                index = 0;
                row2[index++] = string;
                CoverageLevel[] coverageLevelArray3 = CoverageLevel.values();
                int lvl = coverageLevelArray3.length;
                int it2 = 0;
                while (it2 < lvl) {
                    CoverageLevel level = coverageLevelArray3[it2];
                    Map unitToCovered = (Map)leveltoUnitToCovered.get((Object)level);
                    if (!unitToCovered.isEmpty() && unitToCovered.containsKey(string)) {
                        Pair coveredOverTotal = (Pair)unitToCovered.get(string);
                        int covered = ((WrapInt)coveredOverTotal.getFirst()).getValue();
                        int total = ((WrapInt)coveredOverTotal.getSecond()).getValue();
                        row2[index++] = String.valueOf(covered);
                        row2[index++] = String.valueOf(total);
                        Double percent = (double)covered / (double)total * 100.0;
                        row2[index++] = String.format("%2.2f%%", percent);
                    } else {
                        row2[index++] = " ";
                        row2[index++] = " ";
                        row2[index++] = " ";
                    }
                    ++it2;
                }
                sheetWriter.writeRow(row2);
            }
            sheetWriter.endSheet();
            Object[] objectArray = new Object[]{"Unit", "Code Line", "Resolution Type", "Script Name", "Script Path", "Script Notes"};
            sheetWriter.startSheet("Test Script Sheet", objectArray.length);
            sheetWriter.writeRow(objectArray);
            for (DispoItem item : items) {
                List annotations = item.getAnnotationsList();
                for (DispoAnnotationData annotation : annotations) {
                    if (!annotation.getResolutionType().equals("Test_Script")) continue;
                    HashMap<String, String> testNameToPath = DispoUtil.splitTestScriptNameAndPath(Collections.singletonList(annotation));
                    sheetWriter.writeRow(new Object[]{item.getName(), annotation.getLocationRefs(), annotation.getResolutionType(), testNameToPath.keySet(), testNameToPath.values(), annotation.getResolution()});
                }
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private List<Integer> getDiscrepanciesAsInts(List<String> discrepancyLocations) {
        List<Integer> toReturn = new ArrayList<Integer>();
        for (String location : discrepancyLocations) {
            if (DispoUtil.isNumericLocations(location)) {
                toReturn.add(Integer.valueOf(location));
                continue;
            }
            toReturn = Collections.emptyList();
            break;
        }
        return toReturn;
    }

    private String getPercent(int complete, int total, boolean showZero) {
        if (total == 0 || complete == 0) {
            return this.getPercentString(0.0, complete, total, showZero);
        }
        Double percent = new Double(complete);
        percent = percent / (double)total;
        percent = percent * 100.0;
        return this.getPercentString(percent, complete, total, showZero);
    }

    private String getPercentString(double percent, int complete, int total, boolean showZero) {
        if (!showZero && percent == 0.0 && complete == 0) {
            return "0%";
        }
        if (percent == 100.0) {
            return String.format("100%% - %d / %d", complete, total);
        }
        if (percent == 0.0) {
            return String.format("0%% - %d / %d", complete, total);
        }
        return String.format("%2.2f%% - %d / %d", percent, complete, total);
    }

    private void writeRowAnnotation(ExcelXmlWriter sheetWriter, int columns, DispoItem item, DispoAnnotationData annotation, String setName, Map<CoverageLevel, Map<String, WrapInt>> levelToResolutionToCount, Map<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> levelToUnitsToCovered, Map<String, MCDCCoverageData> mcdcToCoverageData, Set<CoverageLevel> levelsInSet) throws IOException {
        Object[] row = new String[columns];
        int index = 0;
        row[index++] = this.getNameSpace(item, setName);
        String unit = this.getNormalizedName(item.getName());
        row[index++] = unit;
        row[index++] = item.getName().replaceAll(".*\\.", "");
        row[index++] = String.valueOf(item.getMethodNumber());
        row[index++] = String.valueOf(annotation.getLocationRefs());
        String resolutionType = annotation.getResolutionType();
        if (Strings.isValid((String)resolutionType)) {
            row[index++] = resolutionType;
            String rationale = annotation.getResolution();
            row[index++] = resolutionType.equalsIgnoreCase("Test_Script") || !Strings.isValid((String)rationale) ? "N/A" : rationale;
        } else {
            row[index++] = "Uncovered";
            row[index++] = "N/A";
        }
        sheetWriter.writeRow(row);
        this.calculateTotals(levelToResolutionToCount, levelToUnitsToCovered, unit, resolutionType, mcdcToCoverageData, annotation.getLocationRefs(), levelsInSet);
    }

    private void calculateTotals(Map<CoverageLevel, Map<String, WrapInt>> levelToResolutionToCount, Map<CoverageLevel, Map<String, Pair<WrapInt, WrapInt>>> levelToUnitsToCovered, String unit, String resolutionType, Map<String, MCDCCoverageData> mcdcToCoverageData, String location, Set<CoverageLevel> levelsInSet) {
        CoverageLevel thisAnnotationsLevel = this.getLevel(location);
        switch (thisAnnotationsLevel) {
            case A: {
                levelsInSet.add(CoverageLevel.A);
                String mcdcName = this.getNameFromLocation(location);
                boolean isTruePath = this.getPathFromLocation(location);
                int mcdcValue = isTruePath ? 2 : 1;
                MCDCCoverageData coverageData = mcdcToCoverageData.get(mcdcName);
                if (coverageData == null) {
                    coverageData = new MCDCCoverageData(mcdcValue);
                    mcdcToCoverageData.put(mcdcName, coverageData);
                } else {
                    coverageData.updateBitFlag(mcdcValue);
                }
                if (coverageData.isPairPresent()) {
                    this.levelToTotalCount.get((Object)thisAnnotationsLevel).inc();
                }
                this.uptickA(levelToResolutionToCount.get((Object)thisAnnotationsLevel), levelToUnitsToCovered.get((Object)thisAnnotationsLevel), this.levelToCoveredTotalCount.get((Object)thisAnnotationsLevel), unit, resolutionType, coverageData, mcdcName, isTruePath);
                break;
            }
            case B: {
                levelsInSet.add(CoverageLevel.B);
            }
            case C: {
                levelsInSet.add(CoverageLevel.C);
                this.levelToTotalCount.get((Object)thisAnnotationsLevel).inc();
                this.uptickBorC(levelToResolutionToCount.get((Object)thisAnnotationsLevel), levelToUnitsToCovered.get((Object)thisAnnotationsLevel), this.levelToCoveredTotalCount.get((Object)thisAnnotationsLevel), unit, resolutionType);
            }
        }
    }

    private String getNameFromLocation(String location) {
        return location.replaceAll("\\(.*", "").trim();
    }

    private boolean getPathFromLocation(String location) {
        String[] parts = location.split("\\.");
        String partWithValue = parts[2];
        return partWithValue.trim().equals("T");
    }

    private void uptickA(Map<String, WrapInt> resolutionTypeToCount, Map<String, Pair<WrapInt, WrapInt>> unitToCovered, WrapInt currentCoveredTotalCount, String unit, String resolutionType, MCDCCoverageData coverageData, String mcdcName, boolean isTruePath) {
        int mcdcValue = 0;
        if (Strings.isValid((String)resolutionType)) {
            coverageData.addResolutionType(resolutionType);
            mcdcValue = isTruePath ? 8 : 4;
        }
        coverageData.updateBitFlag(mcdcValue);
        if (coverageData.isPairCovered()) {
            WrapInt count;
            if (!this.isTypeAnalyze(resolutionType)) {
                currentCoveredTotalCount.inc();
            }
            if ((count = resolutionTypeToCount.get(coverageData.getCoveringResolutionType())) == null) {
                resolutionTypeToCount.put(resolutionType, new WrapInt(1));
            } else {
                count.inc();
            }
        }
        int amtToIncrementTotal = coverageData.isPairPresent() ? 1 : 0;
        int amtToIncrementCoveredTotal = coverageData.isPairCovered() ? 1 : 0;
        Pair<WrapInt, WrapInt> coveredOverTotal = unitToCovered.get(unit);
        if (coveredOverTotal == null) {
            Pair newCount = new Pair((Object)new WrapInt(amtToIncrementCoveredTotal), (Object)new WrapInt(amtToIncrementCoveredTotal));
            unitToCovered.put(unit, (Pair<WrapInt, WrapInt>)newCount);
        } else {
            ((WrapInt)coveredOverTotal.getFirst()).inc(amtToIncrementCoveredTotal);
            ((WrapInt)coveredOverTotal.getSecond()).inc(amtToIncrementTotal);
        }
    }

    private void uptickBorC(Map<String, WrapInt> resolutionTypeToCount, Map<String, Pair<WrapInt, WrapInt>> unitToCovered, WrapInt currentCoveredTotalCount, String unit, String resolutionType) {
        WrapInt count = resolutionTypeToCount.get(resolutionType);
        if (Strings.isValid((String)resolutionType)) {
            if (count == null) {
                resolutionTypeToCount.put(resolutionType, new WrapInt(1));
            } else {
                count.inc();
            }
        }
        Pair<WrapInt, WrapInt> coveredOverTotal = unitToCovered.get(unit);
        int thisUnitsCoveredCount = 0;
        if (Strings.isValid((String)resolutionType) && !this.isTypeAnalyze(resolutionType)) {
            thisUnitsCoveredCount = 1;
            currentCoveredTotalCount.inc();
        }
        if (coveredOverTotal == null) {
            Pair newCount = new Pair((Object)new WrapInt(thisUnitsCoveredCount), (Object)new WrapInt(1));
            unitToCovered.put(unit, (Pair<WrapInt, WrapInt>)newCount);
        } else {
            ((WrapInt)coveredOverTotal.getFirst()).inc(thisUnitsCoveredCount);
            ((WrapInt)coveredOverTotal.getSecond()).inc();
        }
    }

    private boolean isTypeAnalyze(String resolutionType) {
        return resolutionType.equals("Modify_Code") || resolutionType.equals("Modify_Test") || resolutionType.equals("Modify_Reqt") || resolutionType.equals("Modify_Tooling") || resolutionType.equals("Modify_Work_Product");
    }

    private CoverageLevel getLevel(String location) {
        if (location.matches("\\s*\\d+\\s*\\.\\s*\\d+.*?\\.\\s*(T|F)\\s*")) {
            return CoverageLevel.A;
        }
        if (location.matches("(.*?RESULT.*|\\s*\\d+\\s*\\.\\s*(T|F).*)")) {
            return CoverageLevel.B;
        }
        return CoverageLevel.C;
    }

    private String getNormalizedName(String fullName) {
        if (fullName.contains(".2.ada")) {
            return fullName.replaceAll("\\.2\\.ada.*", ".2.ada");
        }
        return fullName.replaceAll("\\.c.*", ".c");
    }

    private String getNameSpace(DispoItem item, String setName) {
        Pattern pattern = Pattern.compile(".*?(\\..*?){1,}\\.2\\.ada");
        Matcher matcher = pattern.matcher(item.getName());
        StringBuilder nameSpace = new StringBuilder(setName);
        if (matcher.find()) {
            String str = matcher.group();
            Pattern pattern2 = Pattern.compile(".*\\.");
            Matcher matcher2 = pattern2.matcher(str.replaceAll("\\.2.*", ""));
            if (matcher2.find()) {
                nameSpace.append(".");
                String toAdd = matcher2.group();
                nameSpace.append(toAdd.substring(0, toAdd.length() - 1));
            }
        }
        return nameSpace.toString();
    }

    private String prettifyAnnotations(List<DispoAnnotationData> annotations) {
        StringBuilder sb = new StringBuilder();
        for (DispoAnnotationData annotation : annotations) {
            sb.append(annotation.getLocationRefs());
            sb.append(":");
            sb.append(annotation.getResolution());
            sb.append("\n");
        }
        return sb.toString();
    }

    private List<String> organizeResolutions(Set<String> resolutionTypes) {
        String[] toRemove = new String[]{"Test Script", "MIXED"};
        ArrayList<String> tempResolutionTypes = new ArrayList<String>(resolutionTypes);
        String[] stringArray = toRemove;
        int n = toRemove.length;
        int n2 = 0;
        while (n2 < n) {
            String coverageMethod = stringArray[n2];
            if (tempResolutionTypes.contains(coverageMethod)) {
                tempResolutionTypes.remove(coverageMethod);
            }
            ++n2;
        }
        ArrayList<String> orderedResolutionTypes = new ArrayList<String>();
        String[] stringArray2 = this.coverageMethodList();
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String coverageMethod = stringArray2[n];
            if (tempResolutionTypes.contains(coverageMethod) || coverageMethod.isEmpty()) {
                orderedResolutionTypes.add(coverageMethod);
                tempResolutionTypes.remove(coverageMethod);
            }
            ++n;
        }
        for (String coverageMethod : tempResolutionTypes) {
            orderedResolutionTypes.add(coverageMethod);
        }
        return orderedResolutionTypes;
    }

    private String[] getHeadersDetailed() {
        String[] toReturn = new String[]{"Script Name", "Category", "Status", "Total Test Points", "Failures", "Failed Points", "Remaining Count", "Remaining Points", "Assignee", "Team", "Item Notes", "Needs Rerun", "Aborted", "Station", "Elapsed Time", "Creation Date", "Last Updated", "Version", "Dispositions"};
        return toReturn;
    }

    private String[] getHeadersCoverage() {
        String[] toReturn = new String[]{"Namespace", "Parent Coverage Unit", "Unit", "Method Number", "Execution Line Number", "Coverage Method", "Coverage Rationale"};
        return toReturn;
    }

    private String[] getHeadersSummarySheet() {
        String[] toReturn = new String[]{"Unit", "MCDC Pairs Covered", "MCDC Pairs Total", "MCDC Pairs % Coverage", "Branches Covered", "Branches Total", "Branches % Coverage", "Statement Lines Covered", "Statement Lines Total", "Statement Lines % Coverage"};
        return toReturn;
    }

    private String[] coverageMethodList() {
        String[] toReturn = new String[]{"Test_Script", "Defensive_Programming", "Exception_Handling", "Analysis", "Deactivated_IN_AIR_OR_ENG_ON", "Deactivated_EXT_ATE_PRESENT", "Deactivated_J4_Connector", "Deactivated_Compile_Time", "Defensive_Programming/Test_Script", "Exception_Handling/Test_Script", "Analysis/Test_Script", "Deactivated_EXT_ATE_PRESENT/Test_Script", "Deactivated_IN_AIR_OR_ENG_ON/Test_Script", "Deactivated_J4_Connector/Test_Script", "Deactivated_Compile_Time/Test_Script", "Modify_Reqt", "Modify_Code", "Modify_Test", "Modify_Tooling", "Modify_Work_Product"};
        return toReturn;
    }

    private static enum CoverageLevel {
        A,
        B,
        C;

    }

    private class MCDCCoverageData {
        private int bitFlag;
        private final Set<String> resolutionTypes;

        MCDCCoverageData(int initFlagValue) {
            this.bitFlag = initFlagValue;
            this.resolutionTypes = new HashSet<String>();
        }

        private void updateBitFlag(int value) {
            this.bitFlag += value;
        }

        private void addResolutionType(String resolutionType) {
            this.resolutionTypes.add(resolutionType);
        }

        private boolean isPairPresent() {
            return (this.bitFlag & 3) == 3;
        }

        private boolean isPairCovered() {
            return (this.bitFlag & 0xC) == 12;
        }

        private String getCoveringResolutionType() {
            block26: {
                String toReturn;
                block29: {
                    block27: {
                        if (this.resolutionTypes.size() == 1) {
                            return this.resolutionTypes.iterator().next();
                        }
                        if (this.resolutionTypes.size() != 2) break block26;
                        ArrayList<String> typesCopy = new ArrayList<String>(this.resolutionTypes);
                        if (!typesCopy.remove("Test_Script")) break block27;
                        switch ((String)typesCopy.get(0)) {
                            case "Defensive_Programming": {
                                toReturn = "Defensive_Programming/Test_Script";
                                break;
                            }
                            case "Exception_Handling": {
                                toReturn = "Exception_Handling/Test_Script";
                                break;
                            }
                            case "Analysis": {
                                toReturn = "Analysis/Test_Script";
                                break;
                            }
                            case "Deactivated_EXT_ATE_PRESENT": {
                                toReturn = "Deactivated_EXT_ATE_PRESENT/Test_Script";
                                break;
                            }
                            case "Deactivated_IN_AIR_OR_ENG_ON": {
                                toReturn = "Deactivated_IN_AIR_OR_ENG_ON/Test_Script";
                                break;
                            }
                            case "Deactivated_J4_Connector": {
                                toReturn = "Deactivated_J4_Connector/Test_Script";
                                break;
                            }
                            case "Deactivated_Compile_Time": {
                                toReturn = "Deactivated_Compile_Time/Test_Script";
                                break;
                            }
                            default: {
                                ExportSet.this.recordUnexpectedEvents(this.resolutionTypes);
                                toReturn = "MIXED";
                                break;
                            }
                        }
                        break block29;
                    }
                    ExportSet.this.recordUnexpectedEvents(this.resolutionTypes);
                    toReturn = "MIXED - No Test_Script";
                }
                return toReturn;
            }
            ExportSet.this.recordUnexpectedEvents(this.resolutionTypes);
            return "SHOULD NOT HAVE LANDED HERE";
        }
    }

    private class WrapInt {
        private int value;

        private WrapInt(int initValue) {
            this.value = initValue;
        }

        private void inc() {
            ++this.value;
        }

        private void inc(int incAmt) {
            this.value += incAmt;
        }

        private int getValue() {
            return this.value;
        }
    }
}

