/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.vcast;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class VCastLisFileParser {
    private static final Pattern sourceLinePattern = Pattern.compile("^[0-9]+ [0-9]+(.*?)$");
    private static final Pattern exceptionPattern = Pattern.compile("^\\s+EXCEPTION\\s*$");
    private static final Pattern endMethodPattern = Pattern.compile("^\\s*END\\s+(.*);\\s*$");
    private final File lisFile;
    private String fileText = null;
    private String[] lisFileLines;

    public VCastLisFileParser(File lisFile) {
        this.lisFile = lisFile;
    }

    public Pair<String, Boolean> getSourceCodeForLine(Integer method, Integer executionLine) {
        String startsWith = method + " " + executionLine + " ";
        boolean exceptionLine = false;
        String[] stringArray = this.lisFileLines;
        int n = this.lisFileLines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m;
            String line = stringArray[n2];
            if (line.startsWith(startsWith)) {
                m = sourceLinePattern.matcher(line);
                String lineCode = "";
                lineCode = m.find() ? m.group(1) : "Error parsing *.LIS file";
                return new Pair((Object)lineCode, (Object)exceptionLine);
            }
            m = exceptionPattern.matcher(line);
            if (m.find()) {
                exceptionLine = true;
            } else {
                m = endMethodPattern.matcher(line);
                if (m.find()) {
                    exceptionLine = false;
                }
            }
            ++n2;
        }
        return null;
    }

    public void loadFileText() throws IOException {
        this.fileText = Lib.fileToString((File)this.lisFile);
        this.lisFileLines = this.fileText.split("\n");
    }
}

