/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleDeinitResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;

public class SubmoduleDeinitCommand
extends GitCommand<Collection<SubmoduleDeinitResult>> {
    private final Collection<String> paths = new ArrayList<String>();
    private boolean force;

    public SubmoduleDeinitCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<SubmoduleDeinitResult> call() throws GitAPIException {
        this.checkCallable();
        try {
            if (this.paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (String path : this.paths) {
                if (this.submoduleExists(path)) continue;
                throw new NoSuchSubmoduleException(path);
            }
            ArrayList<SubmoduleDeinitResult> results = new ArrayList<SubmoduleDeinitResult>(this.paths.size());
            Object object = null;
            Object var3_5 = null;
            try {
                RevWalk revWalk = new RevWalk(this.repo);
                try {
                    try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                        generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                        StoredConfig config = this.repo.getConfig();
                        while (generator.next()) {
                            String path = generator.getPath();
                            String name = generator.getModuleName();
                            SubmoduleDeinitStatus status = this.checkDirty(revWalk, path);
                            switch (status) {
                                case SUCCESS: {
                                    this.deinit(path);
                                    break;
                                }
                                case ALREADY_DEINITIALIZED: {
                                    break;
                                }
                                case DIRTY: {
                                    if (!this.force) break;
                                    this.deinit(path);
                                    status = SubmoduleDeinitStatus.FORCED;
                                    break;
                                }
                                default: {
                                    throw new JGitInternalException(MessageFormat.format(JGitText.get().unexpectedSubmoduleStatus, new Object[]{status}));
                                }
                            }
                            config.unsetSection("submodule", name);
                            results.add(new SubmoduleDeinitResult(path, status));
                        }
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                    throw object;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            return results;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void deinit(String path) throws IOException {
        File dir = new File(this.repo.getWorkTree(), path);
        if (!dir.isDirectory()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().expectedDirectoryNotSubmodule, path));
        }
        File[] ls = dir.listFiles();
        if (ls != null) {
            int i = 0;
            while (i < ls.length) {
                FileUtils.delete(ls[i], 1);
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private SubmoduleDeinitStatus checkDirty(RevWalk revWalk, String path) throws GitAPIException, IOException {
        block27: {
            head = this.repo.exactRef("HEAD");
            if (head == null) {
                throw new NoHeadException(JGitText.get().invalidRepositoryStateNoHead);
            }
            headCommit = revWalk.parseCommit(head.getObjectId());
            tree = headCommit.getTree();
            var7_6 = null;
            var8_9 = null;
            try {
                w = SubmoduleWalk.forPath(this.repo, tree, path);
                try {
                    submoduleHead = w.getHead();
                    if (submoduleHead == null) {
                        return SubmoduleDeinitStatus.ALREADY_DEINITIALIZED;
                    }
                    if (submoduleHead.equals(w.getObjectId())) break block27;
                    return SubmoduleDeinitStatus.DIRTY;
                }
                catch (Throwable var7_7) {
                    throw var7_7;
                }
                finally {
                    if (w == null) ** continue;
                    w.close();
                }
            }
            catch (Throwable var8_10) {
                if (var7_6 == null) {
                    var7_6 = var8_10;
                } else if (var7_6 != var8_10) {
                    var7_6.addSuppressed(var8_10);
                }
                throw var7_6;
            }
        }
        var7_6 = null;
        var8_9 = null;
        try {
            w = SubmoduleWalk.forIndex(this.repo);
            try {
                if (!w.next()) {
                    return SubmoduleDeinitStatus.DIRTY;
                }
                if (!submoduleHead.equals(w.getObjectId())) {
                    return SubmoduleDeinitStatus.DIRTY;
                }
                submoduleRepo = w.getRepository();
                status = Git.wrap(submoduleRepo).status().call();
                v0 = status.isClean() ? SubmoduleDeinitStatus.SUCCESS : SubmoduleDeinitStatus.DIRTY;
                ** try [egrp 8[TRYBLOCK] [7 : 288->289)] { 
            }
lbl49:
            // 1 sources

            catch (Throwable var7_8) {
                throw var7_8;
            }
            finally {
                if (w == null) ** continue;
                w.close();
            }
lbl48:
            // 1 sources

            return v0;
        }
        catch (Throwable var8_11) {
            if (var7_6 == null) {
                var7_6 = var8_11;
            } else if (var7_6 != var8_11) {
                var7_6.addSuppressed(var8_11);
            }
            throw var7_6;
        }
    }

    private boolean submoduleExists(String path) throws IOException {
        PathFilter filter = PathFilter.create(path);
        Throwable throwable = null;
        Object var4_5 = null;
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            return w.setFilter(filter).next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SubmoduleDeinitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    public SubmoduleDeinitCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public static class NoSuchSubmoduleException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;

        public NoSuchSubmoduleException(String path) {
            super(MessageFormat.format(JGitText.get().noSuchSubmodule, path));
        }
    }

    public static enum SubmoduleDeinitStatus {
        ALREADY_DEINITIALIZED,
        SUCCESS,
        FORCED,
        DIRTY;

    }
}

