/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.admin.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.authentication.admin.AuthenticatedUser;
import org.eclipse.osee.authentication.admin.AuthenticationAdmin;
import org.eclipse.osee.authentication.admin.AuthenticationConfiguration;
import org.eclipse.osee.authentication.admin.AuthenticationConfigurationBuilder;
import org.eclipse.osee.authentication.admin.AuthenticationProvider;
import org.eclipse.osee.authentication.admin.AuthenticationRequest;
import org.eclipse.osee.authentication.admin.internal.AuthenticationUtil;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class AuthenticationAdminImpl
implements AuthenticationAdmin {
    private final Map<String, AuthenticationProvider> authenticationProviders = new ConcurrentHashMap<String, AuthenticationProvider>();
    private Log logger;
    private AuthenticationConfiguration config;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(Map<String, Object> properties) {
        this.logger.trace("Starting AuthenticationAdminImpl...", new Object[0]);
        this.update(properties);
    }

    public void stop() {
        this.logger.trace("Stopping AuthenticationAdminImpl...", new Object[0]);
        this.config = null;
    }

    public void update(Map<String, Object> properties) {
        this.logger.trace("Updating AuthenticationAdmin Config...", new Object[0]);
        this.config = AuthenticationConfigurationBuilder.newBuilder().properties(properties).build();
    }

    public void addAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        String providerId = authenticationProvider.getAuthenticationScheme();
        providerId = AuthenticationUtil.normalize(providerId);
        this.authenticationProviders.put(providerId, authenticationProvider);
    }

    public void removeAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        String providerId = authenticationProvider.getAuthenticationScheme();
        providerId = AuthenticationUtil.normalize(providerId);
        this.authenticationProviders.remove(providerId);
    }

    @Override
    public Iterable<String> getAvailableSchemes() {
        return AuthenticationUtil.unmodifiableSortedIterable(this.authenticationProviders.keySet());
    }

    @Override
    public Iterable<String> getAllowedSchemes() {
        return this.config.getAllowedSchemes();
    }

    @Override
    public String getDefaultScheme() {
        String toReturn = this.config.getDefaultScheme();
        if (!Strings.isValid((String)toReturn)) {
            Iterator<String> iterator = this.getAllowedSchemes().iterator();
            toReturn = iterator.hasNext() ? iterator.next() : "";
        }
        return toReturn;
    }

    private AuthenticationProvider getAuthenticator(String schemeType) {
        String toMatch = AuthenticationUtil.normalize(schemeType);
        return this.authenticationProviders.get(toMatch);
    }

    @Override
    public AuthenticatedUser authenticate(AuthenticationRequest authenticationRequest) {
        String schemeType = authenticationRequest.getScheme();
        if (!Strings.isValid((String)schemeType)) {
            schemeType = this.getDefaultScheme();
        }
        this.checkSchemeAllowed(schemeType);
        AuthenticationProvider provider = this.getAuthenticator(schemeType);
        AuthenticatedUser principal = provider.authenticate(authenticationRequest);
        Conditions.checkExpressionFailOnTrue((principal == null ? 1 : 0) != 0, (String)"Authentication Error - scheme [%s] returned null principal", (Object[])new Object[]{schemeType});
        return principal;
    }

    @Override
    public boolean isSchemeAllowed(String schemeType) {
        boolean isAllowed = false;
        if (Strings.isValid((String)schemeType)) {
            String toMatch = AuthenticationUtil.normalize(schemeType);
            for (String scheme : this.getAllowedSchemes()) {
                isAllowed = scheme.equals(toMatch);
                if (isAllowed) break;
            }
        }
        return isAllowed;
    }

    private void checkSchemeAllowed(String schemeType) {
        Conditions.checkExpressionFailOnTrue((!this.isSchemeAllowed(schemeType) ? 1 : 0) != 0, (String)"Authentication Error - scheme [%s] is not allowed. Schemes available %s.", (Object[])new Object[]{schemeType, this.getAllowedSchemes()});
    }
}

