/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.osgi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Compare;

public enum JdbcSvcCfgChangeType {
    NO_CHANGE,
    ALL_CHANGED,
    JDBC_PROPERTY,
    OTHER_CHANGE;


    public boolean isJdbcChange() {
        return JDBC_PROPERTY == this;
    }

    public boolean isAllDifferent() {
        return ALL_CHANGED == this;
    }

    public static JdbcSvcCfgChangeType getChangeType(Map<String, Object> original, Map<String, Object> other) {
        JdbcSvcCfgChangeType changeType = NO_CHANGE;
        if (original != null && other != null) {
            if (original.size() != other.size()) {
                changeType = ALL_CHANGED;
            } else if (Compare.isDifferent(original, other)) {
                changeType = Compare.isDifferent(JdbcSvcCfgChangeType.jdbcEntries(original), JdbcSvcCfgChangeType.jdbcEntries(other)) ? JDBC_PROPERTY : OTHER_CHANGE;
            }
        } else {
            changeType = original == null && other == null ? NO_CHANGE : ALL_CHANGED;
        }
        return changeType;
    }

    private static Map<String, Object> jdbcEntries(Map<String, Object> original) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : original.entrySet()) {
            if (!entry.getKey().startsWith("jdbc.")) continue;
            toReturn.put(entry.getKey(), entry.getValue());
        }
        return toReturn;
    }
}

