/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcPoolConfig;
import org.eclipse.osee.jdbc.internal.JdbcConnectionFactory;
import org.eclipse.osee.jdbc.internal.JdbcConnectionFactoryManager;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;

public class PooledDataSourceFetcher
implements Callable<DataSource> {
    private final JdbcConnectionFactoryManager manager;
    private final LazyObject<? extends PoolingDriver> poolingDriver;
    private final JdbcPoolConfig poolConfig;
    private final JdbcConnectionInfo dbInfo;

    public PooledDataSourceFetcher(JdbcConnectionFactoryManager manager, LazyObject<? extends PoolingDriver> poolingDriver, JdbcPoolConfig poolConfig, JdbcConnectionInfo dbInfo) {
        this.manager = manager;
        this.poolConfig = poolConfig;
        this.poolingDriver = poolingDriver;
        this.dbInfo = dbInfo;
    }

    @Override
    public DataSource call() throws Exception {
        String driverClazz = this.poolConfig.getPoolConnectionDriver();
        try {
            Class.forName(driverClazz);
        }
        catch (Exception ex) {
            throw JdbcException.newJdbcException(ex, "Error loading connection pool driver [%s]", driverClazz);
        }
        String poolId = this.dbInfo.getId();
        ObjectPool<Connection> connectionPool = this.createConnectionPool();
        PoolingDriver driver = (PoolingDriver)this.poolingDriver.get();
        driver.registerPool(poolId, connectionPool);
        return new PoolingDataSource(connectionPool);
    }

    private ObjectPool<Connection> createConnectionPool() throws Exception {
        JdbcConnectionFactoryManager.MetaData metadata = this.manager.getMetaData(this.dbInfo);
        JdbcConnectionFactory proxiedFactory = this.manager.getFactory(this.dbInfo.getDriver());
        ConnectionFactoryProxy connectionFactory = new ConnectionFactoryProxy(proxiedFactory, this.dbInfo, metadata.isTxIsolationLevelSupported());
        AbandonedObjectPool connectionPool = new AbandonedObjectPool(null, this.getAbandonedConnectionConfig(this.poolConfig));
        connectionPool.setConfig(this.getPoolConfig(this.poolConfig));
        GenericKeyedObjectPoolFactory statementPool = null;
        if (this.poolConfig.isPoolPreparedStatementsAllowed()) {
            statementPool = new GenericKeyedObjectPoolFactory(null, this.getStatementPoolConfig(this.poolConfig));
        }
        AbandonedConfig abandoned = new AbandonedConfig();
        abandoned.setLogAbandoned(true);
        abandoned.setLogWriter(new PrintWriter(System.out));
        String validationQuery = metadata.getValidationQuery();
        int validationQueryTimeoutSecs = this.poolConfig.getPoolValidationQueryTimeoutSecs();
        boolean defaultReadOnly = false;
        boolean defaultAutoCommit = true;
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, (KeyedObjectPoolFactory)statementPool, validationQuery, validationQueryTimeoutSecs, defaultReadOnly, defaultAutoCommit);
        return connectionPool;
    }

    private GenericObjectPool.Config getPoolConfig(JdbcPoolConfig config) {
        GenericObjectPool.Config toReturn = new GenericObjectPool.Config();
        toReturn.maxActive = config.getPoolMaxActiveConnections();
        toReturn.maxIdle = config.getPoolMaxIdleConnections();
        toReturn.minIdle = config.getPoolMinIdleConnections();
        toReturn.maxWait = config.getPoolMaxWaitForConnection();
        toReturn.whenExhaustedAction = config.getPoolExhaustedAction().asByteValue();
        toReturn.testOnBorrow = config.isPoolTestOnBorrowEnabled();
        toReturn.testOnReturn = config.isPoolTestOnReturnEnabled();
        toReturn.testWhileIdle = config.isPoolTestWhileIdeEnabled();
        toReturn.timeBetweenEvictionRunsMillis = config.getPoolTimeBetweenEvictionCheckMillis();
        toReturn.numTestsPerEvictionRun = config.getPoolNumberTestsPerEvictionRun();
        toReturn.minEvictableIdleTimeMillis = config.getPoolMinEvictableIdleTimeMillis();
        toReturn.lifo = config.isPoolLifo();
        toReturn.softMinEvictableIdleTimeMillis = config.getPoolSoftMinEvictableTimeoutMillis();
        return toReturn;
    }

    private GenericKeyedObjectPool.Config getStatementPoolConfig(JdbcPoolConfig config) {
        GenericKeyedObjectPool.Config toReturn = new GenericKeyedObjectPool.Config();
        toReturn.maxTotal = config.getPoolMaxTotalPreparedStatements();
        toReturn.maxActive = config.getPoolMaxActivePreparedStatements();
        toReturn.maxIdle = config.getPoolMaxIdlePreparedStatements();
        toReturn.minIdle = config.getPoolMinIdlePreparedStatements();
        toReturn.maxWait = config.getPoolMaxWaitPreparedStatements();
        toReturn.whenExhaustedAction = config.getPoolExhaustedAction().asByteValue();
        toReturn.testOnBorrow = config.isPoolTestOnBorrowEnabled();
        toReturn.testOnReturn = config.isPoolTestOnReturnEnabled();
        toReturn.testWhileIdle = config.isPoolTestWhileIdeEnabled();
        toReturn.timeBetweenEvictionRunsMillis = config.getPoolTimeBetweenEvictionCheckMillis();
        toReturn.numTestsPerEvictionRun = config.getPoolNumberTestsPerEvictionRun();
        toReturn.minEvictableIdleTimeMillis = config.getPoolMinEvictableIdleTimeMillis();
        toReturn.lifo = config.isPoolLifo();
        return toReturn;
    }

    private AbandonedConfig getAbandonedConnectionConfig(JdbcPoolConfig config) {
        AbandonedConfig abandoned = new AbandonedConfig();
        abandoned.setLogAbandoned(config.isPoolAbandonedLoggingEnabled());
        abandoned.setRemoveAbandoned(config.isPoolAbandonedRemovalEnabled());
        abandoned.setRemoveAbandonedTimeout(config.getPoolAbandonedRemovalTimeout());
        return abandoned;
    }

    private static final class ConnectionFactoryProxy
    implements ConnectionFactory {
        private final JdbcConnectionFactory proxiedFactory;
        private final JdbcConnectionInfo dbInfo;
        private final boolean supportsIsolationLevel;

        public ConnectionFactoryProxy(JdbcConnectionFactory proxiedFactory, JdbcConnectionInfo dbInfo, boolean supportsIsolationLevel) {
            this.proxiedFactory = proxiedFactory;
            this.dbInfo = dbInfo;
            this.supportsIsolationLevel = supportsIsolationLevel;
        }

        public Connection createConnection() throws SQLException {
            Connection connection = null;
            try {
                connection = this.proxiedFactory.getConnection(this.dbInfo);
                if (this.supportsIsolationLevel) {
                    connection.setTransactionIsolation(2);
                }
            }
            catch (Exception ex) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException(ex);
            }
            return connection;
        }
    }
}

