/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.sql.JDBCType;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.enums.SqlColumn;
import org.eclipse.osee.framework.core.enums.SqlTable;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcDbType;

public final class DatabaseCreation {
    private final JdbcClient jdbcClient;

    public DatabaseCreation(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    private void dropConstraint(SqlTable table, String constraint) {
        try {
            this.jdbcClient.runPreparedUpdate("ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + constraint, new Object[0]);
        }
        catch (Exception ex) {
            OseeLog.log(this.getClass(), (Level)Level.INFO, (Throwable)ex);
        }
    }

    public void createDataStore() {
        this.dropTables();
        this.createTable(SqlTable.ARTIFACT_TABLE);
        this.createTable(SqlTable.ATTRIBUTE_TABLE);
        this.createTable(SqlTable.RELATION_TABLE);
        this.createTable(SqlTable.BRANCH_TABLE);
        this.createTable(SqlTable.TXS_TABLE);
        this.createTable(SqlTable.TXS_ARCHIVED_TABLE);
        this.createTable(SqlTable.TX_DETAILS_TABLE);
        this.alterForeignKeyConstraint("PARENT_TX_ID_FK1", SqlTable.BRANCH_TABLE, SqlTable.BRANCH_PARENT_TRANSACTION_ID, SqlTable.TX_DETAILS_TABLE, SqlTable.TX_DETAILS_TRANSACTION_ID, "");
        this.deferredForeignKeyConstraint("BASELINE_TX_ID_FK1", SqlTable.BRANCH_TABLE, SqlTable.BRANCH_BASELINE_TRANSACTION_ID, SqlTable.TX_DETAILS_TABLE, SqlTable.TX_DETAILS_TRANSACTION_ID);
        this.createTable(SqlTable.OSEE_PERMISSION_TABLE);
        this.createTable(SqlTable.OSEE_ARTIFACT_ACL_TABLE);
        this.createTable(SqlTable.OSEE_BRANCH_ACL_TABLE);
        this.createTable(SqlTable.OSEE_SEARCH_TAGS_TABLE);
        this.createTable(SqlTable.OSEE_TAG_GAMMA_QUEUE_TABLE);
        this.createTable(SqlTable.OSEE_SEQUENCE_TABLE);
        this.createTable(SqlTable.OSEE_INFO_TABLE);
        this.createTable(SqlTable.OSEE_MERGE_TABLE);
        this.createTable(SqlTable.OSEE_CONFLICT_TABLE);
        this.createTable(SqlTable.OSEE_JOIN_EXPORT_IMPORT_TABLE);
        this.createTable(SqlTable.OSEE_IMPORT_SOURCE_TABLE);
        this.createTable(SqlTable.OSEE_IMPORT_SAVE_POINT_TABLE);
        this.createTable(SqlTable.OSEE_IMPORT_MAP_TABLE);
        this.createTable(SqlTable.OSEE_IMPORT_INDEX_MAP_TABLE);
        this.createTable(SqlTable.OSEE_JOIN_ARTIFACT_TABLE);
        this.createTable(SqlTable.OSEE_JOIN_ID_TABLE);
        this.createTable(SqlTable.OSEE_JOIN_CLEANUP_TABLE);
        this.createTable(SqlTable.OSEE_JOIN_CHAR_ID_TABLE);
        this.createTable(SqlTable.OSEE_JOIN_TRANSACTION_TABLE);
        this.createTable(SqlTable.OSEE_BRANCH_GROUP_TABLE);
        this.createTable(SqlTable.LDAP_DETAILS_TABLE);
        this.createTable(SqlTable.TUPLE2);
        this.createTable(SqlTable.TUPLE3);
        this.createTable(SqlTable.TUPLE4);
        this.createTable(SqlTable.OSEE_KEY_VALUE_TABLE);
        this.createTable(SqlTable.OSEE_JOIN_ID4_TABLE);
        this.createTable(SqlTable.OSEE_SERVER_LOOKUP_TABLE);
        this.createTable(SqlTable.OSEE_SESSION_TABLE);
        this.createTable(SqlTable.OSEE_ACTIVITY_TYPE_TABLE);
        this.createTable(SqlTable.OSEE_ACTIVITY_TABLE);
        this.createTable(SqlTable.OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE);
        this.createTable(SqlTable.OSEE_OAUTH_AUTHORIZATION_TABLE);
        this.createTable(SqlTable.OSEE_OAUTH_TOKEN_TABLE);
    }

    private void dropTable(SqlTable table) {
        try {
            this.jdbcClient.runPreparedUpdate("DROP TABLE " + table.getName(), new Object[0]);
        }
        catch (Exception ex) {
            OseeLog.log(this.getClass(), (Level)Level.INFO, (Throwable)ex);
        }
    }

    private void dropTables() {
        this.dropConstraint(SqlTable.TX_DETAILS_TABLE, "BRANCH_ID_FK1");
        this.dropConstraint(SqlTable.OSEE_ARTIFACT_ACL_TABLE, "ARTIFACT_ACL_PERM_FK");
        this.dropConstraint(SqlTable.OSEE_BRANCH_ACL_TABLE, "BRANCH_ACL_PERM_FK");
        this.dropConstraint(SqlTable.OSEE_PERMISSION_TABLE, String.valueOf(SqlTable.OSEE_PERMISSION_TABLE.getName()) + "_PK");
        this.dropConstraint(SqlTable.OSEE_MERGE_TABLE, "OSEE_MERGE__MBI_FK");
        this.dropConstraint(SqlTable.OSEE_MERGE_TABLE, "OSEE_MERGE__DBI_FK");
        this.dropConstraint(SqlTable.OSEE_BRANCH_ACL_TABLE, "BRANCH_ACL_FK");
        this.dropConstraint(SqlTable.BRANCH_TABLE, String.valueOf(SqlTable.BRANCH_TABLE.getName()) + "_PK");
        this.dropConstraint(SqlTable.TUPLE2, String.valueOf(SqlTable.TUPLE2.getName()) + "_PK");
        this.dropConstraint(SqlTable.OSEE_IMPORT_SAVE_POINT_TABLE, "OSEE_IMP_SAVE_POINT_II_FK");
        this.dropConstraint(SqlTable.OSEE_IMPORT_MAP_TABLE, "OSEE_IMPORT_MAP_II_FK");
        this.dropConstraint(SqlTable.OSEE_IMPORT_INDEX_MAP_TABLE, "OSEE_IMPORT_INDEX_MAP_II_FK");
        this.dropConstraint(SqlTable.OSEE_OAUTH_AUTHORIZATION_TABLE, "OSEE_OAUTH_AUTH__CI_FK");
        this.dropConstraint(SqlTable.OSEE_OAUTH_TOKEN_TABLE, "OSEE_OAUTH_TOKEN__CI_FK");
        this.dropTable(SqlTable.OSEE_ARTIFACT_ACL_TABLE);
        this.dropTable(SqlTable.OSEE_BRANCH_ACL_TABLE);
        this.dropTable(SqlTable.OSEE_CONFLICT_TABLE);
        this.dropTable(SqlTable.OSEE_MERGE_TABLE);
        this.dropTable(SqlTable.ARTIFACT_TABLE);
        this.dropTable(SqlTable.ATTRIBUTE_TABLE);
        this.dropTable(SqlTable.RELATION_TABLE);
        this.dropTable(SqlTable.BRANCH_TABLE);
        this.dropTable(SqlTable.TXS_TABLE);
        this.dropTable(SqlTable.TXS_ARCHIVED_TABLE);
        this.dropTable(SqlTable.TX_DETAILS_TABLE);
        this.dropTable(SqlTable.OSEE_PERMISSION_TABLE);
        this.dropTable(SqlTable.OSEE_SEARCH_TAGS_TABLE);
        this.dropTable(SqlTable.OSEE_TAG_GAMMA_QUEUE_TABLE);
        this.dropTable(SqlTable.OSEE_SEQUENCE_TABLE);
        this.dropTable(SqlTable.OSEE_INFO_TABLE);
        this.dropTable(SqlTable.OSEE_JOIN_EXPORT_IMPORT_TABLE);
        this.dropTable(SqlTable.OSEE_IMPORT_SOURCE_TABLE);
        this.dropTable(SqlTable.OSEE_IMPORT_SAVE_POINT_TABLE);
        this.dropTable(SqlTable.OSEE_IMPORT_MAP_TABLE);
        this.dropTable(SqlTable.OSEE_IMPORT_INDEX_MAP_TABLE);
        this.dropTable(SqlTable.OSEE_JOIN_ARTIFACT_TABLE);
        this.dropTable(SqlTable.OSEE_JOIN_ID_TABLE);
        this.dropTable(SqlTable.OSEE_JOIN_CLEANUP_TABLE);
        this.dropTable(SqlTable.OSEE_JOIN_CHAR_ID_TABLE);
        this.dropTable(SqlTable.OSEE_JOIN_TRANSACTION_TABLE);
        this.dropTable(SqlTable.OSEE_BRANCH_GROUP_TABLE);
        this.dropTable(SqlTable.LDAP_DETAILS_TABLE);
        this.dropTable(SqlTable.TUPLE2);
        this.dropTable(SqlTable.TUPLE3);
        this.dropTable(SqlTable.TUPLE4);
        this.dropTable(SqlTable.OSEE_KEY_VALUE_TABLE);
        this.dropTable(SqlTable.OSEE_JOIN_ID4_TABLE);
        this.dropTable(SqlTable.OSEE_SERVER_LOOKUP_TABLE);
        this.dropTable(SqlTable.OSEE_SESSION_TABLE);
        this.dropTable(SqlTable.OSEE_ACTIVITY_TYPE_TABLE);
        this.dropTable(SqlTable.OSEE_ACTIVITY_TABLE);
        this.dropTable(SqlTable.OSEE_OAUTH_CLIENT_CREDENTIAL_TABLE);
        this.dropTable(SqlTable.OSEE_OAUTH_AUTHORIZATION_TABLE);
        this.dropTable(SqlTable.OSEE_OAUTH_TOKEN_TABLE);
    }

    public String columnToSql(SqlColumn column) {
        StringBuilder strB = new StringBuilder(50);
        strB.append(column.getName());
        strB.append(" ");
        if (column.getType() == JDBCType.INTEGER) {
            strB.append("INT");
        } else if (column.getType() == JDBCType.BIGINT) {
            if (this.jdbcClient.getDbType().equals((Object)JdbcDbType.oracle)) {
                strB.append("NUMBER (19, 0)");
            } else {
                strB.append("BIGINT");
            }
        } else if (this.jdbcClient.getDbType().equals((Object)JdbcDbType.postgresql)) {
            if (column.getType() == JDBCType.BLOB) {
                strB.append("bytea");
            } else if (column.getType() == JDBCType.CLOB) {
                strB.append("text");
            } else {
                strB.append(column.getType());
            }
        } else {
            strB.append(column.getType());
        }
        if (column.getLength() > 0) {
            strB.append(" (");
            strB.append(column.getLength());
            strB.append(")");
        }
        if (column.getName().equals("BUILD_ID")) {
            strB.append(" DEFAULT 0");
        } else if (!column.isNull()) {
            strB.append(" NOT NULL");
        }
        return strB.toString();
    }

    public void createTable(SqlTable table) {
        StringBuilder sql = new StringBuilder(200);
        sql.append("CREATE TABLE ");
        sql.append(table.getName());
        sql.append(" (\n\t");
        int i = 0;
        while (i < table.getColumns().size()) {
            sql.append(this.columnToSql((SqlColumn)table.getColumns().get(i)));
            if (i != table.getColumns().size() - 1 || !table.getConstraints().isEmpty()) {
                sql.append(",\n\t");
            }
            ++i;
        }
        sql.append(Collections.toString((String)",\n\t", (Iterable)table.getConstraints()));
        sql.append("\n)");
        JdbcDbType dbType = this.jdbcClient.getDbType();
        if (dbType.equals((Object)JdbcDbType.oracle)) {
            if (table.getIndexLevel() != -1) {
                sql.append("\tORGANIZATION INDEX ");
                if (table.getIndexLevel() > 0) {
                    sql.append("COMPRESS " + table.getIndexLevel());
                }
            }
            if (table.getTableExtras() != null) {
                sql.append("\n\t" + table.getTableExtras());
            }
        }
        this.jdbcClient.runPreparedUpdate(sql.toString(), new Object[0]);
        for (String statement : table.getStatements()) {
            if (statement.contains("CREATE INDEX") && dbType.equals((Object)JdbcDbType.oracle)) {
                statement = String.valueOf(statement) + " TABLESPACE osee_index";
            }
            this.jdbcClient.runPreparedUpdate(statement, new Object[0]);
        }
    }

    private void deferredForeignKeyConstraint(String constraintName, SqlTable table, SqlColumn column, SqlTable refTable, SqlColumn refColumn) {
        String defered = this.jdbcClient.getDbType().matches(new Id[]{JdbcDbType.oracle, JdbcDbType.postgresql}) ? " DEFERRABLE INITIALLY DEFERRED" : "";
        this.alterForeignKeyConstraint(constraintName, table, column, refTable, refColumn, defered);
    }

    private void alterForeignKeyConstraint(String constraintName, SqlTable table, SqlColumn column, SqlTable refTable, SqlColumn refColumn, String defered) {
        String statement = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY(%s) REFERENCES %s(%s)%s", table, constraintName, column, refTable, refColumn, defered);
        this.jdbcClient.runPreparedUpdate(statement, new Object[0]);
    }
}

