/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.transport.http.HTTPConduit;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.CxfJaxRsClientConfigurator;
import org.eclipse.osee.jaxrs.JaxRsClientConfig;
import org.eclipse.osee.jaxrs.OAuth2ClientRequestFilter;
import org.eclipse.osee.jaxrs.OAuth2Flows;
import org.eclipse.osee.jaxrs.OAuth2Serializer;
import org.eclipse.osee.jaxrs.OAuth2Transport;

public final class JaxRsApiImpl
implements JaxRsApi {
    private OrcsTokenService tokenService;
    private ObjectMapper mapper;
    private TypeFactory typeFactory;
    private String baseUrl;
    private javax.ws.rs.client.Client client;
    private CxfJaxRsClientConfigurator configurator;
    private JaxRsClientConfig config;
    private static final long MAX_TOKEN_CACHE_EVICT_TIMEOUT_MILLIS = 86400000L;

    public void setOrcsTokenService(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void start() {
        SimpleModule module = JsonUtil.createModule();
        JsonUtil.addDeserializer((SimpleModule)module, AttributeTypeGeneric.class, arg_0 -> ((OrcsTokenService)this.tokenService).getAttributeType(arg_0));
        JsonUtil.addDeserializer((SimpleModule)module, AttributeTypeToken.class, arg_0 -> ((OrcsTokenService)this.tokenService).getAttributeType(arg_0));
        JsonUtil.addDeserializer((SimpleModule)module, AttributeTypeId.class, arg_0 -> ((OrcsTokenService)this.tokenService).getAttributeType(arg_0));
        JsonUtil.addDeserializer((SimpleModule)module, ArtifactTypeToken.class, arg_0 -> ((OrcsTokenService)this.tokenService).getArtifactType(arg_0));
        JsonUtil.addDeserializer((SimpleModule)module, ArtifactTypeId.class, arg_0 -> ((OrcsTokenService)this.tokenService).getArtifactType(arg_0));
        JsonUtil.addDeserializer((SimpleModule)module, RelationTypeToken.class, arg_0 -> ((OrcsTokenService)this.tokenService).getRelationType(arg_0));
        this.mapper = JsonUtil.createStandardDateObjectMapper((Module)module);
        this.typeFactory = this.mapper.getTypeFactory();
        this.createClientFactory(this.mapper, this.tokenService);
        this.baseUrl = System.getProperty("osee.application.server", "http://localhost:8089");
    }

    public JsonNode readTree(String json) {
        try {
            return this.mapper.readTree(json);
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public String toJson(Object object) {
        return JsonUtil.toJson((ObjectMapper)this.mapper, (Object)object);
    }

    public <T> T readValue(String json, Class<T> valueType) {
        return (T)JsonUtil.readValue((ObjectMapper)this.mapper, (String)json, valueType);
    }

    public String readValue(String json, String key) {
        return this.readTree(json).get(key).toString();
    }

    public <T, C extends Collection<T>> C readCollectionValue(String json, Class<? extends Collection> collectionClass, Class<T> elementClass) {
        try {
            return (C)((Collection)this.mapper.readValue(json, (JavaType)this.typeFactory.constructCollectionType(collectionClass, elementClass)));
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public <K, V> Map<K, V> readMapValue(String json, Class<K> keyClass, Class<V> valueClass) {
        try {
            return (Map)this.mapper.readValue(json, (JavaType)this.typeFactory.constructMapType(Map.class, keyClass, valueClass));
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public WebTarget newTarget(String path) {
        return this.newWebTarget(this.config, this.url(path));
    }

    public WebTarget newTargetUrl(String url) {
        return this.newWebTarget(this.config, url);
    }

    public WebTarget newTargetNoRedirect(String path) {
        JaxRsClientConfig modifiedConfig = this.config.copy();
        modifiedConfig.setFollowRedirects(false);
        return this.newWebTarget(modifiedConfig, this.url(path));
    }

    public WebTarget newTarget(String ... pathSegments) {
        return this.newWebTarget(this.config, Collections.toString((String[])pathSegments, (String)(String.valueOf(this.baseUrl) + "/"), (String)"/", null));
    }

    public WebTarget newTargetQuery(String path, String ... queryParams) {
        return this.newTargetUrlQuery(this.url(path), queryParams);
    }

    public WebTarget newTargetUrlQuery(String url, String ... queryParams) {
        StringBuilder strB = new StringBuilder(url);
        strB.append("?");
        boolean first = true;
        int x = 0;
        while (x < queryParams.length) {
            if (first) {
                first = false;
            } else {
                strB.append("&");
            }
            strB.append(queryParams[x]);
            strB.append("=");
            strB.append(queryParams[x + 1]);
            x += 2;
        }
        return this.newTargetUrl(strB.toString());
    }

    public WebTarget newTargetUrlPasswd(String url, String serverUsername, String serverPassword) {
        JaxRsClientConfig modifiedConfig = this.config.copy();
        modifiedConfig.setServerPassword(serverPassword);
        modifiedConfig.setServerUsername(serverUsername);
        return this.newWebTarget(modifiedConfig, url);
    }

    public WebTarget newTargetPasswd(String path, String serverUsername, String serverPassword) {
        return this.newTargetUrlPasswd(this.url(path), serverUsername, serverPassword);
    }

    public WebTarget newWebTarget(JaxRsClientConfig config, String url) {
        url = url.replaceAll(" ", "%20");
        WebTarget target = this.client.target(url);
        target.request();
        this.configureConnection(config, target);
        return target;
    }

    private void configureConnection(JaxRsClientConfig config, Object client) {
        ClientConfiguration clientConfig = WebClient.getConfig((Object)client);
        HTTPConduit conduit = clientConfig.getHttpConduit();
        this.configurator.configureConnection(config, conduit);
        this.configurator.configureProxy(config, conduit);
    }

    private String url(String path) {
        return String.valueOf(this.baseUrl) + "/" + path;
    }

    public <T> T newProxy(WebTarget target, Class<T> clazz) {
        target.request();
        if (target instanceof ClientImpl.WebTargetImpl) {
            return (T)JAXRSClientFactory.fromClient((Client)((ClientImpl.WebTargetImpl)target).getWebClient(), clazz);
        }
        throw new OseeStateException("%s is of type %s not WebTargetImpl", new Object[]{target, target.getClass()});
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public <T> T newProxy(String path, Class<T> clazz) {
        return this.newProxy(this.config, this.url(path), clazz);
    }

    public JsonFactory getFactory() {
        return this.mapper.getFactory();
    }

    private <T> T newProxy(JaxRsClientConfig config, String url, Class<T> clazz) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        this.configurator.configureBean(config, url, bean);
        bean.setServiceClass(clazz);
        Object client = bean.create(clazz, new Object[0]);
        this.configureConnection(config, client);
        return (T)client;
    }

    private void createClientFactory(ObjectMapper mapper, OrcsTokenService tokenService) {
        CxfJaxRsClientConfigurator.OAuthFactory oauthFactory = this.newOAuthFactory();
        this.configurator = new CxfJaxRsClientConfigurator(oauthFactory, tokenService);
        this.configurator.configureJaxRsRuntime();
        this.configurator.configureDefaults(mapper);
        this.config = new JaxRsClientConfig();
        this.config.setCreateThreadSafeProxyClients(true);
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.configurator.configureClientBuilder(this.config, builder);
        this.client = builder.build();
    }

    private CxfJaxRsClientConfigurator.OAuthFactory newOAuthFactory() {
        return new CxfJaxRsClientConfigurator.OAuthFactory(){

            @Override
            public OAuth2ClientRequestFilter newOAuthClientFilter(String username, String password, String clientId, String clientSecret, String authorizeUri, String tokenUri, String tokenValidationUri) {
                OAuth2Flows.OwnerCredentials owner = JaxRsApiImpl.newOwner(username, password);
                Consumer client = new Consumer(clientId, clientSecret);
                OAuth2Transport transport = new OAuth2Transport(JaxRsApiImpl.this);
                OAuth2Flows flowManager = new OAuth2Flows(transport, owner, client, authorizeUri, tokenUri, tokenValidationUri);
                OAuth2Serializer serializer = new OAuth2Serializer();
                return new OAuth2ClientRequestFilter(flowManager, serializer);
            }

            @Override
            public OAuth2ClientRequestFilter.ClientAccessTokenCache newClientAccessTokenCache(int cacheMaxSize, long cacheEvictTimeoutMillis) {
                final Cache cache = JaxRsApiImpl.newCache(cacheMaxSize, cacheEvictTimeoutMillis);
                return new OAuth2ClientRequestFilter.ClientAccessTokenCache(){

                    @Override
                    public ClientAccessToken get(URI key) {
                        return (ClientAccessToken)cache.getIfPresent((Object)key);
                    }

                    @Override
                    public void store(URI key, ClientAccessToken value) {
                        cache.put((Object)key, (Object)value);
                    }
                };
            }
        };
    }

    private static <K, V> Cache<K, V> newCache(int cacheMaxSize, long cacheEvictTimeoutMillis) {
        Conditions.checkExpressionFailOnTrue((cacheMaxSize <= 0 ? 1 : 0) != 0, (String)"Token Cache max size must be greater than 0", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((cacheEvictTimeoutMillis > 86400000L ? 1 : 0) != 0, (String)"Token cache evict timeout exceeds max - [%s]", (Object[])new Object[]{Lib.asTimeString((long)86400000L)});
        Conditions.checkExpressionFailOnTrue((cacheEvictTimeoutMillis <= 0L ? 1 : 0) != 0, (String)"Token cache evict timeout must be greater than 0", (Object[])new Object[0]);
        return CacheBuilder.newBuilder().maximumSize((long)cacheMaxSize).expireAfterWrite(cacheEvictTimeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    private static OAuth2Flows.OwnerCredentials newOwner(final String username, final String password) {
        return new OAuth2Flows.OwnerCredentials(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public String getPassword() {
                return password;
            }
        };
    }
}

