/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.indexer.collector;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osee.orcs.search.IndexerCollectorAdapter;

public class TagCollectorImpl
extends IndexerCollectorAdapter {
    private volatile Map<Integer, Throwable> tagErrors;
    private volatile Set<Integer> queryIds;
    private volatile boolean wasProcessed = false;
    private volatile int expectedTotal;
    private final AtomicInteger queryCount = new AtomicInteger();
    private final AtomicInteger attributeCount = new AtomicInteger();

    public TagCollectorImpl() {
        this.queryIds = Collections.synchronizedSet(new HashSet());
        this.queryCount.set(0);
        this.attributeCount.set(0);
        this.tagErrors = Collections.synchronizedMap(new HashMap());
    }

    public boolean wasProcessed() {
        return this.wasProcessed;
    }

    public boolean hasErrors() {
        return this.tagErrors.size() > 0;
    }

    public int getAttributeCount() {
        return this.attributeCount.get();
    }

    public int getQueryCount() {
        return this.queryCount.get();
    }

    public Map<Integer, Throwable> getTagErrors() {
        return this.tagErrors;
    }

    public void onIndexTaskTotalToProcess(int totalQueries) {
        this.expectedTotal = totalQueries;
    }

    public synchronized void onIndexTaskError(int queryId, Throwable throwable) {
        this.tagErrors.put(queryId, throwable);
        this.wasProcessed = true;
        ((Object)((Object)this)).notify();
    }

    public synchronized void onIndexTaskSubmit(int queryId) {
        this.queryCount.incrementAndGet();
        this.queryIds.add(queryId);
    }

    public void onIndexItemComplete(int queryId, long gammaId, int totalTags, long processingTime) {
        if (this.queryIds.contains(queryId)) {
            this.attributeCount.incrementAndGet();
        }
    }

    public synchronized void onIndexTaskComplete(int queryId, long waitTime, long processingTime) {
        if (this.queryIds.contains(queryId)) {
            this.queryIds.remove(queryId);
            if (this.queryIds.isEmpty() && this.queryCount.get() == this.expectedTotal) {
                this.wasProcessed = true;
                ((Object)((Object)this)).notify();
            }
        }
    }
}

