/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class PurgeTransactionCommand
implements ConsoleCommand {
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getName() {
        return "purge_transaction";
    }

    public String getDescription() {
        return "Purges transactions from the datastore";
    }

    public String getUsage() {
        return "txIds=<TX_IDS,...>";
    }

    public Callable<?> createCallable(final Console console, final ConsoleParameters params) {
        final TransactionFactory txFactory = this.getOrcsApi().getTransactionFactory();
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object[] stringIds = params.getArray("txIds");
                ArrayList<TransactionId> transactions = new ArrayList<TransactionId>();
                Object[] objectArray = stringIds;
                int n = stringIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = objectArray[n2];
                    TransactionId tx = TransactionId.valueOf((String)arg);
                    transactions.add(tx);
                    ++n2;
                }
                console.writeln();
                console.writeln("Purging transactions: [%s]", new Object[]{Arrays.deepToString(stringIds)});
                return txFactory.purgeTransaction(transactions).call();
            }
        };
    }
}

