/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.artifact;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.DirtyState;
import org.eclipse.osee.framework.core.enums.EditState;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactVisitor;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManagerImpl;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderChange;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class ArtifactImpl
extends AttributeManagerImpl
implements Artifact {
    private EditState objectEditState;
    private ArtifactData artifactData;
    private GraphData graph;

    public ArtifactImpl(ArtifactData artifactData, AttributeFactory attributeFactory) {
        super(artifactData, attributeFactory);
        this.artifactData = artifactData;
        this.objectEditState = EditState.NO_CHANGE;
    }

    @Override
    public void setGraph(GraphData graph) {
        this.graph = graph;
    }

    @Override
    public GraphData getGraph() {
        return this.graph;
    }

    @Override
    public ArtifactData getOrcsData() {
        return this.artifactData;
    }

    @Override
    public void setOrcsData(ArtifactData data) {
        this.artifactData = data;
        this.objectEditState = EditState.NO_CHANGE;
    }

    public ModificationType getModificationType() {
        return this.getOrcsData().getModType();
    }

    @Override
    public Integer getLocalId() {
        return this.getId().intValue();
    }

    @Override
    public TransactionId getLastModifiedTransaction() {
        TransactionId maxTransactionId = this.getOrcsData().getVersion().getTransactionId();
        for (Attribute attribute : this.getAttributes(DeletionFlag.INCLUDE_DELETED)) {
            TransactionId tx = ((AttributeData)attribute.getOrcsData()).getVersion().getTransactionId();
            if (!maxTransactionId.isOlderThan(tx)) continue;
            maxTransactionId = tx;
        }
        return maxTransactionId;
    }

    public TransactionId getTransaction() {
        return this.graph.getTransaction();
    }

    public BranchToken getBranch() {
        return BranchToken.create((BranchId)this.artifactData.getVersion().getBranch(), (String)"unknown");
    }

    public ArtifactTypeToken getArtifactType() {
        return (ArtifactTypeToken)this.getOrcsData().getType();
    }

    @Override
    public void setName(String name) {
        this.setSoleAttributeFromString((AttributeTypeToken)CoreAttributeTypes.Name, name);
    }

    @Override
    public void setArtifactType(ArtifactTypeToken artifactType) {
        if (!this.isTypeEqual((ArtifactTypeId)artifactType)) {
            this.getOrcsData().setType(artifactType);
            this.objectEditState = EditState.ARTIFACT_TYPE_MODIFIED;
            if (this.getOrcsData().getVersion().isInStorage()) {
                this.getOrcsData().setModType(ModificationType.MODIFIED);
            }
        }
    }

    @Override
    public void setNotDirty() {
        this.setAttributesNotDirty();
        this.objectEditState = EditState.NO_CHANGE;
        this.getOrcsData().setModType(ModificationType.MODIFIED);
    }

    public boolean isDirty() {
        return this.areAttributesDirty() || this.hasDirtyArtifactType() || this.isReplaceWithVersion() || DirtyState.APPLICABILITY_ONLY == this.getOrcsData().getDirtyState();
    }

    private boolean isReplaceWithVersion() {
        return this.getModificationType() == ModificationType.REPLACED_WITH_VERSION || this.artifactData.isExistingVersionUsed();
    }

    private boolean hasDirtyArtifactType() {
        return this.objectEditState.isArtifactTypeChange();
    }

    public boolean isAttributeTypeValid(AttributeTypeId attributeType) {
        return this.getArtifactType().isValidAttributeType(attributeType);
    }

    @Override
    public Collection<AttributeTypeToken> getValidAttributeTypes() {
        return this.getArtifactType().getValidAttributeTypes();
    }

    @Override
    public String getExceptionString() {
        try {
            return String.format("artifact type[%s] id[%s] on branch[%s]", this.getArtifactType(), this.getId(), this.getBranch());
        }
        catch (OseeCoreException ex) {
            return Lib.exceptionToString((Exception)((Object)ex));
        }
    }

    @Override
    public void accept(ArtifactVisitor visitor) {
        visitor.visit(this);
        for (Attribute attribute : this.getAttributes(DeletionFlag.INCLUDE_DELETED)) {
            visitor.visit(attribute);
        }
    }

    public void delete() {
        this.getOrcsData().setModType(ModificationType.DELETED);
        this.deleteAttributesByArtifact();
    }

    @Override
    public boolean isDeleteAllowed() {
        return !this.isDeleted();
    }

    public void unDelete() {
        this.getOrcsData().setModType(this.getOrcsData().getBaseModType());
        this.unDeleteAttributesByArtifact();
    }

    @Override
    public boolean isAccessible() {
        return !this.isDeleted();
    }

    @Override
    public String getOrderData() {
        return this.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.RelationOrder, Strings.emptyString());
    }

    @Override
    public void storeOrderData(OrderChange changeType, String data) {
        if (Strings.isValid((String)data)) {
            this.setSoleAttributeFromString((AttributeTypeToken)CoreAttributeTypes.RelationOrder, data);
        } else {
            this.deleteSoleAttribute((AttributeTypeToken)CoreAttributeTypes.RelationOrder);
        }
    }

    public String toString() {
        try {
            return String.format("artifact [type=[%s] artifact id=[%s] branch=[%s]]", this.getArtifactType(), this.getId(), this.getBranch());
        }
        catch (OseeCoreException ex) {
            return Lib.exceptionToString((Exception)((Object)ex));
        }
    }

    @Override
    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable() {
        return null;
    }
}

