/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.applicability.ApplicabilityBranchConfig;
import org.eclipse.osee.framework.core.applicability.BranchViewDefinition;
import org.eclipse.osee.framework.core.applicability.ExtendedFeatureDefinition;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.applicability.NameValuePair;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewToken;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.CreateViewDefinition;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsApplicabilityOps
implements OrcsApplicability {
    private final OrcsApi orcsApi;
    private final Log logger;
    private ArtifactToken plFolder = ArtifactToken.SENTINEL;
    private ArtifactToken featureFolder = ArtifactToken.SENTINEL;
    private ArtifactToken productsFolder = ArtifactToken.SENTINEL;
    private ArtifactToken plConfigurationGroupsFolder = ArtifactToken.SENTINEL;

    public OrcsApplicabilityOps(OrcsApi orcsApi, Log logger) {
        this.orcsApi = orcsApi;
        this.logger = logger;
    }

    public ApplicabilityBranchConfig getConfig(BranchId branchId, boolean showAll) {
        ApplicabilityBranchConfig config = new ApplicabilityBranchConfig();
        Branch branch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branchId)).getResults().getExactlyOne();
        config.setBranch((BranchViewToken)branch);
        config.setAssociatedArtifactId(branch.getAssociatedArtifact());
        if (branch.getBranchType().equals(BranchType.WORKING.getId())) {
            config.setEditable(Boolean.valueOf(true));
        } else {
            config.setEditable(Boolean.valueOf(false));
        }
        if (branch.getParentBranch().isValid()) {
            Branch parentBranch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch.getParentBranch())).getResults().getExactlyOne();
            config.setParentBranch(new BranchViewToken((BranchId)parentBranch, parentBranch.getName(), parentBranch.getViewId()));
        }
        List branchViews = this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).getResults().getList();
        List groups = this.orcsApi.getQueryFactory().applicabilityQuery().getConfigurationGroupsForBranch((BranchId)branch);
        Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
        HashMap<ArtifactId, Map<String, List<String>>> branchViewsMap = new HashMap<ArtifactId, Map<String, List<String>>>();
        for (ArtifactReadable branchView : branchViews) {
            List appTokens = this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens((ArtifactId)branchView, (BranchId)branch);
            appTokens.removeIf(n -> n.getName().startsWith("Config ="));
            boolean hasFeatureApplicabilities = appTokens.size() > 1;
            config.addView(new BranchViewDefinition(branchView.getIdString(), branchView.getName(), branchView.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.ProductApplicability), hasFeatureApplicabilities));
            branchViewsMap.put((ArtifactId)branchView, this.orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap((BranchId)branch, (ArtifactId)branchView));
        }
        for (ArtifactToken group : groups) {
            config.addGroup(this.getConfigurationGroup(group.getIdString(), (BranchId)branch));
            branchViewsMap.put((ArtifactId)group, this.orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap((BranchId)branch, (ArtifactId)group));
        }
        List featureArts = this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).getResults().getList();
        Collections.sort(featureArts, new NamedComparator(SortOrder.ASCENDING));
        for (ArtifactToken featureArt : featureArts) {
            FeatureDefinition fDef = this.getFeatureDefinition(featureArt);
            ExtendedFeatureDefinition extfDef = new ExtendedFeatureDefinition(fDef);
            LinkedList<List<NameValuePair>> groupingsList = new LinkedList<List<NameValuePair>>();
            for (ConfigurationGroupDefinition configurationGroupDefinition : config.getGroups()) {
                String groupToFeatureValue = this.getViewToFeatureValue(ArtifactId.valueOf((String)configurationGroupDefinition.getId()), fDef, branchViewsMap);
                List<NameValuePair> groupList = new LinkedList<NameValuePair>();
                groupList.add(new NameValuePair(configurationGroupDefinition.getName(), groupToFeatureValue));
                for (BranchViewDefinition memberConfig : config.getViews()) {
                    if (!configurationGroupDefinition.getConfigurations().contains(memberConfig.getId())) continue;
                    String viewToFeatureValue = this.getViewToFeatureValue(ArtifactId.valueOf((String)memberConfig.getId()), fDef, branchViewsMap);
                    groupList.add(new NameValuePair(memberConfig.getName(), viewToFeatureValue));
                }
                groupingsList.add(groupList);
            }
            for (BranchViewDefinition branchViewDefinition : config.getViews()) {
                boolean viewPresent = false;
                for (List<NameValuePair> groupList : groupingsList) {
                    for (NameValuePair configItem : groupList) {
                        if (configItem.getName() != branchViewDefinition.getName()) continue;
                        viewPresent = true;
                    }
                }
                if (viewPresent) continue;
                String viewToFeatureValue = this.getViewToFeatureValue(ArtifactId.valueOf((String)branchViewDefinition.getId()), fDef, branchViewsMap);
                extfDef.addConfiguration(new NameValuePair(branchViewDefinition.getName(), viewToFeatureValue));
            }
            for (List list : groupingsList) {
                for (NameValuePair configItem : list) {
                    extfDef.addConfiguration(configItem);
                }
            }
            config.addFeature(extfDef);
        }
        return config;
    }

    private String getViewToFeatureValue(ArtifactId view, FeatureDefinition fDef, Map<ArtifactId, Map<String, List<String>>> branchViewsMap) {
        Map<String, List<String>> map = branchViewsMap.get(view);
        List<String> list = map.get(fDef.getName());
        if (list == null) {
            return "";
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", list);
    }

    public CreateViewDefinition getViewDefinition(ArtifactToken featureArt) {
        ArtifactReadable art = (ArtifactReadable)featureArt;
        CreateViewDefinition view = new CreateViewDefinition();
        view.setId(art.getId());
        view.setName(art.getName());
        view.setProductApplicabilities(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.ProductApplicability));
        view.setData((Object)art);
        return view;
    }

    public FeatureDefinition getFeatureDefinition(ArtifactToken featureArt) {
        ArtifactReadable art = (ArtifactReadable)featureArt;
        FeatureDefinition feature = new FeatureDefinition();
        feature.setId(art.getId());
        feature.setName(art.getName());
        feature.setDefaultValue((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)""));
        feature.setValues(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.Value));
        feature.setProductApplicabilities(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.ProductApplicability));
        feature.setValueType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FeatureValueType, ""));
        feature.setMultiValued(((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)false)).booleanValue());
        feature.setDescription(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
        feature.setData((Object)featureArt);
        return feature;
    }

    public ArtifactToken createUpdateFeatureDefinition(FeatureDefinition featureDef, String action, TransactionBuilder tx, XResultData results) {
        ArtifactToken fDefArt = null;
        if (Strings.isInValid((String)featureDef.getName())) {
            results.error("Feature must have a name.");
        }
        if (!featureDef.getName().matches("^[A-Z0-9_()\\s\\-\\.]+$")) {
            results.error("Feature name must be all caps with no special characters except underscore, dash, and space");
        }
        if (Strings.isInValid((String)featureDef.getDescription())) {
            results.error("Description is required.");
        }
        if (featureDef.getValues() == null) {
            results.error("Values must be specified.  Comma delimited.");
        } else {
            for (String val : featureDef.getValues()) {
                if (val.matches("^[a-zA-Z0-9_()\\s\\-\\.]+$")) continue;
                results.error("The value: " + val + " is invalid.  Must be alphanumeric.");
            }
        }
        if (Strings.isInValid((String)featureDef.getDefaultValue())) {
            results.error("Default value is required");
        }
        if (featureDef.getValues() != null && !featureDef.getValues().contains(featureDef.getDefaultValue())) {
            results.error("Default value must be in the list of values.");
        }
        if (Strings.isInValid((String)featureDef.getValueType())) {
            results.error("Value type is required.");
        }
        FeatureDefinition lFeature = this.getFeature(featureDef.getName(), tx.getBranch());
        if (action != null && action.equals("add") && lFeature.isValid()) {
            results.error("Feature: " + lFeature.getName() + " already exists.");
        }
        if (results.isErrors()) {
            return null;
        }
        if (lFeature.isInvalid()) {
            ArtifactToken featuresFolder = tx.getWriteable((ArtifactId)CoreArtifactTokens.FeaturesFolder);
            if (featuresFolder.isInvalid()) {
                featuresFolder = this.getFeaturesFolder(tx.getBranch());
            }
            if (featuresFolder.isInvalid()) {
                results.error("Features Folder cannot be null");
                return null;
            }
            Long artId = featureDef.getId();
            if (artId == null || artId <= 0L) {
                artId = Lib.generateArtifactIdAsInt();
            }
            fDefArt = tx.createArtifact(featuresFolder, CoreArtifactTypes.Feature, featureDef.getName(), artId);
        } else {
            fDefArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((Long)lFeature.getId())).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        this.updateFeatureDefinition(fDefArt, featureDef, tx);
        return fDefArt;
    }

    private void updateFeatureDefinition(ArtifactToken fDefArt, FeatureDefinition featureDef, TransactionBuilder tx) {
        tx.setName((ArtifactId)fDefArt, featureDef.getName());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)featureDef.getDefaultValue());
        tx.setAttributesFromValues((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.Value, (Collection)featureDef.getValues());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.FeatureValueType, (Object)featureDef.getValueType());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)featureDef.isMultiValued());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)featureDef.getDescription());
        if (featureDef.getProductApplicabilities() != null) {
            tx.setAttributesFromValues((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.ProductApplicability, (Collection)featureDef.getProductApplicabilities());
        }
    }

    public List<BranchId> getApplicabilityBranches() {
        ArrayList<BranchId> tokens = new ArrayList<BranchId>();
        for (Branch branch : ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE, BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList()) {
            if (!this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).exists()) continue;
            tokens.add((BranchId)branch);
        }
        return tokens;
    }

    public List<BranchId> getApplicabilityBranchesByType(String branchQueryType) {
        ArrayList<BranchId> tokens = new ArrayList<BranchId>();
        List branchList = new ArrayList();
        if (branchQueryType.equals("all")) {
            branchList = ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE, BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList();
        }
        if (branchQueryType.equals("baseline")) {
            branchList = ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList();
        }
        for (Branch branch : branchList) {
            if (!this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).exists()) continue;
            tokens.add((BranchId)branch);
        }
        return tokens;
    }

    public ArtifactToken getFeaturesFolder(BranchId branch) {
        if (this.featureFolder.isInvalid()) {
            this.featureFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.ProductLineFolder).andNameEquals("Features").getArtifactOrSentinal();
        }
        return this.featureFolder;
    }

    public ArtifactToken getProductsFolder(BranchId branch) {
        if (this.productsFolder.isInvalid()) {
            this.productsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.ProductLineFolder).andNameEquals("Products").getArtifactOrSentinal();
        }
        return this.productsFolder;
    }

    public ArtifactToken getPlConfigurationGroupsFolder(BranchId branch) {
        if (this.plConfigurationGroupsFolder.isInvalid()) {
            this.plConfigurationGroupsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.ProductLineFolder).andNameEquals("PL Configuration Groups").getArtifactOrSentinal();
        }
        return this.plConfigurationGroupsFolder;
    }

    public ArtifactToken getProductLineFolder(BranchId branch) {
        if (this.plFolder.isInvalid()) {
            this.plFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).getArtifactOrSentinal();
        }
        if (this.plFolder.isInvalid()) {
            this.plFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andNameEquals("Product Line").asArtifactTokenOrSentinel();
        }
        return this.plFolder;
    }

    public XResultData convertConfigToArtifact(BranchId branch) {
        XResultData results = new XResultData();
        BranchId ah64eRootBranch = BranchId.valueOf((String)"5968659056771480963");
        BranchId aopRootBranch = BranchId.valueOf((String)"6155750414142653974");
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, (UserId)SystemUser.OseeSystem, "Convert Feature Defs to Artifact");
        List featureDefinitionArts = this.orcsApi.getQueryFactory().fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.FeatureDefinition}).getResults().getList();
        ArrayList<FeatureDefinition> featureDefinitionFromJson = new ArrayList<FeatureDefinition>();
        for (ArtifactReadable art : featureDefinitionArts) {
            String json = art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
            FeatureDefinition[] readValue = (FeatureDefinition[])JsonUtil.readValue((String)json, FeatureDefinition[].class);
            featureDefinitionFromJson.addAll(Arrays.asList(readValue));
        }
        for (FeatureDefinition feature : featureDefinitionFromJson) {
            FeatureDefinition featureDef;
            ArtifactToken featureArt = ArtifactToken.SENTINEL;
            boolean introduce = false;
            if (feature.getDescription().isEmpty()) {
                feature.setDescription(feature.getName());
            }
            if (feature.getDefaultValue().isEmpty()) {
                feature.setDefaultValue((String)feature.getValues().iterator().next());
            }
            if ((featureDef = this.orcsApi.getApplicabilityOps().getFeature(feature.getName(), branch)).isInvalid()) {
                featureArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(ah64eRootBranch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andNameEquals(feature.getName()).getResults().getAtMostOneOrNull();
                if (featureArt.isValid()) {
                    results.warning("Introduce " + feature.getName() + " from AH64E Product Line");
                    introduce = true;
                } else {
                    featureArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(aopRootBranch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andNameEquals(feature.getName()).getResults().getAtMostOneOrNull();
                    if (featureArt.isValid()) {
                        results.warning("Introduce " + feature.getName() + " from AOP Product Line");
                        introduce = true;
                    }
                }
            }
            if (feature.getType().equals("single")) {
                feature.setMultiValued(false);
            } else if (feature.getType().equals("multiple")) {
                feature.setMultiValued(true);
            } else {
                throw new IllegalArgumentException(String.format("Unexpected value type [%s]", feature.getValueType()));
            }
            if (featureDef.isValid()) {
                feature.setValueType("String");
                this.createUpdateFeatureDefinition(feature, "update", tx, results);
            } else if (!introduce) {
                feature.setValueType("String");
                this.createUpdateFeatureDefinition(feature, "add", tx, results);
            }
            if (!results.isErrors()) continue;
            results.error("Errors on branch: " + ((Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getOneOrNull()).getName() + " creating feature: " + feature.getName());
            return results;
        }
        if (!results.isErrors()) {
            tx.commit();
        }
        return results;
    }

    public XResultData createUpdateFeature(FeatureDefinition feature, String action, BranchId branch, UserId account) {
        UserId user;
        XResultData results = new XResultData();
        try {
            TransactionBuilder tx;
            user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            if (this.createUpdateFeatureDefinition(feature, action, tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Update Feature"), results) != null) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        if (action.equals("add") && results.getNumErrors() == 0) {
            try {
                user = account;
                boolean changes = false;
                if (user == null) {
                    user = SystemUser.OseeSystem;
                }
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set Defaults for Products/Views for New Feature");
                List branchViews = this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch(branch);
                Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
                for (ArtifactToken view : branchViews) {
                    Iterable appl = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)view);
                    if (appl.toString().contains(String.valueOf(feature.getName()) + " = ")) continue;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)(String.valueOf(feature.getName()) + " = " + feature.getDefaultValue()));
                    changes = true;
                }
                if (changes) {
                    tx.commit();
                }
            }
            catch (Exception ex) {
                results.error(Lib.exceptionToString((Exception)ex));
            }
        }
        return results;
    }

    public FeatureDefinition getFeature(String feature, BranchId branch) {
        if (Strings.isNumeric((String)feature)) {
            ArtifactToken featureArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andId(ArtifactId.valueOf((String)feature)).getResults().getAtMostOneOrNull();
            if (featureArt != null) {
                return this.getFeatureDefinition(featureArt);
            }
        } else {
            ArtifactToken featureArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andNameEquals(feature).getResults().getAtMostOneOrNull();
            if (featureArt != null) {
                return this.getFeatureDefinition(featureArt);
            }
        }
        return FeatureDefinition.SENTINEL;
    }

    public XResultData deleteFeature(ArtifactId feature, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            ArtifactToken featureArt = (ArtifactToken)this.getFeature(feature.getIdString(), branch).getData();
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Delete Feature");
            List branchViews = this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch(branch);
            Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
            for (ArtifactToken v : branchViews) {
                Iterable appl = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)v);
                for (String app : appl) {
                    if (!appl.toString().contains(feature + " = ")) continue;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)v, (Object)app);
                }
            }
            tx.deleteArtifact((ArtifactId)featureArt);
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData removeApplicabilityFromView(BranchId branch, ArtifactId viewId, String applicability, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            CreateViewDefinition view = this.getView(viewId.getIdString(), branch);
            if (this.orcsApi.getQueryFactory().applicabilityQuery().applicabilityExistsOnBranchView(branch, viewId, applicability)) {
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Remove applicability from configuration");
                tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)applicability);
                tx.commit();
            } else {
                results.error(String.valueOf(applicability) + " does not exist on configuration: " + view.getName());
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public CreateViewDefinition getView(String view, BranchId branch) {
        CreateViewDefinition viewDef = new CreateViewDefinition();
        if (Strings.isNumeric((String)view)) {
            ArtifactToken viewArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andId(ArtifactId.valueOf((String)view)).getResults().getAtMostOneOrNull();
            if (viewArt != null) {
                viewDef = this.getViewDefinition(viewArt);
            }
        } else {
            ArtifactToken viewArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andNameEquals(view).getResults().getAtMostOneOrNull();
            if (viewArt != null) {
                viewDef = this.getViewDefinition(viewArt);
            }
        }
        return viewDef;
    }

    public ConfigurationGroupDefinition getConfigurationGroup(String cfgGroup, BranchId branch) {
        ConfigurationGroupDefinition configGroup = new ConfigurationGroupDefinition();
        ArtifactToken groupArt = ArtifactToken.SENTINEL;
        groupArt = Strings.isNumeric((String)cfgGroup) ? (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andId(ArtifactId.valueOf((String)cfgGroup)).getResults().getAtMostOneOrNull() : (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andNameEquals(cfgGroup).getResults().getAtMostOneOrNull();
        if (groupArt != null) {
            configGroup.setName(groupArt.getName());
            configGroup.setId(groupArt.getIdString());
            ArrayList<String> views = new ArrayList<String>();
            for (ArtifactId view : this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(CoreRelationTypes.PlConfigurationGroup_Group, (ArtifactId)groupArt).asArtifactIds()) {
                views.add(view.getIdString());
            }
            configGroup.setConfigurations(views);
        }
        return configGroup;
    }

    public XResultData createUpdateView(CreateViewDefinition view, String action, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        UserId user = account;
        if (user == null) {
            user = SystemUser.OseeSystem;
        }
        if (action.equals("edit")) {
            TransactionBuilder tx;
            ArtifactToken editView = this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((Long)view.getId())).asArtifactToken();
            if (editView.isInvalid()) {
                results.errorf("Edit failed: invalid view", new Object[0]);
                return results;
            }
            if (view.copyFrom.isValid()) {
                results = this.copyFromView(branch, (ArtifactId)editView, view.copyFrom, account);
            }
            if (results.isErrors()) {
                return results;
            }
            if (!view.getProductApplicabilities().isEmpty()) {
                tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Update Configuration Product Applicabilities");
                tx.setAttributesFromValues((ArtifactId)editView, (AttributeTypeToken)CoreAttributeTypes.ProductApplicability, (Collection)view.getProductApplicabilities());
                tx.commit();
            }
            if (!view.getName().equals(editView.getName())) {
                tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Update Configuration/View Name");
                tx.setName((ArtifactId)editView, view.getName());
                tx.commit();
            }
            if (view.getConfigurationGroup().isValid() && (results = this.relateCfgGroupToView(view.getConfigurationGroup().getIdString(), editView.getIdString(), branch, account)).isErrors()) {
                return results;
            }
        } else if (action.equals("add")) {
            if (!Strings.isValid((String)view.getName())) {
                results.errorf("Name can not be empty for product %s", new Object[]{view.getId()});
                return results;
            }
            CreateViewDefinition xView = this.getView(view.getName(), branch);
            if (xView.isValid()) {
                results.errorf("Product Name is already in use.", new Object[0]);
                return results;
            }
            if (xView.isInvalid()) {
                try {
                    TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create View ");
                    this.createUpdateViewDefinition(view, tx);
                    tx.commit();
                    CreateViewDefinition newView = this.getView(view.getName(), branch);
                    TransactionBuilder tx2 = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create Config and Base applicabilities on New View");
                    tx2.createApplicabilityForView(ArtifactId.valueOf((Long)newView.getId()), "Base");
                    tx2.createApplicabilityForView(ArtifactId.valueOf((Long)newView.getId()), "Config = " + view.getName());
                    tx2.commit();
                }
                catch (Exception ex) {
                    results.errorf(Lib.exceptionToString((Exception)ex), new Object[0]);
                    return results;
                }
            }
            if (view.getCopyFrom().isValid() || view.getConfigurationGroup().isValid()) {
                CreateViewDefinition nView = this.getView(view.getName(), branch);
                if (nView.isValid()) {
                    if (view.getCopyFrom().isValid() && (results = this.copyFromView(branch, ArtifactId.valueOf((Id)nView), view.copyFrom, account)).isErrors()) {
                        return results;
                    }
                    if (view.getConfigurationGroup().isValid() && (results = this.relateCfgGroupToView(view.getConfigurationGroup().getIdString(), nView.getIdString(), branch, account)).isErrors()) {
                        return results;
                    }
                } else {
                    results.error("Errors creating new configuration: " + view.getName());
                }
            }
        }
        return results;
    }

    private ArtifactToken createUpdateViewDefinition(CreateViewDefinition view, TransactionBuilder tx) {
        ArtifactToken vDefArt = null;
        if (view.isValid()) {
            vDefArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((Long)view.getId())).getResults().getAtMostOneOrNull();
        }
        if (vDefArt == null) {
            Long artId = view.getId();
            if (artId == null || artId <= 0L) {
                artId = Lib.generateArtifactIdAsInt();
            }
            vDefArt = tx.createArtifact(this.getProductsFolder(tx.getBranch()), CoreArtifactTypes.BranchView, view.getName(), artId);
        }
        tx.setName(vDefArt, view.getName());
        if (!view.getProductApplicabilities().isEmpty()) {
            tx.setAttributesFromValues((ArtifactId)vDefArt, (AttributeTypeToken)CoreAttributeTypes.ProductApplicability, (Collection)view.getProductApplicabilities());
        }
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)vDefArt.getBranch()).andId((ArtifactId)vDefArt).getArtifactOrSentinal();
    }

    public XResultData deleteView(String view, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            CreateViewDefinition viewDef = this.getView(view, branch);
            Iterable deleteApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)ArtifactId.valueOf((Long)viewDef.getId()));
            ArtifactToken viewArt = (ArtifactToken)viewDef.getData();
            if (viewArt.isValid()) {
                TransactionBuilder txApps = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Delete all applicabilities for deleted view");
                for (String app : deleteApps) {
                    txApps.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)ArtifactId.valueOf((Long)viewDef.getId()), (Object)app);
                }
                txApps.commit();
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Delete View");
                tx.deleteArtifact((ArtifactId)viewArt);
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData setApplicability(BranchId branch, ArtifactId view, ArtifactId feature, String applicability, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            ArtifactToken featureArt = this.orcsApi.getQueryFactory().fromBranch(branch).andId(feature).getArtifactOrNull();
            FeatureDefinition fDef = this.orcsApi.getApplicabilityOps().getFeatureDefinition(featureArt);
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set View Feature Applicability");
            LinkedList<String> existingValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)view)) {
                if (!appl.startsWith(String.valueOf(fDef.getName()) + " = ")) continue;
                existingValues.add(appl);
            }
            LinkedList<String> newValues = new LinkedList<String>();
            String[] stringArray = applicability.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                value = value.replace("^ +", "");
                value = value.replace(" +$", "");
                value = String.valueOf(featureArt.getName()) + " = " + value;
                newValues.add(value);
                ++n2;
            }
            boolean change = false;
            if (!((Object)existingValues).toString().equals("[]")) {
                for (String existingValue : existingValues) {
                    if (newValues.contains(existingValue)) continue;
                    change = true;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)existingValue);
                }
                for (String newValue : newValues) {
                    if (existingValues.contains(newValue)) continue;
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)newValue);
                }
            } else {
                for (String newValue : newValues) {
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)newValue);
                }
            }
            if (change) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData copyFromView(BranchId branch, ArtifactId view, ArtifactId copy_from, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set Product/View Feature Applicability");
            LinkedList<String> existingValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)view)) {
                if (appl.startsWith("Config") || appl.startsWith("Base")) continue;
                existingValues.add(appl);
            }
            LinkedList<String> newValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)copy_from)) {
                if (appl.startsWith("Config") || appl.startsWith("Base")) continue;
                newValues.add(appl);
            }
            boolean change = false;
            if (!((Object)existingValues).toString().equals("[]")) {
                for (String existingValue : existingValues) {
                    if (newValues.contains(existingValue)) continue;
                    change = true;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)existingValue);
                }
                for (String newValue : newValues) {
                    if (existingValues.contains(newValue)) continue;
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)newValue);
                }
            } else {
                for (String newValue : newValues) {
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)newValue);
                }
            }
            if (change) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData createApplicabilityForView(ArtifactId viewId, String applicability, UserId account, BranchId branch) {
        XResultData results = new XResultData();
        UserId user = account;
        if (user == null) {
            user = SystemUser.OseeSystem;
        }
        if (results.isErrors()) {
            return results;
        }
        if (!this.orcsApi.getQueryFactory().applicabilityQuery().viewExistsOnBranch(branch, viewId)) {
            results.error("View is invalid.");
            return results;
        }
        if (this.orcsApi.getQueryFactory().applicabilityQuery().applicabilityExistsOnBranchView(branch, viewId, applicability)) {
            results.error("Applicability already exists.");
            return results;
        }
        if (applicability.startsWith("Config =")) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create applicability");
            tx.createApplicabilityForView(viewId, applicability);
            tx.commit();
            return results;
        }
        if (applicability.startsWith("ConfigurationGroup =")) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create applicability");
            tx.createApplicabilityForView(viewId, applicability);
            tx.commit();
            return results;
        }
        if (applicability.equals("Base")) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create applicability");
            tx.createApplicabilityForView(viewId, applicability);
            tx.commit();
            return results;
        }
        if (applicability.contains("|") || applicability.contains("&")) {
            boolean validApplicability = false;
            if (applicability.contains("|")) {
                String[] stringArray = applicability.split("\\|");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (String appl : existingApps) {
                        if (!appl.equals(value.trim())) continue;
                        validApplicability = true;
                    }
                    ++n2;
                }
            } else {
                int cnt = applicability.split("&").length;
                int validCnt = 0;
                String[] appl = applicability.split("&");
                int existingApps = appl.length;
                int n = 0;
                while (n < existingApps) {
                    String value = appl[n];
                    Iterable existingApps2 = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (String appl2 : existingApps2) {
                        if (!appl2.equals(value.trim())) continue;
                        ++validCnt;
                    }
                    ++n;
                }
                if (cnt == validCnt) {
                    validApplicability = true;
                }
            }
            if (validApplicability) {
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set applicability for view");
                tx.createApplicabilityForView(viewId, applicability);
                tx.commit();
            } else {
                results.error("Invalid applicability tag.  One of the applicabilities used is not valid for the given view.");
            }
        } else {
            String featureName = applicability.substring(0, applicability.indexOf("=") - 1);
            String featureValue = applicability.substring(applicability.indexOf("=") + 2);
            if (this.orcsApi.getQueryFactory().applicabilityQuery().featureExistsOnBranch(branch, featureName) && this.orcsApi.getQueryFactory().applicabilityQuery().featureValueIsValid(branch, featureName, featureValue)) {
                LinkedList<String> existingValues = new LinkedList<String>();
                Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                for (String appl : existingApps) {
                    if (!appl.startsWith(String.valueOf(featureName) + " = ") && !appl.contains("| " + featureName + "=")) continue;
                    existingValues.add(appl);
                }
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set applicability for view");
                boolean multiValued = false;
                if (existingValues.size() > 0) {
                    List<FeatureDefinition> featureDefinitionData = this.getFeatureDefinitionData(branch);
                    for (FeatureDefinition feat : featureDefinitionData) {
                        if (!feat.getName().toUpperCase().equals(featureName)) continue;
                        multiValued = feat.isMultiValued();
                        break;
                    }
                }
                if (!multiValued) {
                    for (String existingValue : existingValues) {
                        tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)existingValue);
                    }
                }
                tx.createApplicabilityForView(viewId, applicability);
                tx.commit();
                this.updateCompoundApplicabilities(branch, viewId, user);
            } else {
                results.error("Feature is not defined or Value is invalid.");
            }
        }
        return results;
    }

    private XResultData updateCompoundApplicabilities(BranchId branch, ArtifactId viewId, UserId user) {
        XResultData results = new XResultData();
        Collection allApps = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(branch).values();
        List compoundApps = allApps.stream().filter(p -> p.getName().contains("|") || p.getName().contains("&")).collect(Collectors.toList());
        for (ApplicabilityToken app : compoundApps) {
            TransactionBuilder tx;
            boolean validApplicability = false;
            if (app.getName().contains("|")) {
                String[] stringArray = app.getName().split("\\|");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (String appl : existingApps) {
                        if (!appl.equals(value.trim())) continue;
                        validApplicability = true;
                    }
                    ++n2;
                }
            } else {
                int cnt = app.getName().split("&").length;
                int validCnt = 0;
                String[] stringArray = app.getName().split("&");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String value = stringArray[n3];
                    Iterable existingApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId);
                    for (String appl : existingApps) {
                        if (!appl.equals(value.trim())) continue;
                        ++validCnt;
                    }
                    ++n3;
                }
                if (cnt == validCnt) {
                    validApplicability = true;
                }
            }
            if (this.orcsApi.getQueryFactory().applicabilityQuery().applicabilityExistsOnBranchView(branch, viewId, app.getName())) {
                if (validApplicability) continue;
                tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Remove invalid compound applicability");
                tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)viewId, (Object)app.getName());
                tx.commit();
                continue;
            }
            if (!validApplicability) continue;
            tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Apply valid compound applicability");
            tx.createApplicabilityForView(viewId, app.getName());
            tx.commit();
        }
        return results;
    }

    public List<FeatureDefinition> getFeatureDefinitionData(BranchId branch) {
        return this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(branch);
    }

    public XResultData createCfgGroup(ConfigurationGroupDefinition group, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        if (!Strings.isValid((String)group.getName())) {
            results.errorf("Name can not be empty for Configuration Group: %s", new Object[]{group.getName()});
            return results;
        }
        if (this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(group.getName()).exists()) {
            results.errorf("Configuration Group Name already exists", new Object[0]);
            return results;
        }
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create PL Configuration Group");
            ArtifactToken vDefArt = null;
            Long artId = Lib.generateArtifactIdAsInt();
            vDefArt = tx.createArtifact(this.getPlConfigurationGroupsFolder(tx.getBranch()), CoreArtifactTypes.GroupArtifact, group.getName(), artId);
            tx.setName((ArtifactId)vDefArt, group.getName());
            tx.commit();
            ArtifactId newGrp = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andNameEquals(group.getName()).asArtifactId();
            TransactionBuilder tx2 = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create Config and Base applicabilities on new view");
            tx2.createApplicabilityForView(newGrp, "Base");
            tx2.createApplicabilityForView(newGrp, "ConfigurationGroup = " + group.getName());
            for (FeatureDefinition feature : this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(branch)) {
                tx2.createApplicabilityForView(newGrp, String.valueOf(feature.getName()) + " = " + feature.getDefaultValue());
            }
            tx2.commit();
            results.getIds().add(newGrp.getIdString());
            if (!group.getConfigurations().isEmpty()) {
                for (String cfg : group.getConfigurations()) {
                    this.relateCfgGroupToView(newGrp.getIdString(), cfg, branch, user);
                }
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData updateCfgGroup(ConfigurationGroupDefinition group, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        ConfigurationGroupDefinition currentGroup = this.getConfigurationGroup(group.getId(), branch);
        if (!currentGroup.getName().equals("")) {
            try {
                UserId user = account;
                if (user == null) {
                    user = SystemUser.OseeSystem;
                }
                if (!group.getName().equals(currentGroup.getName())) {
                    TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Update PL Configuration Group Name");
                    tx.setName(ArtifactId.valueOf((String)group.getId()), group.getName());
                    tx.commit();
                }
                if (!group.getConfigurations().toString().equals(currentGroup.getConfigurations().toString())) {
                    for (String cfg : currentGroup.getConfigurations()) {
                        if (group.getConfigurations().contains(cfg)) continue;
                        results = this.unrelateCfgGroupToView(currentGroup.getId(), cfg, branch, user);
                    }
                    for (String cfg : group.getConfigurations()) {
                        if (currentGroup.getConfigurations().contains(cfg)) continue;
                        results = this.relateCfgGroupToView(currentGroup.getId(), cfg, branch, account);
                    }
                }
            }
            catch (Exception ex) {
                results.error(Lib.exceptionToString((Exception)ex));
            }
        } else {
            results.errorf("Configuration Group does not exist", new Object[0]);
        }
        return results;
    }

    public XResultData relateCfgGroupToView(String groupId, String viewId, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        ArtifactToken cfgGroup = Strings.isNumeric((String)groupId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)groupId)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactTokenOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(groupId).asArtifactTokenOrSentinel();
        ArtifactToken view = Strings.isNumeric((String)viewId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andId(ArtifactId.valueOf((String)viewId)).getArtifactOrSentinal() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andNameEquals(viewId).getArtifactOrSentinal();
        if (cfgGroup.isInvalid()) {
            results.errorf("Configuration Group does not exist", new Object[0]);
            return results;
        }
        if (view.isInvalid()) {
            results.errorf("View name does not exist", new Object[0]);
            return results;
        }
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Relate view: " + view.getName() + " to PL Configuration Group " + cfgGroup.getName());
            tx.relate((ArtifactId)cfgGroup, (RelationTypeToken)CoreRelationTypes.PlConfigurationGroup_Group, ArtifactId.valueOf((String)view.getIdString()));
            tx.createApplicabilityForView((ArtifactId)view, "ConfigurationGroup = " + cfgGroup.getName());
            tx.createApplicabilityForView((ArtifactId)cfgGroup, "Config = " + view.getName());
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData unrelateCfgGroupToView(String groupId, String viewId, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        ArtifactToken cfgGroup = Strings.isNumeric((String)groupId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)groupId)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactTokenOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(groupId).asArtifactTokenOrSentinel();
        ArtifactToken view = Strings.isNumeric((String)viewId) ? this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andId(ArtifactId.valueOf((String)viewId)).getArtifactOrSentinal() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).andNameEquals(viewId).getArtifactOrSentinal();
        if (cfgGroup.isInvalid()) {
            results.errorf("Configuration Group does not exist", new Object[0]);
            return results;
        }
        if (view.isInvalid()) {
            results.errorf("View name does not exist", new Object[0]);
            return results;
        }
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Un-Relate view from PL Configuration Group ");
            tx.unrelate((ArtifactId)cfgGroup, (RelationTypeToken)CoreRelationTypes.PlConfigurationGroup_Group, (ArtifactId)view);
            tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)view, (Object)("ConfigurationGroup = " + cfgGroup.getName()));
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData deleteCfgGroup(String id, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        ArtifactToken cfgGroupArtToken = Strings.isNumeric((String)id) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)id)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactTokenOrSentinel() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(id).asArtifactTokenOrSentinel();
        if (cfgGroupArtToken.isInvalid()) {
            results.errorf("Configuration Group does not exist", new Object[0]);
            return results;
        }
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            Iterable deleteApps = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)cfgGroupArtToken);
            TransactionBuilder txApps = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Delete Applicabilities associated with ConfigurationGroup");
            for (String app : deleteApps) {
                txApps.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)cfgGroupArtToken, (Object)app);
            }
            txApps.commit();
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Delete Cfg Group");
            tx.deleteArtifact((ArtifactId)cfgGroupArtToken);
            tx.commit();
            results.getIds().add(id);
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData syncConfigGroup(BranchId branch, String id, UserId account, XResultData results) {
        ArtifactReadable cfgGroup;
        if (results == null) {
            results = new XResultData();
        }
        if ((cfgGroup = Strings.isNumeric((String)id) ? this.orcsApi.getQueryFactory().fromBranch(branch).andId(ArtifactId.valueOf((String)id)).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).getArtifact() : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andNameEquals(id).getArtifact()).isValid() & cfgGroup.getExistingRelationTypes().contains(CoreRelationTypes.PlConfigurationGroup)) {
            List views = this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(CoreRelationTypes.PlConfigurationGroup_Group, (ArtifactId)cfgGroup).asArtifactTokens();
            for (FeatureDefinition feature : this.getFeatureDefinitionData(branch)) {
                String resultApp = null;
                if (feature.getValues().contains("Included")) {
                    resultApp = String.valueOf(feature.getName()) + " = Excluded";
                }
                for (ArtifactId viewId : views) {
                    String applicability = this.orcsApi.getQueryFactory().applicabilityQuery().getExistingFeatureApplicability(branch, viewId, feature.getName());
                    if (feature.getValues().contains("Included")) {
                        if (!applicability.equals(String.valueOf(feature.getName()) + " = Included")) continue;
                        resultApp = applicability;
                        break;
                    }
                    if (resultApp == null) {
                        resultApp = applicability;
                        continue;
                    }
                    if (resultApp.equals(applicability)) continue;
                    results.error("Updating Group: " + cfgGroup.getName() + " (" + views.toString() + "). Applicabilities differ for non-binary feature: " + feature.getName());
                }
                if (!results.isSuccess()) continue;
                this.createApplicabilityForView((ArtifactId)cfgGroup, resultApp, account, branch);
            }
            for (ArtifactId viewId : views) {
                for (ApplicabilityToken applicabilityToken : this.orcsApi.getQueryFactory().applicabilityQuery().getViewApplicabilityTokens(viewId, branch)) {
                    if (!applicabilityToken.getName().contains("|") && !applicabilityToken.getName().contains("&")) continue;
                    this.createApplicabilityForView((ArtifactId)cfgGroup, applicabilityToken.getName(), account, branch);
                }
            }
        } else {
            results.error("Invalid Configuration Group name.");
        }
        return results;
    }

    public XResultData syncConfigGroup(BranchId branch, UserId account) {
        XResultData results = new XResultData();
        for (ArtifactToken group : this.orcsApi.getQueryFactory().applicabilityQuery().getConfigurationGroupsForBranch(branch)) {
            this.syncConfigGroup(branch, group.getIdString(), account, results);
        }
        return results;
    }

    public String evaluateApplicabilityExpression(BranchId branch, ArtifactToken view, ApplicabilityBlock applic) {
        return new BlockApplicabilityOps(this.orcsApi, this.logger, branch, view).evaluateApplicabilityExpression(applic);
    }

    public String applyApplicabilityToFiles(BranchId branch, ArtifactId view, boolean commentNonApplicableBlocks, String sourcePath) {
        ArtifactToken viewToken = this.orcsApi.getQueryFactory().fromBranch(branch).andId(view).asArtifactToken();
        return new BlockApplicabilityOps(this.orcsApi, this.logger, branch, viewToken).applyApplicabilityToFiles(sourcePath, commentNonApplicableBlocks);
    }
}

