/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.FileTypeApplicabilityData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarLexer;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarParser;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityRule;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class BlockApplicabilityOps {
    private static String SCRIPT_ENGINE_NAME = "JavaScript";
    public static final String SPACES = " *";
    public static final String SINGLE_NEW_LINE = "\\r\\n|[\\n\\r]";
    public static final String BEGINFEATURE = " ?(Feature ?(\\[(.*?)\\])) ?";
    public static final String ENDFEATURE = " ?(End Feature ?((\\[.*?\\]))?) ?";
    public static final String COMMENT_EXTRA_CHARS = " *(\\r\\n|[\\n\\r])?";
    public static final int beginFeatureCommentMatcherGroup = 1;
    public static final int beginFeatureTagMatcherGroup = 2;
    public static final int endFeatureCommentMatcherGroup = 6;
    public static final int endFeatureTagMatcherGroup = 7;
    private final OrcsApi orcsApi;
    private final Log logger;
    private final ScriptEngine se;
    private final BranchId branch;
    private final ArtifactToken view;
    private final List<FeatureDefinition> featureDefinition;
    private final Map<String, List<String>> viewApplicabilitiesMap;
    private boolean commentNonApplicableBlocks = false;

    public BlockApplicabilityOps(OrcsApi orcsApi, Log logger, BranchId branch, ArtifactToken view) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.branch = branch;
        this.view = view;
        this.featureDefinition = orcsApi.getApplicabilityOps().getFeatureDefinitionData(branch);
        ScriptEngineManager sem = new ScriptEngineManager();
        this.se = sem.getEngineByName(SCRIPT_ENGINE_NAME);
        this.viewApplicabilitiesMap = orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap(this.branch, (ArtifactId)view);
    }

    public ApplicabilityBlock createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType applicType, String beginExpression) {
        ApplicabilityBlock beginApplic = new ApplicabilityBlock(applicType);
        beginExpression = beginExpression.replace(" [", "[");
        beginApplic.setApplicabilityExpression(beginExpression);
        return beginApplic;
    }

    public String applyApplicabilityToFiles(String sourcePath, boolean commentNonApplicableBlocks) {
        Map<String, FileTypeApplicabilityData> fileTypeApplicabilityDataMap = this.populateFileTypeApplicabilityDataMap();
        this.commentNonApplicableBlocks = commentNonApplicableBlocks;
        BlockApplicabilityRule rule = new BlockApplicabilityRule(this, fileTypeApplicabilityDataMap);
        StringBuilder filePattern = new StringBuilder(".*\\.(");
        filePattern.append(Collections.toString((String)"|", fileTypeApplicabilityDataMap.keySet()));
        filePattern.append(")");
        rule.setFileNamePattern(filePattern.toString());
        rule.setSubdirectoryNameToPlaceResultFilesIn(this.view.getName());
        try {
            rule.process(new File(sourcePath));
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return "ruleWasApplicable: " + rule.ruleWasApplicable();
    }

    public String evaluateApplicabilityExpression(ApplicabilityBlock applic) {
        String applicabilityExpression = applic.getApplicabilityExpression();
        String toInsert = "";
        try {
            String insideText = applic.getInsideText();
            ApplicabilityGrammarLexer lex = new ApplicabilityGrammarLexer((CharStream)new ANTLRStringStream(applicabilityExpression.toUpperCase()));
            ApplicabilityGrammarParser parser = new ApplicabilityGrammarParser((TokenStream)new CommonTokenStream((TokenSource)lex));
            parser.start();
            ApplicabilityBlock.ApplicabilityType type = applic.getType();
            if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.Feature)) {
                toInsert = this.getValidFeatureContent(insideText, applic.isInTable(), applic.getFileTypeApplicabilityData(), parser.getIdValuesMap(), parser.getOperators());
            } else if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.Configuration) || type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfiguration)) {
                toInsert = this.getValidConfigurationContent(this.branch, this.view, type, insideText, parser.getIdValuesMap());
            } else if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.ConfigurationGroup) || type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup)) {
                toInsert = this.getValidConfigurationGroupContent(this.branch, this.view, type, insideText, applic.getBeginTag());
            }
        }
        catch (RecognitionException recognitionException) {
            this.logger.error("Failed to parse expression: " + applicabilityExpression + " at start Index: " + applic.getStartInsertIndex(), new Object[0]);
        }
        return toInsert;
    }

    private String getValidFeatureContent(String fullText, boolean isInTable, FileTypeApplicabilityData fileTypeApplicabilityData, HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators) {
        Matcher match = WordCoreUtil.ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            if (isInTable) {
                String temp = fullText.substring(0, match.end());
                int lastIndexOf = temp.lastIndexOf(WordCoreUtil.START_TABLE_ROW);
                if (lastIndexOf != -1) {
                    elseText = fullText.substring(lastIndexOf);
                    elseText = elseText.replaceAll(WordCoreUtil.ELSE_EXP, "");
                    beginningText = fullText.substring(0, lastIndexOf);
                }
            } else {
                beginningText = fullText.substring(0, match.start());
                elseText = fullText.substring(match.end());
            }
            elseText = elseText.replaceAll(WordCoreUtil.ENDFEATURE, "");
            elseText = elseText.replaceAll(WordCoreUtil.BEGINFEATURE, "");
        }
        String expression = this.createFeatureExpression(featureIdValuesMap, featureOperators);
        boolean result = false;
        try {
            result = (Boolean)this.se.eval(expression);
        }
        catch (ScriptException scriptException) {
            this.logger.error("Failed to parse expression: " + expression, new Object[0]);
        }
        StringBuilder toReturn = new StringBuilder();
        if (result) {
            toReturn.append(beginningText);
            if (this.commentNonApplicableBlocks && !elseText.isEmpty()) {
                toReturn.append(this.getCommentedString(elseText, fileTypeApplicabilityData.getCommentPrefix(), fileTypeApplicabilityData.getCommentSuffix()));
            }
        } else {
            if (this.commentNonApplicableBlocks && !beginningText.isEmpty()) {
                toReturn.append(this.getCommentedString(beginningText, fileTypeApplicabilityData.getCommentPrefix(), fileTypeApplicabilityData.getCommentSuffix()));
            }
            toReturn.append(elseText);
        }
        return toReturn.toString();
    }

    private String getValidConfigurationGroupContent(BranchId branch, ArtifactToken view, ApplicabilityBlock.ApplicabilityType type, String fullText, String beginTag) {
        Matcher match = WordCoreUtil.ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            beginningText = fullText.substring(0, match.start());
            elseText = fullText.substring(match.end());
            elseText = elseText.replaceAll(WordCoreUtil.ENDCONFIGGRP, "");
            elseText = elseText.replaceAll(WordCoreUtil.BEGINCONFIGGRP, "");
        }
        String toReturn = "";
        Boolean viewInCfgGroup = false;
        viewInCfgGroup = this.viewInCfgGroup(branch, view, beginTag);
        toReturn = type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup) ? (viewInCfgGroup.booleanValue() ? elseText : beginningText) : (viewInCfgGroup == false ? elseText : beginningText);
        return toReturn;
    }

    private Boolean viewInCfgGroup(BranchId branch, ArtifactToken view, String beginTag) {
        String beginConfigGroup = WordCoreUtil.textOnly((String)beginTag);
        Boolean viewInCfgGroup = false;
        int start = beginConfigGroup.indexOf("[") + 1;
        int end = beginConfigGroup.indexOf("]");
        String applicExpText = beginConfigGroup.substring(start, end);
        String[] configGroups = applicExpText.split("&|\\|");
        int i = 0;
        while (i < configGroups.length) {
            configGroups[i] = configGroups[i].split("=")[0].trim();
            if (this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andNameEquals(configGroups[i]).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andRelatedTo(CoreRelationTypes.PlConfigurationGroup_BranchView, (ArtifactId)view).exists()) {
                viewInCfgGroup = true;
                break;
            }
            if (view.getName().equalsIgnoreCase(configGroups[i])) {
                viewInCfgGroup = true;
            }
            ++i;
        }
        return viewInCfgGroup;
    }

    private String getValidConfigurationContent(BranchId branch, ArtifactToken view, ApplicabilityBlock.ApplicabilityType type, String fullText, HashMap<String, List<String>> configIdValuesMap) {
        Matcher match = WordCoreUtil.ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            beginningText = fullText.substring(0, match.start());
            elseText = fullText.substring(match.end());
            elseText = elseText.replaceAll(WordCoreUtil.ENDCONFIG, "");
            elseText = elseText.replaceAll(WordCoreUtil.BEGINCONFIG, "");
        }
        String toReturn = "";
        List<Object> matchingTags = new ArrayList();
        if (view.isTypeEqual((ArtifactTypeId)CoreArtifactTypes.GroupArtifact)) {
            for (ArtifactReadable memberConfig : this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)view).getArtifact().getRelated(CoreRelationTypes.PlConfigurationGroup_BranchView).getList()) {
                if (!configIdValuesMap.containsKey(memberConfig.getName().toUpperCase())) continue;
                matchingTags.add("Config = " + memberConfig.getName());
            }
            if (matchingTags.isEmpty()) {
                matchingTags = null;
            }
        } else {
            matchingTags = configIdValuesMap.get(view.getName().toUpperCase());
        }
        if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfiguration)) {
            if (this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)view).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).exists()) {
                toReturn = matchingTags != null ? elseText : beginningText;
            }
        } else {
            toReturn = matchingTags == null ? elseText : beginningText;
        }
        return toReturn;
    }

    private String createFeatureExpression(HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators) {
        String myFeatureExpression = "";
        Iterator<String> iterator = featureOperators.iterator();
        for (String feature : featureIdValuesMap.keySet()) {
            List<String> values = featureIdValuesMap.get(feature);
            String valueExpression = this.createValueExpression(feature, values);
            boolean result = false;
            try {
                result = (Boolean)this.se.eval(valueExpression);
            }
            catch (ScriptException scriptException) {
                this.logger.error("Failed to parse expression: " + valueExpression, new Object[0]);
            }
            myFeatureExpression = String.valueOf(myFeatureExpression) + result + " ";
            if (!iterator.hasNext()) continue;
            String next = iterator.next();
            if (next.equals("|")) {
                myFeatureExpression = String.valueOf(myFeatureExpression) + "|| ";
                continue;
            }
            if (!next.equals("&")) continue;
            myFeatureExpression = String.valueOf(myFeatureExpression) + "&& ";
        }
        return myFeatureExpression;
    }

    private String createValueExpression(String feature, List<String> values) {
        String myValueExpression = "";
        for (String value : values) {
            if (value.equals("(")) {
                myValueExpression = String.valueOf(myValueExpression) + "( ";
                continue;
            }
            if (value.equals(")")) {
                myValueExpression = String.valueOf(myValueExpression) + ") ";
                continue;
            }
            if (value.equals("|")) {
                myValueExpression = String.valueOf(myValueExpression) + "|| ";
                continue;
            }
            if (value.equals("&")) {
                myValueExpression = String.valueOf(myValueExpression) + "&& ";
                continue;
            }
            boolean eval = this.isFeatureValuePairValid(feature, value);
            myValueExpression = String.valueOf(myValueExpression) + eval + " ";
        }
        return myValueExpression;
    }

    private boolean isFeatureValuePairValid(String feature, String value) {
        if (this.viewApplicabilitiesMap.containsKey(feature)) {
            Collection validValues = this.viewApplicabilitiesMap.get(feature);
            value = value.equalsIgnoreCase("Default") ? this.getDefaultValue(feature) : value.trim();
            return Strings.containsIgnoreCase((Collection)validValues, (String)value);
        }
        return false;
    }

    private String getDefaultValue(String feature) {
        String toReturn = null;
        for (FeatureDefinition fDef : this.featureDefinition) {
            if (!fDef.getName().equals(feature)) continue;
            toReturn = fDef.getDefaultValue();
            break;
        }
        return toReturn;
    }

    private String getCommentedString(String text, String commentPrefix, String commentSuffix) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        StringBuilder strB = new StringBuilder();
        String newLine = this.getNewLineFromFile(text);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.isEmpty()) {
                    strB.append(commentPrefix);
                    strB.append(line);
                    strB.append(commentSuffix);
                }
                strB.append(newLine);
            }
            reader.close();
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return strB.toString();
    }

    private String getNewLineFromFile(String text) {
        Matcher matcher = Pattern.compile(SINGLE_NEW_LINE).matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return System.lineSeparator();
    }

    private Map<String, FileTypeApplicabilityData> populateFileTypeApplicabilityDataMap() {
        HashMap<String, FileTypeApplicabilityData> fileTypeApplicabilityDataMap = new HashMap<String, FileTypeApplicabilityData>();
        ArtifactReadable globalPreferences = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)CoreArtifactTokens.GlobalPreferences).getArtifact();
        String preferences = (String)globalPreferences.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ProductLinePreferences, (Object)"");
        JsonNode preferencesJson = this.orcsApi.jaxRsApi().readTree(preferences);
        JsonNode commentStyles = preferencesJson.findValue("FileExtensionCommentStyle");
        Iterator iter = commentStyles.elements();
        while (iter.hasNext()) {
            JsonNode currNode = (JsonNode)iter.next();
            String fileExtension = currNode.findValue("FileExtension").asText();
            String commentPrefixRegex = currNode.findValue("CommentPrefixRegex").asText();
            JsonNode optionalSuffixRegex = currNode.findValue("CommentSuffixRegex");
            String commentSuffixRegex = optionalSuffixRegex == null ? "" : optionalSuffixRegex.asText();
            Pattern pattern = this.createFullPatternFromCommentStyle(commentPrefixRegex, commentSuffixRegex);
            String commentPrefix = currNode.findValue("CommentPrefix").asText();
            JsonNode optionalSuffix = currNode.findValue("CommentSuffix");
            String commentSuffix = optionalSuffix == null ? "" : optionalSuffix.asText();
            FileTypeApplicabilityData data = new FileTypeApplicabilityData(pattern, commentPrefix, commentSuffix);
            fileTypeApplicabilityDataMap.put(fileExtension, data);
        }
        return fileTypeApplicabilityDataMap;
    }

    private Pattern createFullPatternFromCommentStyle(String commentPrefix, String commentSuffix) {
        String commentedFeatureStart = "( *" + commentPrefix + BEGINFEATURE + SPACES + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedFeatureEnd = "( *" + commentPrefix + ENDFEATURE + SPACES + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String pattern = String.valueOf(commentedFeatureStart) + "|" + commentedFeatureEnd;
        return Pattern.compile(pattern, 40);
    }
}

