/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OrcsTypeJoin;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.internal.CreateDemoBranches;
import org.eclipse.osee.orcs.core.internal.CreateSystemBranches;
import org.eclipse.osee.orcs.core.internal.admin.FetchDatastoreMetadataCallable;
import org.eclipse.osee.orcs.core.internal.admin.MigrateDatastoreAdminCallable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsAdminImpl
implements OrcsAdmin {
    private final OrcsApi orcsApi;
    private final Log logger;
    private final OrcsSession session;
    private final DataStoreAdmin dataStoreAdmin;
    private final QueryBuilder fromCommon;
    private final JdbcClient jdbcClient;

    public OrcsAdminImpl(OrcsApi orcsApi, Log logger, OrcsSession session, DataStoreAdmin dataStoreAdmin) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.session = session;
        this.dataStoreAdmin = dataStoreAdmin;
        this.fromCommon = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        this.jdbcClient = dataStoreAdmin.getJdbcClient();
    }

    public TransactionId createDatastoreAndSystemBranches(String typeModel) {
        ActivityLog activityLog = this.orcsApi.getActivityLog();
        try {
            activityLog.setEnabled(false);
            typeModel = String.valueOf(typeModel) + OseeInf.getResourceContents((String)"OseeTypes_Framework.osee", this.getClass());
            this.dataStoreAdmin.createDataStore();
            TransactionId transactionId = new CreateSystemBranches(this.orcsApi).create(typeModel);
            return transactionId;
        }
        finally {
            activityLog.setEnabled(true);
        }
    }

    public void registerMissingOrcsTypeJoins() {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (UserId)SystemUser.OseeSystem, "Add missing orcs type joins.");
        this.addMissingJoins(tx, CoreTupleTypes.ArtifactTypeJoin, this.orcsApi.tokenService().getArtifactTypeJoins());
        this.addMissingJoins(tx, CoreTupleTypes.AttributeTypeJoin, this.orcsApi.tokenService().getAttributeTypeJoins());
        this.addMissingJoins(tx, CoreTupleTypes.RelationTypeJoin, this.orcsApi.tokenService().getRelationTypeJoins());
        tx.commit();
    }

    private <J extends OrcsTypeJoin<J, T>, T extends NamedId> void addMissingJoins(TransactionBuilder tx, Tuple2Type<J, T> tupleType, Collection<J> registeredJoins) {
        ArrayList joinsInDb = new ArrayList();
        this.orcsApi.getQueryFactory().tupleQuery().getTuple2UniqueE1(tupleType, (BranchId)CoreBranches.COMMON, joinsInDb::add);
        for (OrcsTypeJoin join : registeredJoins) {
            if (joinsInDb.contains(join)) continue;
            tx.addOrcsTypeJoin(join);
        }
    }

    public void createSynonymsAndGrants() {
        for (String table : Arrays.asList("OSEE_ACCOUNT_SESSION", "OSEE_ACTIVITY", "OSEE_ACTIVITY_TYPE", "OSEE_ARTIFACT", "OSEE_ARTIFACT_ACL", "OSEE_ATTRIBUTE", "OSEE_BRANCH", "OSEE_BRANCH_ACL", "OSEE_CONFLICT", "OSEE_IMPORT_INDEX_MAP", "OSEE_IMPORT_MAP", "OSEE_IMPORT_SAVE_POINT", "OSEE_IMPORT_SOURCE", "OSEE_INFO", "OSEE_JOIN_ARTIFACT", "OSEE_JOIN_CHAR_ID", "OSEE_JOIN_CLEANUP", "OSEE_JOIN_EXPORT_IMPORT", "OSEE_JOIN_ID", "OSEE_JOIN_ID4", "OSEE_JOIN_TRANSACTION", "OSEE_KEY_VALUE", "OSEE_MERGE", "OSEE_OAUTH_AUTHORIZATION", "OSEE_OAUTH_CLIENT_CREDENTIAL", "OSEE_OAUTH_TOKEN", "OSEE_PERMISSION", "OSEE_RELATION_LINK", "OSEE_SCHEMA_VERSION", "OSEE_SEARCH_TAGS", "OSEE_SEQUENCE", "OSEE_SERVER_LOOKUP", "OSEE_SESSION", "OSEE_TAG_GAMMA_QUEUE", "OSEE_TUPLE2", "OSEE_TUPLE3", "OSEE_TUPLE4", "OSEE_TXS", "OSEE_TXS_ARCHIVED", "OSEE_TX_DETAILS")) {
            try {
                this.jdbcClient.runCall("create public synonym " + table + " for " + table, new Object[0]);
            }
            catch (Exception exception) {
                XConsoleLogger.err((String)("Error creating synonym for table " + table), (Object[])new Object[0]);
            }
            try {
                this.jdbcClient.runCall("grant insert, update, delete, select on " + table + " to osee_client_role", new Object[0]);
            }
            catch (Exception exception) {
                XConsoleLogger.err((String)("Error granting permissions for table " + table), (Object[])new Object[0]);
            }
        }
    }

    public void createDemoBranches() {
        new CreateDemoBranches(this.orcsApi).populate();
    }

    public Callable<OrcsMetaData> migrateDatastore() {
        return new MigrateDatastoreAdminCallable(this.logger, this.session, this.dataStoreAdmin);
    }

    public Callable<OrcsMetaData> createFetchOrcsMetaData() {
        return new FetchDatastoreMetadataCallable(this.logger, this.session, this.dataStoreAdmin);
    }

    public boolean isDataStoreInitialized() {
        try {
            this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{CoreArtifactTokens.DefaultHierarchyRoot});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void requireRole(UserId user, ArtifactId role) {
        if (!this.fromCommon.andId(role).andRelatedTo(CoreRelationTypes.Users_User, role).exists()) {
            throw new OseeAccessDeniedException("User [%s] not in user group [%s]", new Object[]{user, role});
        }
    }

    public void createUsers(TransactionBuilder tx, Iterable<UserToken> users) {
        ArtifactToken userGroupHeader;
        if (tx.getAuthor().notEqual((Id)SystemUser.OseeSystem)) {
            this.requireRole(tx.getAuthor(), (ArtifactId)CoreUserGroups.OseeAdmin);
        }
        if ((userGroupHeader = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)CoreArtifactTokens.UserGroups).getArtifactOrNull()) == null) {
            ArtifactToken oseeConfig = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)CoreArtifactTokens.OseeConfiguration).getArtifactOrNull();
            userGroupHeader = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.UserGroups);
        }
        HashMap<ArtifactToken, ArtifactToken> userGroupToArtifact = new HashMap<ArtifactToken, ArtifactToken>();
        List defaultGroups = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andAttributeIs((AttributeTypeId)CoreAttributeTypes.DefaultGroup, "true").getResults().getList();
        List existingUsers = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).getResults().getList();
        for (UserToken userToken : users) {
            ArtifactToken userGroupArt;
            if (existingUsers.contains(userToken)) {
                throw new OseeStateException("User %s already exists", new Object[]{userToken});
            }
            ArtifactToken user = tx.createArtifact((ArtifactToken)userToken);
            tx.setSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)userToken.isActive());
            tx.setSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.UserId, (Object)userToken.getUserId());
            tx.setSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.Email, (Object)userToken.getEmail());
            Collection roles = userToken.getRoles();
            for (ArtifactToken userGroup : roles) {
                userGroupArt = this.getOrCreate(userGroup, userGroupToArtifact, tx, userGroupHeader);
                tx.relate((ArtifactId)userGroupArt, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)user);
            }
            for (ArtifactToken userGroup : defaultGroups) {
                userGroupArt = this.getOrCreate(userGroup, userGroupToArtifact, tx, userGroupHeader);
                tx.relate((ArtifactId)userGroupArt, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)user);
            }
            this.setUserInfo(tx, userToken, defaultGroups);
        }
    }

    private ArtifactToken getOrCreate(ArtifactToken userGroup, Map<ArtifactToken, ArtifactToken> userGroupToArtifact, TransactionBuilder tx, ArtifactToken userGroupHeader) {
        ArtifactToken userGroupArt = userGroupToArtifact.get(userGroup);
        if (userGroupArt == null) {
            userGroupArt = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)userGroup).getArtifactOrNull();
        }
        if (userGroupArt == null) {
            userGroupArt = tx.createArtifact(userGroup);
            tx.addChild((ArtifactId)userGroupHeader, (ArtifactId)userGroupArt);
        }
        userGroupToArtifact.put(userGroup, userGroupArt);
        return userGroupArt;
    }

    public void createUser(TransactionBuilder tx, UserToken userToken) {
        if (tx.getAuthor().notEqual((Id)SystemUser.OseeSystem)) {
            this.requireRole(tx.getAuthor(), (ArtifactId)CoreUserGroups.OseeAdmin);
        }
        List defaultGroups = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andAttributeIs((AttributeTypeId)CoreAttributeTypes.DefaultGroup, "true").asArtifactIds();
        this.setUserInfo(tx, userToken, defaultGroups);
    }

    private void setUserInfo(TransactionBuilder tx, UserToken userToken, List<? extends ArtifactId> defaultGroups) {
        ArtifactToken userId = tx.createArtifact((ArtifactToken)userToken);
        tx.setSoleAttributeValue((ArtifactId)userId, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)userToken.isActive());
        tx.setSoleAttributeValue((ArtifactId)userId, (AttributeTypeToken)CoreAttributeTypes.UserId, (Object)userToken.getUserId());
        tx.setSoleAttributeValue((ArtifactId)userId, (AttributeTypeToken)CoreAttributeTypes.Email, (Object)userToken.getEmail());
        for (ArtifactToken artifactToken : userToken.getRoles()) {
            tx.relate((ArtifactId)artifactToken, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)userId);
        }
        for (ArtifactId artifactId : defaultGroups) {
            tx.relate(artifactId, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)userId);
        }
        for (String string : userToken.getLoginIds()) {
            tx.createAttribute((ArtifactId)userToken, (AttributeTypeToken)CoreAttributeTypes.LoginId, (Object)string);
        }
    }

    public void changeArtifactTypeOutsideofHistory(ArtifactTypeId artifactType, List<? extends ArtifactId> artifacts) {
        String sql = "UPDATE osee_artifact SET art_type_id = ? WHERE art_id = ?";
        OseePreparedStatement batchStatement = this.jdbcClient.getBatchStatement(sql);
        artifacts.forEach(art -> batchStatement.addToBatch((Object)artifactType, art));
        batchStatement.execute();
    }

    public void updateBootstrapUser(UserId accountId) {
        this.dataStoreAdmin.updateBootstrapUser(accountId);
    }
}

