/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osee.orcs.core.ds.Criteria;

public class CriteriaSet
implements Cloneable,
Iterable<Criteria> {
    private final SetMultimap<Class<? extends Criteria>, Criteria> criterias = LinkedHashMultimap.create();

    public void add(Criteria criteria) {
        this.criterias.put(criteria.getClass(), (Object)criteria);
    }

    public boolean remove(Criteria criteria) {
        return this.criterias.remove(criteria.getClass(), (Object)criteria);
    }

    public Collection<Criteria> getCriterias() {
        return this.criterias.values();
    }

    public void reset() {
        this.criterias.clear();
    }

    public <T extends Criteria> Set<T> getCriteriaByType(Class<T> type) {
        return this.criterias.get(type);
    }

    public boolean hasCriteriaType(Class<? extends Criteria> type) {
        Set set = this.criterias.get(type);
        return set != null && !set.isEmpty();
    }

    public CriteriaSet clone() {
        CriteriaSet clone = new CriteriaSet();
        clone.criterias.putAll(this.criterias);
        return clone;
    }

    @Override
    public Iterator<Criteria> iterator() {
        return this.getCriterias().iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("criterias=[");
        builder.append(this.criterias.values());
        builder.append("]");
        return builder.toString();
    }
}

