/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.operation;

import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.access.operation.AccessCache;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;

public class UserGroupOperations {
    private final AccessCache cache;
    private final IAccessControlService accessService;

    public UserGroupOperations(AccessCache cache, IAccessControlService accessService) {
        this.cache = cache;
        this.accessService = accessService;
    }

    public void populateUserGroupList() {
        for (ArtifactToken userGroupArt : this.accessService.getArtifactListFromType(CoreArtifactTypes.UserGroup, CoreBranches.COMMON)) {
            IUserGroup userGroup = this.accessService.getUserGroupService().getUserGroup(userGroupArt);
            this.cache.idToUserGroup.put(userGroup.getId(), userGroup);
        }
    }

    public void populateGroupMembersEntry(ArtifactId groupId, ArtifactId groupMember) {
        this.cache.subjectToGroupCache.put((Object)groupMember.getId(), (Object)groupId);
        this.cache.groupToSubjectsCache.put((Object)groupId.getId(), (Object)groupMember);
    }
}

