/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.operation;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.access.AccessControlData;
import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.access.event.AccessArtifactLockTopicEvent;
import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.access.object.ArtifactAccessObject;
import org.eclipse.osee.framework.core.access.operation.AccessCache;
import org.eclipse.osee.framework.core.access.operation.AccessRankOperations;
import org.eclipse.osee.framework.core.access.operation.IAccessStoreOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class ArtifactAclOperations {
    private final AccessCache cache;
    private final IAccessStoreOperations storeOps;
    private final AccessRankOperations rankOps;
    private final IAccessControlService accessService;

    public ArtifactAclOperations(AccessCache cache, IAccessStoreOperations storeOps, IAccessControlService accessService, AccessRankOperations rankOps) {
        this.cache = cache;
        this.storeOps = storeOps;
        this.accessService = accessService;
        this.rankOps = rankOps;
    }

    public XResultData hasArtifactAclPermission(ArtifactToken artifact, PermissionEnum permission, XResultData rd) {
        return this.hasArtifactAclPermission(this.accessService.getUser(), artifact, permission, rd);
    }

    public XResultData hasArtifactAclPermission(ArtifactToken subject, Collection<? extends ArtifactToken> artifacts, PermissionEnum permission, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        for (ArtifactToken artifactToken : artifacts) {
            this.hasArtifactAclPermission(subject, artifactToken, permission, rd);
        }
        return rd;
    }

    public XResultData hasArtifactAclPermission(ArtifactToken subject, ArtifactToken artifact, PermissionEnum permission, XResultData rd) {
        if (rd == null) {
            rd = new XResultData();
        }
        if (!this.accessService.isInDb(artifact)) {
            rd.logf("Artifact ACL: Subject [%s] DOES have [%s] access for artifact %s with permission [%s]\n", new Object[]{subject.getName(), permission, artifact.toStringWithId(), "Artifact Not In Db"});
            return rd;
        }
        BranchToken branch = artifact.getBranch();
        if (this.cache.artifactLockCache.containsKey((Object)branch, (Object)artifact)) {
            ArtifactId lockOwnerId = (ArtifactId)this.cache.artifactLockCache.get((Object)branch, (Object)artifact);
            if (subject.equals(lockOwnerId)) {
                rd.logf("Artifact ACL: Subject [%s] DOES have [%s] access for branch %s; permission [%s]\n", new Object[]{subject.getName(), permission, branch.toStringWithId(), PermissionEnum.USER_LOCK});
                return rd;
            }
            if (permission == PermissionEnum.WRITE || permission == PermissionEnum.FULLACCESS) {
                rd.errorf("Artifact ACL: Subject [%s] DOES NOT have [%s] access for branch %s; permission [%s]\n", new Object[]{subject.getName(), permission, branch.toStringWithId(), PermissionEnum.USER_LOCK});
                return rd;
            }
            rd.logf("Artifact ACL: Subject [%s] DOES have [%s] access for branch %s; permission [%s]\n", new Object[]{subject.getName(), permission, branch.toStringWithId(), PermissionEnum.USER_LOCK});
            return rd;
        }
        rd.logf("Artifact ACL: Subject [%s] DOES have [%s] access for artifact %s with permission [%s]\n", new Object[]{subject.getName(), permission, artifact.toStringWithId(), PermissionEnum.FULLACCESS});
        return rd;
    }

    public PermissionEnum getArtifactPermission(ArtifactToken subject, ArtifactToken artifact) {
        ArtifactId lockOwnerId;
        PermissionEnum userPermission = PermissionEnum.FULLACCESS;
        ArtifactAccessObject accessObject = null;
        if (!this.accessService.isInDb(artifact)) {
            return PermissionEnum.FULLACCESS;
        }
        BranchToken branch = artifact.getBranch();
        accessObject = ArtifactAccessObject.valueOf(artifact);
        if (this.cache.artifactLockCache.containsKey((Object)branch, (Object)artifact) && subject.notEqual(lockOwnerId = (ArtifactId)this.cache.artifactLockCache.get((Object)branch, (Object)artifact))) {
            userPermission = PermissionEnum.USER_LOCK;
        }
        userPermission = accessObject == null ? PermissionEnum.FULLACCESS : this.rankOps.acquirePermissionRank(subject, accessObject);
        return userPermission;
    }

    public void populateArtifactAccessControlListEntry(ArtifactId subjectId, ArtifactId artifactId, BranchId branchId, PermissionEnum permission, ArtifactTypeToken subjectArtifactType) {
        if (permission != null) {
            if (permission.equals((Object)PermissionEnum.USER_LOCK)) {
                this.cache.artifactLockCache.put((Object)branchId, (Object)artifactId, (Object)subjectId);
            } else {
                ArtifactAccessObject accessObject = ArtifactAccessObject.valueOf(ArtifactToken.valueOf((long)artifactId.getId(), "unknown", branchId));
                this.cache.cacheAccessObject(subjectId, permission, accessObject);
                if (subjectArtifactType.inheritsFrom(CoreArtifactTypes.UserGroup)) {
                    this.accessService.populateGroupMembers(subjectId);
                }
            }
        }
    }

    public void lockArtifacts(ArtifactToken subject, Collection<? extends ArtifactToken> artifacts) {
        Conditions.checkNotNull((Object)subject, (String)"subject");
        Conditions.checkNotNullOrEmpty(artifacts, (String)"artifacts");
        AccessArtifactLockTopicEvent event = new AccessArtifactLockTopicEvent();
        event.setBranch(artifacts.iterator().next().getBranch());
        event.setLocked(true);
        HashSet<ArtifactToken> lockedArts = new HashSet<ArtifactToken>();
        for (ArtifactToken artifactToken : artifacts) {
            BranchToken objectBranch = artifactToken.getBranch();
            if (this.cache.artifactLockCache.containsKey((Object)objectBranch, (Object)artifactToken)) continue;
            AccessObject accessObject = AccessObject.valueOf(artifactToken);
            AccessControlData data = new AccessControlData(subject, accessObject, PermissionEnum.USER_LOCK, true);
            this.storeOps.persistPermission(data);
            this.cache.artifactLockCache.put((Object)objectBranch, (Object)artifactToken, (Object)subject);
            event.addArtifact(artifactToken.getUuid());
            lockedArts.add(artifactToken);
        }
        this.accessService.kickAccessTopicEvent(event);
    }

    public void unLockArtifacts(ArtifactToken subject, Collection<? extends ArtifactToken> artifacts) {
        AccessArtifactLockTopicEvent event = new AccessArtifactLockTopicEvent();
        event.setBranch(artifacts.iterator().next().getBranch());
        event.setLocked(false);
        HashSet<ArtifactToken> lockedArts = new HashSet<ArtifactToken>();
        for (ArtifactToken artifactToken : artifacts) {
            BranchToken branch = artifactToken.getBranch();
            boolean inCache = this.cache.artifactLockCache.containsKey((Object)branch, (Object)artifactToken);
            boolean canUnlockObject = this.canUnlockObject(subject, artifactToken);
            if (!inCache || !canUnlockObject) continue;
            AccessObject accessObject = AccessObject.valueOf(artifactToken);
            this.storeOps.removeAccessControlDataIf(true, new AccessControlData(subject, accessObject, PermissionEnum.USER_LOCK, false));
            this.cache.artifactLockCache.removeAndGet((Object)branch, (Object)artifactToken);
            event.addArtifact(artifactToken.getUuid());
            lockedArts.add(artifactToken);
        }
        this.accessService.kickAccessTopicEvent(event);
    }

    public boolean hasLock(ArtifactToken artifact) {
        if (!this.accessService.isInDb(artifact)) {
            return false;
        }
        return this.cache.artifactLockCache.containsKey((Object)artifact.getBranch(), (Object)artifact);
    }

    public boolean canUnlockObject(ArtifactToken subject, ArtifactToken artifact) {
        ArtifactId subjectId = (ArtifactId)this.cache.artifactLockCache.get((Object)artifact.getBranch(), (Object)artifact);
        return subject.equals(subjectId);
    }

    public ArtifactToken getSubjectFromLockedObject(ArtifactToken artifact) {
        ArtifactToken subject = ArtifactToken.SENTINEL;
        ArtifactId subjectArtId = (ArtifactId)this.cache.artifactLockCache.get((Object)artifact.getBranch(), (Object)artifact);
        if (subjectArtId != null) {
            subject = this.accessService.getUserByArtId(subjectArtId);
        }
        return subject;
    }
}

