/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.config;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.SkipAtsConfigJsonWriter;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactImage;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;

@Path(value="config")
public interface AtsConfigEndpointApi {
    @GET
    @Produces(value={"application/json"})
    public AtsConfigurations get();

    @POST
    public XResultData createUpdateConfig();

    @GET
    @Path(value="fromdb")
    @Produces(value={"application/json"})
    public AtsConfigurations getWithPend();

    @GET
    @Path(value="user/{loginId}")
    @Produces(value={"application/json"})
    public AtsUser getUserByLogin(@PathParam(value="loginId") String var1);

    @GET
    @Path(value="image")
    @Produces(value={"application/json"})
    public List<ArtifactImage> getArtifactImages();

    @GET
    @Path(value="clearcache")
    @Produces(value={"application/json"})
    public String requestCacheReload();

    @GET
    @Path(value="ui/NewAtsBranchConfig")
    @Produces(value={"text/html"})
    public ViewModel getNewSource();

    @GET
    @Path(value="genAttrTypeViews")
    @Produces(value={"application/json"})
    public List<AtsAttributeValueColumn> generateAttrTypeViews() throws Exception;

    @GET
    @Path(value="alive")
    @Produces(value={"application/json"})
    public XResultData alive();

    @PUT
    @Path(value="init/demo")
    @Produces(value={"application/json"})
    public XResultData demoDbInit();

    @PUT
    @Path(value="init/ats")
    @Produces(value={"application/json"})
    public XResultData atsDbInit();

    @GET
    @SkipAtsConfigJsonWriter
    @Path(value="ai/{aiId}")
    @Produces(value={"application/json"})
    public ActionableItem getActionableItem(@PathParam(value="aiId") ArtifactId var1);

    @GET
    @SkipAtsConfigJsonWriter
    @Path(value="version/{verId}")
    @Produces(value={"application/json"})
    public Version getVersion(@PathParam(value="verId") ArtifactId var1);

    @GET
    @SkipAtsConfigJsonWriter
    @Path(value="teamdef/{teamDefId}")
    @Produces(value={"application/json"})
    public TeamDefinition getTeamDefinition(@PathParam(value="teamDefId") ArtifactId var1);

    @POST
    @Path(value="initialize/demo")
    @Produces(value={"application/json"})
    public TransactionId demoInitilize();

    @GET
    @Path(value="validate")
    @Produces(value={"application/json"})
    public XResultData validate();

    @GET
    @Path(value="test/result")
    @Produces(value={"application/json"})
    public XResultData getResultTableTest();

    @POST
    @Path(value="branch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BranchData createBranch(BranchData var1);
}

